/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm.naming;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import org.apache.openejb.Injection;
import org.apache.openejb.core.ivm.naming.Reference;
import org.apache.openejb.core.webservices.HandlerChainData;
import org.apache.openejb.core.webservices.HandlerResolverImpl;
import org.apache.openejb.core.webservices.PortAddress;
import org.apache.openejb.core.webservices.PortAddressRegistry;
import org.apache.openejb.core.webservices.PortRefData;
import org.apache.openejb.core.webservices.ProviderWrapper;
import org.apache.openejb.core.webservices.ServiceRefData;
import org.apache.openejb.loader.SystemInstance;

public class JaxWsServiceReference
extends Reference {
    private final String id;
    private final QName serviceQName;
    private final QName portQName;
    private final Class<? extends Service> serviceClass;
    private final Class<?> referenceClass;
    private final URL wsdlUrl;
    private final List<HandlerChainData> handlerChains = new ArrayList<HandlerChainData>();
    private final Collection<Injection> injections;
    private PortAddressRegistry portAddressRegistry;
    private final List<PortRefData> portRefs = new ArrayList<PortRefData>();

    public JaxWsServiceReference(String id, QName serviceQName, Class<? extends Service> serviceClass, QName portQName, Class<?> referenceClass, URL wsdlUrl, List<PortRefData> portRefs, List<HandlerChainData> handlerChains, Collection<Injection> injections) {
        this.id = id;
        this.serviceQName = serviceQName;
        this.serviceClass = serviceClass;
        this.portQName = portQName;
        this.referenceClass = referenceClass;
        this.wsdlUrl = wsdlUrl;
        if (portRefs != null) {
            this.portRefs.addAll(portRefs);
        }
        if (handlerChains != null) {
            this.handlerChains.addAll(handlerChains);
        }
        this.injections = injections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject() throws NamingException {
        Service instance;
        QName serviceQName;
        URL wsdlUrl;
        block14: {
            PortRefData port;
            String referenceClassName = this.referenceClass != null ? this.referenceClass.getName() : null;
            Set<PortAddress> portAddresses = this.getPortAddressRegistry().getPorts(this.id, this.serviceQName, referenceClassName);
            wsdlUrl = this.wsdlUrl;
            serviceQName = this.serviceQName;
            if (portAddresses.size() == 1) {
                PortAddress portAddress = portAddresses.iterator().next();
                try {
                    wsdlUrl = new URL(portAddress.getAddress() + "?wsdl");
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                serviceQName = portAddress.getServiceQName();
            }
            HashMap<QName, PortRefData> portsByQName = new HashMap<QName, PortRefData>();
            ArrayList<PortRefData> ports = new ArrayList<PortRefData>(this.portRefs.size() + portAddresses.size());
            for (PortRefData portRef : this.portRefs) {
                port = new PortRefData(portRef);
                if (port.getQName() != null) {
                    portsByQName.put(port.getQName(), port);
                }
                ports.add(port);
            }
            for (PortAddress portAddress : portAddresses) {
                port = (PortRefData)portsByQName.get(portAddress.getPortQName());
                if (port == null) {
                    port = new PortRefData();
                    port.setQName(portAddress.getPortQName());
                    port.setServiceEndpointInterface(portAddress.getServiceEndpointInterface());
                    port.getAddresses().add(portAddress.getAddress());
                    ports.add(port);
                    continue;
                }
                port.getAddresses().add(portAddress.getAddress());
                if (port.getServiceEndpointInterface() != null) continue;
                port.setServiceEndpointInterface(portAddress.getServiceEndpointInterface());
            }
            ProviderWrapper.beforeCreate(ports);
            try {
                instance = null;
                if (Service.class.equals(this.serviceClass)) {
                    instance = Service.create((URL)wsdlUrl, (QName)serviceQName);
                    break block14;
                }
                try {
                    instance = this.serviceClass.getConstructor(URL.class, QName.class).newInstance(wsdlUrl, serviceQName);
                }
                catch (Throwable e) {
                    throw (NamingException)new NamingException("Could not instantiate jax-ws service class " + this.serviceClass.getName()).initCause(e);
                }
            }
            finally {
                ProviderWrapper.afterCreate();
            }
        }
        if (!this.handlerChains.isEmpty()) {
            HandlerResolverImpl handlerResolver = new HandlerResolverImpl(this.handlerChains, this.injections, new InitialContext());
            instance.setHandlerResolver((HandlerResolver)handlerResolver);
        }
        Object port = this.referenceClass != null && !Service.class.isAssignableFrom(this.referenceClass) ? instance.getPort(this.referenceClass) : instance;
        ServiceRefData serviceRefData = new ServiceRefData(this.id, serviceQName, this.serviceClass, this.portQName, this.referenceClass, wsdlUrl, this.handlerChains, this.portRefs);
        ServiceRefData.putServiceRefData(port, serviceRefData);
        return port;
    }

    private PortAddressRegistry getPortAddressRegistry() {
        if (this.portAddressRegistry == null) {
            this.portAddressRegistry = (PortAddressRegistry)SystemInstance.get().getComponent(PortAddressRegistry.class);
        }
        return this.portAddressRegistry;
    }
}

