/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.javaagent;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Agent {
    private static final Permission ACCESS_PERMISSION = new ReflectPermission("suppressAccessChecks");
    private static String agentArgs;
    private static Instrumentation instrumentation;
    private static boolean initialized;

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        if (Agent.instrumentation != null) {
            return;
        }
        Agent.agentArgs = agentArgs;
        Agent.instrumentation = instrumentation;
        initialized = true;
        instrumentation.addTransformer(new BootstrapTransformer());
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        if (Agent.instrumentation != null) {
            return;
        }
        Agent.agentArgs = agentArgs;
        Agent.instrumentation = instrumentation;
        initialized = true;
    }

    public static synchronized String getAgentArgs() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_PERMISSION);
        }
        Agent.checkInitialization();
        return agentArgs;
    }

    public static synchronized Instrumentation getInstrumentation() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_PERMISSION);
        }
        Agent.checkInitialization();
        return instrumentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void checkInitialization() {
        if (!initialized) {
            try {
                Agent.checkSystemClassPath();
                Agent.dynamicLoadAgent();
            }
            catch (Exception e) {
                new IllegalStateException("Unable to initialize agent", e).printStackTrace();
            }
            finally {
                initialized = true;
            }
        }
    }

    private static void checkSystemClassPath() throws NoSuchFieldException, IllegalAccessException {
        if (instrumentation != null) {
            return;
        }
        Class<?> systemAgentClass = null;
        try {
            ClassLoader systemCl = ClassLoader.getSystemClassLoader();
            systemAgentClass = systemCl.loadClass(Agent.class.getName());
        }
        catch (ClassNotFoundException e) {
            return;
        }
        Field instrumentationField = systemAgentClass.getDeclaredField("instrumentation");
        instrumentationField.setAccessible(true);
        instrumentation = (Instrumentation)instrumentationField.get(null);
        Field agentArgsField = systemAgentClass.getDeclaredField("agentArgs");
        agentArgsField.setAccessible(true);
        agentArgs = (String)agentArgsField.get(null);
    }

    private static void dynamicLoadAgent() throws Exception {
        if (instrumentation != null) {
            return;
        }
        try {
            Class<?> vmClass = Class.forName("com.sun.tools.attach.VirtualMachine");
            Method attachMethod = vmClass.getMethod("attach", String.class);
            Method loadAgentMethod = vmClass.getMethod("loadAgent", String.class);
            String agentPath = Agent.getAgentJar();
            String pid = Agent.getPid();
            Object vm = attachMethod.invoke(null, (Object[])new String[]{pid});
            loadAgentMethod.invoke(vm, agentPath);
            Agent.checkSystemClassPath();
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private static String getPid() {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        String pid = bean.getName();
        if (pid.indexOf("@") != -1) {
            pid = pid.substring(0, pid.indexOf("@"));
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAgentJar() throws IOException {
        Object buffer;
        URL resource = Agent.class.getClassLoader().getResource(Agent.class.getName().replace('.', '/') + ".class");
        if (resource == null) {
            throw new IllegalStateException("Could not find Agent class file in class path");
        }
        URLConnection urlConnection = resource.openConnection();
        if (urlConnection instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
            return jarURLConnection.getJarFile().getName();
        }
        InputStream in = urlConnection.getInputStream();
        ZipOutputStream out = null;
        File file = null;
        try {
            file = File.createTempFile(Agent.class.getName(), ".jar");
            file.deleteOnExit();
            out = new ZipOutputStream(new FileOutputStream(file));
            out.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            try {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
                writer.println("Agent-Class: " + Agent.class.getName());
                writer.println("Can-Redefine-Classes: true");
                writer.println("Can-Retransform-Classes: true");
                writer.flush();
            }
            finally {
                out.closeEntry();
            }
            out.putNextEntry(new ZipEntry(Agent.class.getName().replace('.', '/') + ".class"));
            try {
                buffer = new byte[4096];
                int count = in.read((byte[])buffer);
                while (count >= 0) {
                    out.write((byte[])buffer, 0, count);
                    count = in.read((byte[])buffer);
                }
            }
            finally {
                out.closeEntry();
            }
            buffer = file.getAbsolutePath();
        }
        catch (IOException e) {
            try {
                if (file != null) {
                    file.delete();
                }
                throw e;
            }
            catch (Throwable throwable) {
                Agent.close(in);
                Agent.close(out);
                throw throwable;
            }
        }
        Agent.close(in);
        Agent.close(out);
        return buffer;
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        initialized = false;
    }

    private static class BootstrapTransformer
    implements ClassFileTransformer {
        private boolean done;

        private BootstrapTransformer() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            try {
                this.bootstrap(loader);
            }
            catch (Throwable e) {
                this.done = true;
            }
            return classfileBuffer;
        }

        private void bootstrap(ClassLoader loader) {
            if (loader == null || this.done) {
                return;
            }
            String bootstrapClassName = "org.apache.openejb.persistence.PersistenceBootstrap";
            String bootstrapClassFile = "org/apache/openejb/persistence/PersistenceBootstrap.class";
            if (loader.getResource(bootstrapClassFile) == null) {
                return;
            }
            this.done = true;
            try {
                Class<?> bootstrapClass = loader.loadClass(bootstrapClassName);
                Method bootstrap = bootstrapClass.getMethod("bootstrap", ClassLoader.class);
                bootstrap.invoke(null, loader);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }
}

