/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.security.jaas;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.openejb.core.security.jaas.GroupPrincipal;
import org.apache.openejb.core.security.jaas.UserPrincipal;
import org.apache.openejb.util.ConfUtils;
import org.apache.openejb.util.IOUtils;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class PropertiesLoginModule
implements LoginModule {
    private final String USER_FILE = "UsersFile";
    private final String GROUP_FILE = "GroupsFile";
    private static Logger log = Logger.getInstance(LogCategory.OPENEJB_SECURITY, "org.apache.openejb.util.resources");
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean debug;
    private Properties users = new Properties();
    private Properties groups = new Properties();
    private String user;
    private Set principals = new LinkedHashSet();
    private URL usersUrl;
    private URL groupsUrl;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.debug = log.isDebugEnabled() || "true".equalsIgnoreCase((String)options.get("Debug"));
        String usersFile = (String)options.get("UsersFile") + "";
        String groupsFile = (String)options.get("GroupsFile") + "";
        this.usersUrl = ConfUtils.getConfResource(usersFile);
        this.groupsUrl = ConfUtils.getConfResource(groupsFile);
        if (this.debug) {
            log.debug("Users file: " + this.usersUrl.toExternalForm());
            log.debug("Groups file: " + this.groupsUrl.toExternalForm());
        }
    }

    @Override
    public boolean login() throws LoginException {
        String password;
        try {
            this.users = IOUtils.readProperties(this.usersUrl);
        }
        catch (IOException ioe) {
            throw new LoginException("Unable to load user properties file " + this.usersUrl.getFile());
        }
        try {
            this.groups = IOUtils.readProperties(this.groupsUrl);
        }
        catch (IOException ioe) {
            throw new LoginException("Unable to load group properties file " + this.groupsUrl.getFile());
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        if ((password = this.users.getProperty(this.user)) == null) {
            throw new FailedLoginException("User does not exist");
        }
        if (!password.equals(new String(tmpPassword))) {
            throw new FailedLoginException("Password does not match");
        }
        this.users.clear();
        if (this.debug) {
            log.debug("Logged in as '" + this.user + "'");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.principals.add(new UserPrincipal(this.user));
        Enumeration<Object> enumeration = this.groups.keys();
        block0: while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String[] userList = (this.groups.getProperty(name) + "").split(",");
            for (int i = 0; i < userList.length; ++i) {
                if (!this.user.equals(userList[i])) continue;
                this.principals.add(new GroupPrincipal(name));
                continue block0;
            }
        }
        this.subject.getPrincipals().addAll(this.principals);
        this.clear();
        if (this.debug) {
            log.debug("commit");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            log.debug("abort");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        if (this.debug) {
            log.debug("logout");
        }
        return true;
    }

    private void clear() {
        this.groups.clear();
        this.user = null;
    }
}

