/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.bval;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.openejb.core.ThreadContext;

public final class ValidatorUtil {
    private ValidatorUtil() {
    }

    public static ValidatorFactory validatorFactory() {
        try {
            return (ValidatorFactory)new InitialContext().lookup("java:comp/ValidatorFactory");
        }
        catch (NamingException e) {
            return ValidatorUtil.proxy(ValidatorFactory.class, "java:comp/ValidatorFactory");
        }
    }

    public static Validator validator() {
        try {
            return (Validator)new InitialContext().lookup("java:comp/Validator");
        }
        catch (NamingException e) {
            return ValidatorUtil.proxy(Validator.class, "java:comp/Validator");
        }
    }

    private static <T> T proxy(final Class<T> t, final String jndi) {
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{t}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (Object.class.equals(method.getDeclaringClass())) {
                    return method.invoke((Object)this, new Object[0]);
                }
                ThreadContext ctx = ThreadContext.getThreadContext();
                if (ctx != null) {
                    return method.invoke(ctx.getBeanContext().getJndiContext().lookup(jndi), args);
                }
                return null;
            }

            public String toString() {
                return "Proxy::" + t.getName();
            }
        });
    }
}

