/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.plugin.DataSourcePlugin;
import org.apache.xbean.finder.ResourceFinder;

public class InstantdbDataSourcePlugin
implements DataSourcePlugin {
    @Override
    public String updatedUrl(String jdbcUrl) {
        String prefix = "jdbc:idb:";
        int index = jdbcUrl.indexOf(prefix);
        if (index == -1) {
            return jdbcUrl;
        }
        String confFile = jdbcUrl.substring(index + prefix.length());
        File base = SystemInstance.get().getBase().getDirectory();
        File file = new File(base, confFile);
        if (file.exists()) {
            return jdbcUrl;
        }
        if (!file.getParentFile().exists()) {
            return jdbcUrl;
        }
        try {
            ResourceFinder finder = new ResourceFinder("");
            String defaultProperties = finder.findString("default.instantdb.properties");
            IO.copy((byte[])defaultProperties.getBytes(), (File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jdbcUrl;
    }

    @Override
    public boolean enableUserDirHack() {
        return true;
    }
}

