/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.markdown.tasks;

import org.eclipse.vorto.codegen.api.AbstractTemplateGeneratorTask;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.markdown.templates.MarkdownEntityTemplate;
import org.eclipse.vorto.codegen.markdown.templates.MarkdownEnumTemplate;
import org.eclipse.vorto.codegen.markdown.templates.MarkdownFunctionBlockTemplate;
import org.eclipse.vorto.codegen.markdown.templates.MarkdownInformationModelTemplate;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;

public class MarkdownInformationModelGeneratorTask
extends AbstractTemplateGeneratorTask<InformationModel> {
    private String markdownFileExtension;
    private String targetPath;

    public MarkdownInformationModelGeneratorTask(String markdownFileExtension, String targetPath) {
        this.markdownFileExtension = markdownFileExtension;
        this.targetPath = targetPath;
    }

    public String getFileName(InformationModel im) {
        return String.valueOf(im.getName()) + this.markdownFileExtension;
    }

    public String getPath(InformationModel im) {
        return this.targetPath;
    }

    public ITemplate<InformationModel> getTemplate() {
        MarkdownFunctionBlockTemplate fbTemplate = new MarkdownFunctionBlockTemplate();
        MarkdownEntityTemplate entityTemplate = new MarkdownEntityTemplate();
        MarkdownEnumTemplate enumTemplate = new MarkdownEnumTemplate();
        return new MarkdownInformationModelTemplate(fbTemplate, entityTemplate, enumTemplate);
    }

    public String getPlatform() {
        return "markdown";
    }
}

