/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.bosch.things;

import java.util.HashMap;
import org.eclipse.vorto.codegen.api.ChainedCodeGeneratorTask;
import org.eclipse.vorto.codegen.api.GenerationResultZip;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IVortoCodeGenProgressMonitor;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.api.VortoCodeGeneratorException;
import org.eclipse.vorto.codegen.bosch.things.javaclient.JavaClientTask;
import org.eclipse.vorto.codegen.bosch.things.schema.SchemaValidatorTask;
import org.eclipse.vorto.codegen.utils.GenerationResultBuilder;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;

public class BoschIoTThingsGenerator
implements IVortoCodeGenerator {
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String SIMULATOR = "simulator";
    private static final String SCHEMAVALIDATOR = "validation";

    public IGenerationResult generate(InformationModel infomodel, InvocationContext invocationContext, IVortoCodeGenProgressMonitor monitor) throws VortoCodeGeneratorException {
        HashMap<String, String> props;
        GenerationResultZip zipOutputter = new GenerationResultZip(infomodel, this.getServiceKey());
        ChainedCodeGeneratorTask generator = new ChainedCodeGeneratorTask();
        if (this.hasNoTarget(invocationContext)) {
            generator.addTask((ICodeGeneratorTask)new SchemaValidatorTask());
        } else {
            if (invocationContext.getConfigurationProperties().getOrDefault(SIMULATOR, FALSE).equalsIgnoreCase(TRUE)) {
                generator.addTask((ICodeGeneratorTask)new JavaClientTask());
            }
            if (invocationContext.getConfigurationProperties().getOrDefault(SCHEMAVALIDATOR, FALSE).equalsIgnoreCase(TRUE)) {
                generator.addTask((ICodeGeneratorTask)new SchemaValidatorTask());
            }
        }
        generator.generate((Object)infomodel, invocationContext, (IGeneratedWriter)zipOutputter);
        GenerationResultBuilder result = GenerationResultBuilder.from((IGenerationResult)zipOutputter);
        if (invocationContext.getConfigurationProperties().getOrDefault("kura", FALSE).equalsIgnoreCase(TRUE)) {
            props = new HashMap<String, String>();
            props.put("boschcloud", TRUE);
            props.put("bluetooth", TRUE);
            IGenerationResult kuraResult = invocationContext.lookupGenerator("kura").generate(infomodel, InvocationContext.simpleInvocationContext(props), monitor);
            result.append(kuraResult);
        }
        if (invocationContext.getConfigurationProperties().getOrDefault("alexa", FALSE).equalsIgnoreCase(TRUE)) {
            props = new HashMap();
            props.put("boschcloud", TRUE);
            IGenerationResult awsResult = invocationContext.lookupGenerator("aws").generate(infomodel, InvocationContext.simpleInvocationContext(props), monitor);
            result.append(awsResult);
        }
        if (invocationContext.getConfigurationProperties().getOrDefault("webui", FALSE).equalsIgnoreCase(TRUE)) {
            props = new HashMap();
            props.put("boschcloud", TRUE);
            props.put("swagger", TRUE);
            props.put("persistence", TRUE);
            IGenerationResult webuiResult = invocationContext.lookupGenerator("webui").generate(infomodel, InvocationContext.simpleInvocationContext(props), monitor);
            result.append(webuiResult);
        }
        return result.build();
    }

    private boolean hasNoTarget(InvocationContext invocationContext) {
        return invocationContext.getConfigurationProperties().getOrDefault(SIMULATOR, FALSE).equalsIgnoreCase(FALSE) && invocationContext.getConfigurationProperties().getOrDefault(SCHEMAVALIDATOR, FALSE).equalsIgnoreCase(FALSE) && invocationContext.getConfigurationProperties().getOrDefault("alexa", FALSE).equalsIgnoreCase(FALSE);
    }

    public String getServiceKey() {
        return "boschiotthings";
    }
}

