/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.kura.templates;

import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.kura.templates.Utils;
import org.eclipse.vorto.codegen.kura.templates.cloud.TypeMapper;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class DefaultAppTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = context.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"App.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _javaPackageBasePath = Utils.getJavaPackageBasePath();
        _builder.append((Object)_javaPackageBasePath, "");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _javaPackage = Utils.getJavaPackage();
        _builder.append((Object)_javaPackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.Executors;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.ScheduledExecutorService;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.ScheduledFuture;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.TimeUnit;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.osgi.service.component.ComponentContext;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.Logger;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.LoggerFactory;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import ");
        String _javaPackage_1 = Utils.getJavaPackage();
        _builder.append((Object)_javaPackage_1, "");
        _builder.append((Object)".cloud.*;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import ");
        String _javaPackage_2 = Utils.getJavaPackage();
        _builder.append((Object)_javaPackage_2, "");
        _builder.append((Object)".cloud.bosch.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = element.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"App {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final Logger s_logger = LoggerFactory.getLogger(");
        String _name_1 = element.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)"App.class);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"private static final String APP_ID = \"");
        String _javaPackage_3 = Utils.getJavaPackage();
        _builder.append((Object)_javaPackage_3, "    ");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private ScheduledExecutorService m_worker;");
        _builder.newLine();
        _builder.append((Object)"   \t");
        _builder.append((Object)"private ScheduledFuture<?> m_handle;");
        _builder.newLine();
        _builder.append((Object)"   \t");
        _builder.newLine();
        _builder.append((Object)"   \t");
        _builder.append((Object)"private IDataService dataService;");
        _builder.newLine();
        _builder.append((Object)"   \t");
        _builder.newLine();
        _builder.append((Object)"   \t");
        _builder.append((Object)"private String thingId = \"INSERT THING ID HERE\";");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"   \t");
        _builder.append((Object)"public ");
        String _name_2 = element.getName();
        _builder.append((Object)_name_2, "   \t");
        _builder.append((Object)"App() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"   \t\t");
        _builder.append((Object)"m_worker = Executors.newSingleThreadScheduledExecutor();");
        _builder.newLine();
        _builder.append((Object)"   \t\t");
        _builder.append((Object)"dataService = new BoschDataService(\"\",\"wss://events.apps.bosch-iot-cloud.com\");");
        _builder.newLine();
        _builder.append((Object)"   \t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"   \t");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"protected void activate(ComponentContext componentContext) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"s_logger.info(\"Bundle \" + APP_ID + \" has started!\");");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"// cancel a current worker handle if one if active");
        _builder.newLine();
        _builder.append((Object)"   \t\t");
        _builder.append((Object)"if (m_handle != null) {");
        _builder.newLine();
        _builder.append((Object)"   \t\t\t");
        _builder.append((Object)"m_handle.cancel(true);");
        _builder.newLine();
        _builder.append((Object)"   \t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"   \t\t");
        _builder.append((Object)"// schedule a new worker");
        _builder.newLine();
        _builder.append((Object)"   \t\t");
        _builder.append((Object)"m_handle = m_worker.scheduleAtFixedRate(new Runnable() {");
        _builder.newLine();
        _builder.append((Object)"   \t\t\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"   \t\t\t");
        _builder.append((Object)"public void run() {");
        _builder.newLine();
        _builder.append((Object)"   \t\t\t\t");
        _builder.append((Object)"Thread.currentThread().setName(getClass().getSimpleName());");
        _builder.newLine();
        _builder.append((Object)"   \t\t\t\t");
        _builder.newLine();
        EList _properties = element.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            _builder.append((Object)"   \t\t\t\t");
            FunctionblockModel _type = fbProperty.getType();
            String _name_3 = _type.getName();
            _builder.append((Object)_name_3, "   \t\t\t\t");
            _builder.append((Object)" ");
            String _name_4 = fbProperty.getName();
            _builder.append((Object)_name_4, "   \t\t\t\t");
            _builder.append((Object)" = new ");
            FunctionblockModel _type_1 = fbProperty.getType();
            String _name_5 = _type_1.getName();
            _builder.append((Object)_name_5, "   \t\t\t\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
            FunctionblockModel _type_2 = fbProperty.getType();
            FunctionBlock _functionblock = _type_2.getFunctionblock();
            Status _status = _functionblock.getStatus();
            EList _properties_1 = _status.getProperties();
            for (Property statusProperty : _properties_1) {
                _builder.append((Object)"   \t\t\t\t");
                String _name_6 = fbProperty.getName();
                _builder.append((Object)_name_6, "   \t\t\t\t");
                _builder.append((Object)".set");
                String _name_7 = statusProperty.getName();
                String _checkKeyword = TypeMapper.checkKeyword(_name_7);
                String _firstUpper = StringExtensions.toFirstUpper((String)_checkKeyword);
                _builder.append((Object)_firstUpper, "   \t\t\t\t");
                _builder.append((Object)"(");
                PropertyType _type_3 = statusProperty.getType();
                String _randomValue = TypeMapper.getRandomValue(_type_3);
                _builder.append((Object)_randomValue, "   \t\t\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"   \t\t\t\t");
            _builder.append((Object)"dataService.publish");
            String _name_8 = fbProperty.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_8);
            _builder.append((Object)_firstUpper_1, "   \t\t\t\t");
            _builder.append((Object)"(thingId, ");
            String _name_9 = fbProperty.getName();
            _builder.append((Object)_name_9, "   \t\t\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"   \t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"   \t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"   \t\t");
        _builder.append((Object)"}, 0, 300, TimeUnit.SECONDS);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"protected void deactivate(ComponentContext componentContext) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"s_logger.info(\"Bundle \" + APP_ID + \" has stopped!\");");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

