/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.kura.templates.cloud.bosch;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.kura.templates.Utils;
import org.eclipse.vorto.codegen.kura.templates.cloud.TypeMapper;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class BoschDataServiceTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"BoschDataService.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _javaPackageBasePath = Utils.getJavaPackageBasePath();
        _builder.append((Object)_javaPackageBasePath, "");
        _builder.append((Object)"/cloud/bosch");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _javaPackage = Utils.getJavaPackage();
        _builder.append((Object)_javaPackage, "");
        _builder.append((Object)".cloud.bosch;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.ExecutionException;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.TimeUnit;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.TimeoutException;");
        _builder.newLine();
        _builder.append((Object)"import java.util.function.Function;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.Logger;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.LoggerFactory;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import com.bosch.cr.integration.IntegrationClient;");
        _builder.newLine();
        _builder.append((Object)"import com.bosch.cr.integration.things.FeatureHandle;");
        _builder.newLine();
        _builder.append((Object)"import com.bosch.cr.integration.things.ThingHandle;");
        _builder.newLine();
        _builder.append((Object)"import com.bosch.cr.json.JsonObject;");
        _builder.newLine();
        _builder.append((Object)"import com.bosch.cr.model.things.Feature;");
        _builder.newLine();
        _builder.append((Object)"import ");
        String _javaPackage_1 = Utils.getJavaPackage();
        _builder.append((Object)_javaPackage_1, "");
        _builder.append((Object)".cloud.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public class BoschDataService implements IDataService {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private IntegrationClient integrationClient;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private static final Logger LOGGER = LoggerFactory.getLogger(BoschDataService.class);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private static final int TIMEOUT = 5;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private String solutionId;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private String endpointUrl;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public BoschDataService(String solutionId, String endpointUrl) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.solutionId = solutionId;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.endpointUrl = endpointUrl;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _properties = element.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            _builder.append((Object)"\t");
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void publish");
            String _name = fbProperty.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name);
            _builder.append((Object)_firstUpper, "\t");
            _builder.append((Object)"(String thingId, ");
            FunctionblockModel _type = fbProperty.getType();
            String _name_1 = _type.getName();
            _builder.append((Object)_name_1, "\t");
            _builder.append((Object)" data) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t ");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t ");
            _builder.append((Object)"ThingHandle thingHandle = getIntegrationClient().things().forId(thingId);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t ");
            _builder.append((Object)"String featureId = \"");
            String _name_2 = fbProperty.getName();
            _builder.append((Object)_name_2, "\t\t ");
            _builder.append((Object)"\"; //feature id according to Information model function block property");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"        ");
            _builder.append((Object)"FeatureHandle featureHandle = thingHandle.forFeature(featureId);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"        ");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"        ");
            _builder.append((Object)"try {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"            ");
            _builder.append((Object)"featureHandle.retrieve()");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"                ");
            _builder.append((Object)".exceptionally(addMissingFeature(thingHandle, featureId))");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"                ");
            _builder.append((Object)".thenCompose(feature -> {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"                     ");
            _builder.append((Object)"return featureHandle.putProperty(\"status\", JsonObject.newBuilder()");
            _builder.newLine();
            FunctionblockModel _type_1 = fbProperty.getType();
            FunctionBlock _functionblock = _type_1.getFunctionblock();
            Status _status = _functionblock.getStatus();
            EList _properties_1 = _status.getProperties();
            for (Property statusProperty : _properties_1) {
                boolean _and = false;
                PropertyType _type_2 = statusProperty.getType();
                if (!(_type_2 instanceof PrimitivePropertyType)) {
                    _and = false;
                } else {
                    boolean _equals;
                    PropertyType _type_3 = statusProperty.getType();
                    PrimitiveType _type_4 = ((PrimitivePropertyType)_type_3).getType();
                    _and = _equals = Objects.equal((Object)_type_4, (Object)PrimitiveType.DATETIME);
                }
                if (_and) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"                     ");
                    _builder.append((Object)".set(\"");
                    String _name_3 = statusProperty.getName();
                    _builder.append((Object)_name_3, "\t                     ");
                    _builder.append((Object)"\", JSON_DATE_FORMAT.format(data.get");
                    String _name_4 = statusProperty.getName();
                    String _checkKeyword = TypeMapper.checkKeyword(_name_4);
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)_checkKeyword);
                    _builder.append((Object)_firstUpper_1, "\t                     ");
                    _builder.append((Object)"()))");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"                     ");
                _builder.append((Object)".set(\"");
                String _name_5 = statusProperty.getName();
                _builder.append((Object)_name_5, "\t                     ");
                _builder.append((Object)"\", data.get");
                String _name_6 = statusProperty.getName();
                String _checkKeyword_1 = TypeMapper.checkKeyword(_name_6);
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)_checkKeyword_1);
                _builder.append((Object)_firstUpper_2, "\t                     ");
                _builder.append((Object)"())");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"                     ");
            _builder.append((Object)".build());");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"                 ");
            _builder.append((Object)"}).whenComplete((aVoid, throwable) -> {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"                     ");
            _builder.append((Object)"if (null == throwable) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"                         ");
            _builder.append((Object)"LOGGER.info(\"Thing with ID '{}' feature ");
            String _name_7 = fbProperty.getName();
            _builder.append((Object)_name_7, "\t                         ");
            _builder.append((Object)" was updated with values {}\", thingId,data);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"                     ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"                     ");
            _builder.append((Object)"else {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"                         ");
            _builder.append((Object)"LOGGER.error(throwable.getMessage());");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"                     ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"                 ");
            _builder.append((Object)"}).get(TIMEOUT, TimeUnit.SECONDS);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"        ");
            _builder.append((Object)"} catch (InterruptedException | ExecutionException | TimeoutException e) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"            ");
            _builder.append((Object)"e.printStackTrace();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"            ");
            _builder.append((Object)"throw new RuntimeException(e);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"        ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private IntegrationClient getIntegrationClient() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (this.integrationClient == null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return integrationClient = ThingClientFactory.getThingIntegrationClient(solutionId,endpointUrl);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return this.integrationClient;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Function<Throwable, Feature> addMissingFeature(ThingHandle thingHandle, String featureId) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return throwable -> {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"LOGGER.info(\"Creating the feature first because it's missing\");");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"Feature feature = Feature.newBuilder().withId(featureId).build();");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"return thingHandle.putFeature(feature)");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)".thenCompose(aVoid -> thingHandle.forFeature(featureId).retrieve())");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)".get(TIMEOUT, TimeUnit.SECONDS);");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"} catch (Exception e) {");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"e.printStackTrace();");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"throw new RuntimeException(e);");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

