/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ios.templates;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.ios.templates.MappingUtils;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class DeviceServiceTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        String _name = context.getName();
        return String.valueOf(_name) + "Device.swift";
    }

    public String getPath(InformationModel context) {
        return "";
    }

    public String getContent(InformationModel context, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"//Generated by Vorto");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import Foundation");
        _builder.newLine();
        _builder.append((Object)"import CoreBluetooth");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"let deviceName = \"");
        String _displayname = context.getDisplayname();
        _builder.append((Object)_displayname, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"let ");
        String _name = context.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"InfoServiceUUID = CBUUID(string: \"add uuid here\") //TODO");
        _builder.newLineIfNotEmpty();
        EList _properties = context.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            _builder.append((Object)"let ");
            FunctionblockModel _type = fbProperty.getType();
            String _name_1 = _type.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)"ServiceUUID = CBUUID(string: \"add uuid of ");
            String _name_2 = fbProperty.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)" here\") //TODO");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"// Characteristic UUIDs");
        _builder.newLine();
        _builder.append((Object)"let ");
        String _name_3 = context.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)"InfoSystemIDUUID  = CBUUID(string: \"add uuid here\") //TODO");
        _builder.newLineIfNotEmpty();
        EList _properties_1 = context.getProperties();
        for (FunctionblockProperty fbProperty_1 : _properties_1) {
            boolean _notEquals;
            _builder.append((Object)"let ");
            FunctionblockModel _type_1 = fbProperty_1.getType();
            String _name_4 = _type_1.getName();
            _builder.append((Object)_name_4, "");
            _builder.append((Object)"DataUUID = CBUUID(string: \"add uuid of ");
            String _name_5 = fbProperty_1.getName();
            _builder.append((Object)_name_5, "");
            _builder.append((Object)" for data here\")");
            _builder.newLineIfNotEmpty();
            FunctionblockModel _type_2 = fbProperty_1.getType();
            FunctionBlock _functionblock = _type_2.getFunctionblock();
            Configuration _configuration = _functionblock.getConfiguration();
            boolean bl = _notEquals = !Objects.equal((Object)_configuration, null);
            if (!_notEquals) continue;
            _builder.append((Object)"let ");
            FunctionblockModel _type_3 = fbProperty_1.getType();
            String _name_6 = _type_3.getName();
            _builder.append((Object)_name_6, "");
            _builder.append((Object)"ConfigUUID = CBUUID(string: \"add uuid of ");
            String _name_7 = fbProperty_1.getName();
            _builder.append((Object)_name_7, "");
            _builder.append((Object)" for configuration here\")");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"class ");
        String _name_8 = context.getName();
        _builder.append((Object)_name_8, "");
        _builder.append((Object)"Device {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"// Check name of device from advertisement data");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"class func found (advertisementData: [NSObject : AnyObject]!) -> Bool {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"let nameOfDeviceFound = (advertisementData as NSDictionary).objectForKey(CBAdvertisementDataLocalNameKey) as? NSString");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return (nameOfDeviceFound == deviceName)");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"// Check if the service has a valid UUID");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"class func validService (service : CBService) -> Bool {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if service.UUID == ");
        String _name_9 = context.getName();
        _builder.append((Object)_name_9, "        ");
        _builder.append((Object)"InfoServiceUUID");
        _builder.newLineIfNotEmpty();
        EList _properties_2 = context.getProperties();
        for (FunctionblockProperty fbProperty_2 : _properties_2) {
            _builder.append((Object)"        \t");
            _builder.append((Object)"|| service.UUID == ");
            FunctionblockModel _type_4 = fbProperty_2.getType();
            String _name_10 = _type_4.getName();
            _builder.append((Object)_name_10, "        \t");
            _builder.append((Object)"ServiceUUID");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        \t");
        }
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"                ");
        _builder.append((Object)"return true");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"else {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"return false");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"// Check if the characteristic has a valid data UUID");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"class func validDataCharacteristic (characteristic : CBCharacteristic) -> Bool {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if service.UUID == ");
        String _name_11 = context.getName();
        _builder.append((Object)_name_11, "        ");
        _builder.append((Object)"InfoServiceUUID");
        _builder.newLineIfNotEmpty();
        EList _properties_3 = context.getProperties();
        for (FunctionblockProperty fbProperty_3 : _properties_3) {
            _builder.append((Object)"        \t");
            _builder.append((Object)"|| service.UUID == ");
            FunctionblockModel _type_5 = fbProperty_3.getType();
            String _name_12 = _type_5.getName();
            _builder.append((Object)_name_12, "        \t");
            _builder.append((Object)"ServiceUUID");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        \t");
        }
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"                ");
        _builder.append((Object)"return true");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"else {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"return false");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        EList _properties_4 = context.getProperties();
        for (FunctionblockProperty fbProperty_4 : _properties_4) {
            FunctionblockModel _type_6 = fbProperty_4.getType();
            FunctionBlock _functionblock_1 = _type_6.getFunctionblock();
            EList _operations = _functionblock_1.getOperations();
            for (Operation operation : _operations) {
                boolean _notEquals_2;
                boolean _notEquals_1;
                boolean _and = false;
                ReturnType _returnType = operation.getReturnType();
                boolean bl = _notEquals_1 = !Objects.equal((Object)_returnType, null);
                if (!_notEquals_1) {
                    _and = false;
                } else {
                    ReturnType _returnType_1 = operation.getReturnType();
                    _and = _returnType_1 instanceof ReturnObjectType;
                }
                if (_and) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"class func ");
                    String _name_13 = operation.getName();
                    _builder.append((Object)_name_13, "    ");
                    _builder.append((Object)"(value : NSData) -> ");
                    ReturnType _returnType_2 = operation.getReturnType();
                    Type _returnType_3 = ((ReturnObjectType)_returnType_2).getReturnType();
                    String _name_14 = _returnType_3.getName();
                    _builder.append((Object)_name_14, "    ");
                    _builder.append((Object)" {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"var result = ");
                    ReturnType _returnType_4 = operation.getReturnType();
                    Type _returnType_5 = ((ReturnObjectType)_returnType_4).getReturnType();
                    String _name_15 = _returnType_5.getName();
                    _builder.append((Object)_name_15, "    \t");
                    _builder.append((Object)"()");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"//TODO convert and map value to response type");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return result");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
                boolean _and_1 = false;
                ReturnType _returnType_6 = operation.getReturnType();
                boolean bl2 = _notEquals_2 = !Objects.equal((Object)_returnType_6, null);
                if (!_notEquals_2) {
                    _and_1 = false;
                } else {
                    ReturnType _returnType_7 = operation.getReturnType();
                    _and_1 = _returnType_7 instanceof ReturnPrimitiveType;
                }
                if (!_and_1) continue;
                _builder.append((Object)"    ");
                _builder.append((Object)"class func ");
                String _name_16 = operation.getName();
                _builder.append((Object)_name_16, "    ");
                _builder.append((Object)"(value : NSData) -> ");
                ReturnType _returnType_8 = operation.getReturnType();
                PrimitiveType _returnType_9 = ((ReturnPrimitiveType)_returnType_8).getReturnType();
                String _mapSimpleDatatype = MappingUtils.mapSimpleDatatype(_returnType_9);
                _builder.append((Object)_mapSimpleDatatype, "    ");
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"\t");
                _builder.append((Object)"//TODO convert and map value to response type");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"\t");
                _builder.append((Object)"return result");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        _builder.append((Object)"    ");
        _builder.newLine();
        return _builder.toString();
    }
}

