/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.mqtt.templates;

import java.util.UUID;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class MqttConfigurationTemplate
implements IFileTemplate<FunctionblockModel> {
    public String getFileName(FunctionblockModel context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"MqttConfiguration");
        String _name = context.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)".java");
        return _builder.toString();
    }

    public String getPath(FunctionblockModel context) {
        return "mqtt.example.client/src/main/java/mqtt/example/config";
    }

    public String getContent(FunctionblockModel context, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package mqtt.example.config;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import java.io.IOException;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.springframework.beans.factory.annotation.Autowired;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.beans.factory.annotation.Value;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.context.annotation.Bean;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.context.annotation.Configuration;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.integration.annotation.ServiceActivator;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.integration.channel.DirectChannel;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.integration.core.MessageProducer;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.integration.mqtt.inbound.MqttPahoMessageDrivenChannelAdapter;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.integration.mqtt.support.DefaultPahoMessageConverter;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.messaging.Message;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.messaging.MessageChannel;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.messaging.MessageHandler;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.messaging.MessagingException;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import com.fasterxml.jackson.databind.ObjectMapper;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import mqtt.example.*;");
        _builder.newLine();
        _builder.append((Object)"import model.functionblocks.*;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"@Configuration");
        _builder.newLine();
        _builder.append((Object)"public class MqttConfiguration");
        String _name = context.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Value(\"${mqtt.connectionUrl}\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String connectionUrl;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Value(\"${mqtt.topic.");
        String _name_1 = context.getName();
        String _lowerCase = _name_1.toLowerCase();
        _builder.append((Object)_lowerCase, "\t");
        _builder.append((Object)"}\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String topicName;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Autowired");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private IClientHandler clientHandler;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Bean");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public MessageChannel mqttInputChannel");
        String _name_2 = context.getName();
        _builder.append((Object)_name_2, "    ");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    \t");
        _builder.append((Object)"return new DirectChannel();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"@Bean");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public MessageProducer inbound");
        String _name_3 = context.getName();
        _builder.append((Object)_name_3, "    ");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    \t");
        _builder.append((Object)"MqttPahoMessageDrivenChannelAdapter adapter = new MqttPahoMessageDrivenChannelAdapter(this.connectionUrl, \"client");
        String _name_4 = context.getName();
        _builder.append((Object)_name_4, "    \t");
        _builder.append((Object)"_");
        UUID _randomUUID = UUID.randomUUID();
        String _string = _randomUUID.toString();
        _builder.append((Object)_string, "    \t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    \t");
        _builder.append((Object)"adapter.addTopic(this.topicName);");
        _builder.newLine();
        _builder.append((Object)"    \t");
        _builder.append((Object)"adapter.setCompletionTimeout(5000);");
        _builder.newLine();
        _builder.append((Object)"    \t");
        _builder.append((Object)"adapter.setConverter(new DefaultPahoMessageConverter());");
        _builder.newLine();
        _builder.append((Object)"    \t");
        _builder.append((Object)"adapter.setQos(1);");
        _builder.newLine();
        _builder.append((Object)"    \t");
        _builder.append((Object)"adapter.setOutputChannel(mqttInputChannel");
        String _name_5 = context.getName();
        _builder.append((Object)_name_5, "    \t");
        _builder.append((Object)"());");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    \t");
        _builder.append((Object)"return adapter;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"@Bean");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"@ServiceActivator(inputChannel = \"mqttInputChannel");
        String _name_6 = context.getName();
        _builder.append((Object)_name_6, "    ");
        _builder.append((Object)"\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"public MessageHandler handler");
        String _name_7 = context.getName();
        _builder.append((Object)_name_7, "    ");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    \t");
        _builder.append((Object)"return new MessageHandler() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.append((Object)"public void handleMessage(Message<?> message) throws MessagingException {");
        _builder.newLine();
        _builder.append((Object)"    \t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"ObjectMapper mapper = new ObjectMapper();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        String _name_8 = context.getName();
        _builder.append((Object)_name_8, "\t\t\t\t");
        _builder.append((Object)"Status status = null;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"status = mapper.readValue(message.getPayload().toString(), ");
        String _name_9 = context.getName();
        _builder.append((Object)_name_9, "\t\t\t\t\t");
        _builder.append((Object)"Status.class);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"clientHandler.onDeviceStatusReceived(status);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"} catch (IOException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"e.printStackTrace();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    \t");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

