/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.functionblock.tests.validator;

import com.google.inject.Injector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.ConstraintIntervalType;
import org.eclipse.vorto.core.api.model.datatype.ConstraintRule;
import org.eclipse.vorto.core.api.model.datatype.DatatypeFactory;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteral;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockFactory;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.PrimitiveParam;
import org.eclipse.vorto.editor.functionblock.FunctionblockStandaloneSetup;
import org.eclipse.vorto.editor.functionblock.validation.FunctionblockValidator;
import org.eclipse.xtext.junit4.AbstractXtextTests;
import org.eclipse.xtext.junit4.validation.AssertableDiagnostics;
import org.eclipse.xtext.junit4.validation.ValidatorTester;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.junit.After;
import org.junit.Test;

public class FbValidatorTest
extends AbstractXtextTests {
    private ValidatorTester<FunctionblockValidator> tester;

    public void setUp() throws Exception {
        ValidatorTester _validatorTester;
        super.setUp();
        this.with(FunctionblockStandaloneSetup.class);
        FunctionblockValidator validator = (FunctionblockValidator)this.get(FunctionblockValidator.class);
        Injector _injector = this.getInjector();
        this.tester = _validatorTester = new ValidatorTester((AbstractDeclarativeValidator)validator, _injector);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void test_EntityName_CamelCase() {
        DatatypeFactory _dTFactoryInstance = this.getDTFactoryInstance();
        Entity entity = _dTFactoryInstance.createEntity();
        entity.setName("abc");
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkEntityName(entity);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Entity name must begin with a capital letter");
    }

    @Test
    public void test_EntityName_SuffixReply() {
        DatatypeFactory _dTFactoryInstance = this.getDTFactoryInstance();
        Entity entity = _dTFactoryInstance.createEntity();
        entity.setName("AbcReply");
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkEntityName(entity);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_EntityName_SuffixReply_JustReply() {
        DatatypeFactory _dTFactoryInstance = this.getDTFactoryInstance();
        Entity entity = _dTFactoryInstance.createEntity();
        entity.setName("Reply");
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkEntityName(entity);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_FBName() {
        FunctionblockFactory _fBFactoryInstance = this.getFBFactoryInstance();
        FunctionblockModel fbmodel = _fBFactoryInstance.createFunctionblockModel();
        fbmodel.setName("fame");
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkFunctionBlockName(fbmodel);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Function block name must begin with a capital letter");
    }

    @Test
    public void test_FuncBlock_Version_Valid() {
        FunctionblockFactory _fBFactoryInstance = this.getFBFactoryInstance();
        FunctionblockModel fb = _fBFactoryInstance.createFunctionblockModel();
        fb.setVersion("1.1.1-RC");
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkVersionPattern(fb);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
        FunctionblockFactory _fBFactoryInstance_1 = this.getFBFactoryInstance();
        FunctionblockModel fb1 = _fBFactoryInstance_1.createFunctionblockModel();
        fb1.setVersion("1.1.1");
        FunctionblockValidator _validator_1 = (FunctionblockValidator)this.tester.validator();
        _validator_1.checkVersionPattern(fb1);
        AssertableDiagnostics _diagnose_1 = this.tester.diagnose();
        _diagnose_1.assertOK();
        FunctionblockFactory _fBFactoryInstance_2 = this.getFBFactoryInstance();
        FunctionblockModel fb2 = _fBFactoryInstance_2.createFunctionblockModel();
        fb2.setVersion("11.11.11");
        FunctionblockValidator _validator_2 = (FunctionblockValidator)this.tester.validator();
        _validator_2.checkVersionPattern(fb2);
        AssertableDiagnostics _diagnose_2 = this.tester.diagnose();
        _diagnose_2.assertOK();
    }

    @Test
    public void test_FuncBlock_Version_Invalid() {
        FunctionblockFactory _fBFactoryInstance = this.getFBFactoryInstance();
        FunctionblockModel fb = _fBFactoryInstance.createFunctionblockModel();
        fb.setVersion("1.1");
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkVersionPattern(fb);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Version is not matching the following pattern: <MAJOR>.<MINOR>.<PATCH>-<QUALIFIER>");
        FunctionblockFactory _fBFactoryInstance_1 = this.getFBFactoryInstance();
        FunctionblockModel fb1 = _fBFactoryInstance_1.createFunctionblockModel();
        fb1.setVersion("1.");
        FunctionblockValidator _validator_1 = (FunctionblockValidator)this.tester.validator();
        _validator_1.checkVersionPattern(fb1);
        AssertableDiagnostics _diagnose_1 = this.tester.diagnose();
        _diagnose_1.assertErrorContains("Version is not matching the following pattern: <MAJOR>.<MINOR>.<PATCH>-<QUALIFIER>");
        FunctionblockFactory _fBFactoryInstance_2 = this.getFBFactoryInstance();
        FunctionblockModel fb2 = _fBFactoryInstance_2.createFunctionblockModel();
        fb2.setVersion("1");
        FunctionblockValidator _validator_2 = (FunctionblockValidator)this.tester.validator();
        _validator_2.checkVersionPattern(fb2);
        AssertableDiagnostics _diagnose_2 = this.tester.diagnose();
        _diagnose_2.assertErrorContains("Version is not matching the following pattern: <MAJOR>.<MINOR>.<PATCH>-<QUALIFIER>");
        FunctionblockFactory _fBFactoryInstance_3 = this.getFBFactoryInstance();
        FunctionblockModel fb3 = _fBFactoryInstance_3.createFunctionblockModel();
        fb3.setVersion("1.1-RC");
        FunctionblockValidator _validator_3 = (FunctionblockValidator)this.tester.validator();
        _validator_3.checkVersionPattern(fb3);
        AssertableDiagnostics _diagnose_3 = this.tester.diagnose();
        _diagnose_3.assertErrorContains("Version is not matching the following pattern: <MAJOR>.<MINOR>.<PATCH>-<QUALIFIER>");
        FunctionblockFactory _fBFactoryInstance_4 = this.getFBFactoryInstance();
        FunctionblockModel fb4 = _fBFactoryInstance_4.createFunctionblockModel();
        fb4.setVersion("1-RC");
        FunctionblockValidator _validator_4 = (FunctionblockValidator)this.tester.validator();
        _validator_4.checkVersionPattern(fb4);
        AssertableDiagnostics _diagnose_4 = this.tester.diagnose();
        _diagnose_4.assertErrorContains("Version is not matching the following pattern: <MAJOR>.<MINOR>.<PATCH>-<QUALIFIER>");
    }

    @Test
    public void test_Enum_Empty_Literal() {
        DatatypeFactory _dTFactoryInstance = this.getDTFactoryInstance();
        Enum enum1 = _dTFactoryInstance.createEnum();
        enum1.setName("Abc");
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkEnumName_Literal(enum1);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
        DatatypeFactory _dTFactoryInstance_1 = this.getDTFactoryInstance();
        EnumLiteral lit = _dTFactoryInstance_1.createEnumLiteral();
        lit.setName("test");
        EList _enums = enum1.getEnums();
        _enums.add((Object)lit);
        FunctionblockValidator _validator_1 = (FunctionblockValidator)this.tester.validator();
        _validator_1.checkEnumName_Literal(enum1);
        AssertableDiagnostics _diagnose_1 = this.tester.diagnose();
        _diagnose_1.assertOK();
    }

    @Test
    public void test_Enum_Name() {
        DatatypeFactory _dTFactoryInstance = this.getDTFactoryInstance();
        Enum enum1 = _dTFactoryInstance.createEnum();
        enum1.setName("abc");
        DatatypeFactory _dTFactoryInstance_1 = this.getDTFactoryInstance();
        EnumLiteral literal = _dTFactoryInstance_1.createEnumLiteral();
        literal.setName("e");
        EList _enums = enum1.getEnums();
        _enums.add((Object)literal);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkEnumName_Literal(enum1);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Enum name must begin with a capital letter");
        DatatypeFactory _dTFactoryInstance_2 = this.getDTFactoryInstance();
        Enum enum2 = _dTFactoryInstance_2.createEnum();
        enum2.setName("Abc");
        EList _enums_1 = enum2.getEnums();
        _enums_1.add((Object)literal);
        FunctionblockValidator _validator_1 = (FunctionblockValidator)this.tester.validator();
        _validator_1.checkEnumName_Literal(enum2);
        AssertableDiagnostics _diagnose_1 = this.tester.diagnose();
        _diagnose_1.assertOK();
    }

    @Test
    public void test_Duplicated_OperationName() {
        FunctionblockFactory _fBFactoryInstance = this.getFBFactoryInstance();
        FunctionBlock fbmodel = _fBFactoryInstance.createFunctionBlock();
        FunctionblockFactory _fBFactoryInstance_1 = this.getFBFactoryInstance();
        Operation op1 = _fBFactoryInstance_1.createOperation();
        op1.setName("on");
        FunctionblockFactory _fBFactoryInstance_2 = this.getFBFactoryInstance();
        Operation op2 = _fBFactoryInstance_2.createOperation();
        op2.setName("on");
        EList _operations = fbmodel.getOperations();
        _operations.add((Object)op1);
        EList _operations_1 = fbmodel.getOperations();
        _operations_1.add((Object)op2);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkDuplicateOperation(op1);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Method name has been defined");
    }

    @Test
    public void test_Duplicated_ParameterName() {
        FunctionblockFactory _fBFactoryInstance = this.getFBFactoryInstance();
        Operation operation = _fBFactoryInstance.createOperation();
        FunctionblockFactory _fBFactoryInstance_1 = this.getFBFactoryInstance();
        PrimitiveParam param1 = _fBFactoryInstance_1.createPrimitiveParam();
        param1.setName("ABB");
        FunctionblockFactory _fBFactoryInstance_2 = this.getFBFactoryInstance();
        PrimitiveParam param2 = _fBFactoryInstance_2.createPrimitiveParam();
        param2.setName("ABB");
        EList _params = operation.getParams();
        _params.add((Object)param1);
        EList _params_1 = operation.getParams();
        _params_1.add((Object)param2);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkDuplicateParameter(operation);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Parameter name has been defined");
    }

    @Test
    public void test_Duplicated_Literal() {
        DatatypeFactory _dTFactoryInstance = this.getDTFactoryInstance();
        Enum enum1 = _dTFactoryInstance.createEnum();
        enum1.setName("Abc");
        DatatypeFactory _dTFactoryInstance_1 = this.getDTFactoryInstance();
        EnumLiteral literal1 = _dTFactoryInstance_1.createEnumLiteral();
        DatatypeFactory _dTFactoryInstance_2 = this.getDTFactoryInstance();
        EnumLiteral literal2 = _dTFactoryInstance_2.createEnumLiteral();
        literal1.setName("green");
        literal2.setName("green");
        EList _enums = enum1.getEnums();
        _enums.add((Object)literal1);
        EList _enums_1 = enum1.getEnums();
        _enums_1.add((Object)literal2);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkDuplicatedLiteral(enum1);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Enumeration literal has been defined");
    }

    @Test
    public void test_Valid_Namespace() {
        FunctionblockFactory _fBFactoryInstance = this.getFBFactoryInstance();
        FunctionblockModel sampleFunctionBlock = _fBFactoryInstance.createFunctionblockModel();
        sampleFunctionBlock.setNamespace("com.bosch.demo");
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkNamespacePattern(sampleFunctionBlock);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Valid_Namespace_WithNumbers() {
        FunctionblockFactory _fBFactoryInstance = this.getFBFactoryInstance();
        FunctionblockModel sampleFunctionBlock = _fBFactoryInstance.createFunctionblockModel();
        sampleFunctionBlock.setNamespace("com.bosch.demo.cloud9");
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkNamespacePattern(sampleFunctionBlock);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Invalid_Namespace_WithNumbers() {
        FunctionblockFactory _fBFactoryInstance = this.getFBFactoryInstance();
        FunctionblockModel sampleFunctionBlock = _fBFactoryInstance.createFunctionblockModel();
        sampleFunctionBlock.setNamespace("com.bosch.demo.#$#$");
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkNamespacePattern(sampleFunctionBlock);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Namespace should have following pattern: <[a-z0-9]+(.[a-z0-9])*> E.g com.bosch, com.bosch.lightsystem");
    }

    @Test
    public void test_Duplicated_Constraint() {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        PrimitivePropertyType primi = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        primi.setType(PrimitiveType.STRING);
        prop.setType((PropertyType)primi);
        DatatypeFactory _dTFactoryInstance = this.getDTFactoryInstance();
        Constraint constraint1 = _dTFactoryInstance.createConstraint();
        constraint1.setType(ConstraintIntervalType.STRLEN);
        ConstraintRule _createConstraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        prop.setConstraintRule(_createConstraintRule);
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList _constraints = _constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        DatatypeFactory _dTFactoryInstance_1 = this.getDTFactoryInstance();
        Constraint constraint2 = _dTFactoryInstance_1.createConstraint();
        constraint2.setType(ConstraintIntervalType.STRLEN);
        ConstraintRule _constraintRule_1 = prop.getConstraintRule();
        EList _constraints_1 = _constraintRule_1.getConstraints();
        _constraints_1.add((Object)constraint2);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkDuplicatedConstraint(prop);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Constraint Type has been defined");
    }

    protected DatatypeFactory getDTFactoryInstance() {
        return DatatypeFactory.eINSTANCE;
    }

    protected FunctionblockFactory getFBFactoryInstance() {
        return FunctionblockFactory.eINSTANCE;
    }
}

