/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.vorto.codegen.api.IGeneratorLookup;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.ui.handler.ConfigurationElementLookup;
import org.eclipse.vorto.core.ui.MessageDisplayFactory;

public class GeneratorLookupLocal
implements IGeneratorLookup {
    private static final String GENERATOR_ID = "org.eclipse.vorto.codegen.org_eclipse_vorto_codegen_Generators";
    private static final String CLASS = "class";
    private static List<IGeneratorResolver> resolvers = new ArrayList<IGeneratorResolver>();

    static {
        resolvers.add(new GeneratorExtensionIdResolver());
        resolvers.add(new GeneratorServiceKeyResolver());
    }

    public IVortoCodeGenerator lookupByKey(String key) {
        for (IGeneratorResolver resolver : resolvers) {
            IVortoCodeGenerator generator = resolver.resolve(key);
            if (generator == null) continue;
            return generator;
        }
        return null;
    }

    static class GeneratorExtensionIdResolver
    implements IGeneratorResolver {
        GeneratorExtensionIdResolver() {
        }

        @Override
        public IVortoCodeGenerator resolve(String key) {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = ConfigurationElementLookup.getDefault().getSelectedConfigurationElementFor(GeneratorLookupLocal.GENERATOR_ID, key);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                try {
                    Object codeGenerator = configElement.createExecutableExtension(GeneratorLookupLocal.CLASS);
                    if (codeGenerator instanceof IVortoCodeGenerator) {
                        return (IVortoCodeGenerator)codeGenerator;
                    }
                }
                catch (CoreException e) {
                    MessageDisplayFactory.getMessageDisplay().displayError((Throwable)e);
                }
                ++n2;
            }
            return null;
        }
    }

    static class GeneratorServiceKeyResolver
    implements IGeneratorResolver {
        GeneratorServiceKeyResolver() {
        }

        @Override
        public IVortoCodeGenerator resolve(String key) {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = ConfigurationElementLookup.getDefault().getAllConfigurationElementFor(GeneratorLookupLocal.GENERATOR_ID);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                try {
                    Object codeGenerator = configElement.createExecutableExtension(GeneratorLookupLocal.CLASS);
                    if (codeGenerator instanceof IVortoCodeGenerator && ((IVortoCodeGenerator)codeGenerator).getServiceKey().equals(key)) {
                        return (IVortoCodeGenerator)codeGenerator;
                    }
                }
                catch (CoreException e) {
                    MessageDisplayFactory.getMessageDisplay().displayError((Throwable)e);
                }
                ++n2;
            }
            return null;
        }
    }

    private static interface IGeneratorResolver {
        public IVortoCodeGenerator resolve(String var1);
    }
}

