/*******************************************************************************
 * Copyright (c) 2016 Bosch Software Innovations GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *  
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * The Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *  
 * Contributors:
 * Bosch Software Innovations GmbH - Please refer to git log
 *******************************************************************************/
package org.eclipse.vorto.codegen.prosystfi.templates

import org.eclipse.vorto.codegen.api.ITemplate
import org.eclipse.vorto.codegen.api.InvocationContext
import org.eclipse.vorto.codegen.tools.CodeGenTools
import org.eclipse.vorto.core.api.model.datatype.Entity
import org.eclipse.vorto.core.api.model.datatype.Enum
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType
import org.eclipse.vorto.core.api.model.datatype.Property
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType

class FunctionalItemTemplate implements ITemplate<FunctionblockModel>{
	
	var String fiPackage;
	var String[] imports;
	
	new(String fiPackage, String... imports) {
		this.fiPackage = fiPackage;
		this.imports = imports;
	}
	
	override getContent(FunctionblockModel fbm, InvocationContext ctx) {
		'''
/*
*****************************************************************************************
* The present code has been generated by the Eclipse Vorto ProSyst Code Generator.
*
* The basis for the generation was the Functionblock which is uniquely identified by:
* Name:			«fbm.name»
* Namespace:	«fbm.namespace»
* Version:		«fbm.version»
*****************************************************************************************
*/

package «fiPackage»;

import java.util.Collection;
import java.util.Map;

«FOR imprt : imports»
	import «imprt».*;
«ENDFOR»
import com.prosyst.mbs.services.fim.annotations.Description;
import com.prosyst.mbs.services.fim.annotations.Getter;
import com.prosyst.mbs.services.fim.annotations.Item;
import com.prosyst.mbs.services.fim.annotations.Name;
import com.prosyst.mbs.services.fim.annotations.Numeric;
import com.prosyst.mbs.services.fim.annotations.Operation;
import com.prosyst.mbs.services.fim.annotations.Property;
import com.prosyst.mbs.services.fim.annotations.Setter;
import com.prosyst.mbs.services.fim.annotations.Version;
import com.prosyst.mbs.services.fim.FunctionalItem;

@Item
@Name("«fbm.name.toFirstUpper»")
@Description("«fbm.description»")
@Version("«fbm.version»")
public interface «fbm.name.toFirstUpper» extends FunctionalItem {
	
	«var FunctionBlock fb = fbm.functionblock»
	«IF fb.status != null»
		«FOR property : fb.status.properties»
			/**
			* Property definition for «property.name.toFirstUpper». 
			*/
			«IF (getAccessString(property, fb)=="RE")»
				@Property
			«ELSE»
				@Property(access = "«getAccessString(property, fb)»")
			«ENDIF»
			@Description("«property.description»")
			String PROPERTY_«property.name.toUpperCase» = "«property.name»";
			
		«ENDFOR»
	«ENDIF»
	«IF fb.configuration != null»
		«FOR property : fb.configuration.properties»
			/**
			* Property definition for «property.name.toFirstUpper». 
			*/
			«IF (getAccessString(property, fb)=="RE")»
				@Property
			«ELSE»
				@Property(access = "«getAccessString(property, fb)»")
			«ENDIF»
			@Description("«property.description»")
			String PROPERTY_«property.name.toUpperCase» = "«property.name»";
			
		«ENDFOR»
	«ENDIF»
	«IF fb.fault != null»
		«FOR property : fb.fault.properties»
			/**
			* Property definition for «property.name.toFirstUpper». 
			*/
			«IF (getAccessString(property, fb)=="RE")»
				@Property
			«ELSE»
				@Property(access = "«getAccessString(property, fb)»")
			«ENDIF»
			@Description("«property.description»")
			String PROPERTY_«property.name.toUpperCase» = "«property.name»";
			
		«ENDFOR»
	«ENDIF»
	«FOR operation : fb.operations»
		/**
		* Operation definition for «operation.name.toFirstUpper».
		*/
		«IF CodeGenTools.isSetter(operation, fb)»
			@Setter(value="«operation.name.substring(3).toFirstLower»")
		«ELSEIF CodeGenTools.isGetter(operation, fb)»
			@Getter(value="«operation.name.substring(3).toFirstLower»")
		«ELSE»
			@Operation
		«ENDIF»
		@Description("«operation.description»")
		«IF operation.returnType == null»
			void «operation.name»();
		«ELSE»
			«IF operation.returnType instanceof ReturnObjectType»
				«var type = (operation.returnType as ReturnObjectType).returnType»
				«IF type instanceof Entity»
					«(type as Entity).name» «operation.name»();
				«ELSEIF type instanceof Enum»
					«(type as Enum).name» «operation.name»();
				«ENDIF»
			«ELSEIF operation.returnType instanceof ReturnPrimitiveType»
					«var PrimitiveType type = (operation.returnType as ReturnPrimitiveType).returnType»
					«type.getName» «operation.name»();
			«ENDIF»
		«ENDIF»
		
	«ENDFOR»
}
'''
	}
	
	def getAccessString(Property property, FunctionBlock fb) {
		var String accessString
		if (CodeGenTools.isReadable(property, fb))
			accessString="R"
		
		if (CodeGenTools.isWritable(property, fb))
			accessString=accessString + "W"
			
		if (CodeGenTools.isEventable(property, fb))
			accessString=accessString+"E"
		return accessString
	}
}