/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.ui.parser.IModelParser;
import org.eclipse.vorto.core.ui.parser.ParseModelResult;
import org.eclipse.xtext.linking.impl.XtextLinkingDiagnostic;
import org.eclipse.xtext.resource.XtextResourceSet;

public class XtextResourceModelParser
implements IModelParser {
    private static Predicate<Resource.Diagnostic> notXtextLinkingDiagnostics = new Predicate<Resource.Diagnostic>(){

        public boolean apply(Resource.Diagnostic diagnostic) {
            return !(diagnostic instanceof XtextLinkingDiagnostic);
        }
    };
    private static Function<Diagnostic, Resource.Diagnostic> emfDiagnosticToResourceDiagnostic = new Function<Diagnostic, Resource.Diagnostic>(){

        public Resource.Diagnostic apply(final Diagnostic input) {
            return new Resource.Diagnostic(){

                public String getMessage() {
                    return input.getMessage();
                }

                public String getLocation() {
                    return input.getSource();
                }

                public int getLine() {
                    return 0;
                }

                public int getColumn() {
                    return 0;
                }
            };
        }
    };

    public <M extends Model> ParseModelResult<M> parseModelWithError(IFile modelFile, Class<M> modelClass) {
        try {
            URI uri = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
            return this.parseModel(uri, modelClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <M extends Model> M parseModel(IFile modelFile, Class<M> modelClass) {
        try {
            URI uri = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
            ParseModelResult<M> result = this.parseModel(uri, modelClass);
            return (M)((Model)result.getModel());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <M> ParseModelResult<M> parseModel(URI uri, Class<M> modelClass) {
        XtextResourceSet rs = new XtextResourceSet();
        Resource resource = rs.getResource(uri, true);
        if (!resource.getContents().isEmpty()) {
            ArrayList errorDiagnostics = Lists.newArrayList();
            EObject eModel = (EObject)resource.getContents().get(0);
            errorDiagnostics.addAll(this.getLinkingErrors(eModel));
            errorDiagnostics.addAll(Collections2.filter((Collection)resource.getErrors(), notXtextLinkingDiagnostics));
            return ParseModelResult.newResult((Collection)errorDiagnostics, (Object)eModel);
        }
        return ParseModelResult.newResult((Collection)Collections2.filter((Collection)resource.getErrors(), notXtextLinkingDiagnostics), null);
    }

    private Collection<Resource.Diagnostic> getLinkingErrors(EObject model) {
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(model);
        switch (diagnostic.getSeverity()) {
            case 4: {
                return Collections2.transform((Collection)diagnostic.getChildren(), emfDiagnosticToResourceDiagnostic);
            }
        }
        return Collections.emptyList();
    }

    public <M extends Model> M parseModel(File modelFile, Class<M> modelClass) {
        try {
            URI uri = URI.createFileURI((String)modelFile.getAbsolutePath());
            ParseModelResult<M> result = this.parseModel(uri, modelClass);
            return (M)((Model)result.getModel());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

