/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.ui.internal.persistence.connection;

import java.util.Collection;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.IntegerCombo;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitTransactionType;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.BatchWriting;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.connection.NoSqlConnection;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.persistence.connection.ConnectionPropertiesComposite;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkPersistenceUnitConnectionEditorPage
extends Pane<NoSqlConnection> {
    public EclipseLinkPersistenceUnitConnectionEditorPage(PropertyValueModel<NoSqlConnection> connectionModel, Composite parentComposite, WidgetFactory widgetFactory, ResourceManager resourceManager) {
        super(connectionModel, parentComposite, widgetFactory, resourceManager);
    }

    protected void initializeLayout(Composite container) {
        Section section = this.getWidgetFactory().createSection(container, 384);
        section.setLayoutData((Object)new GridData(768));
        section.setText(EclipseLinkUiMessages.PersistenceXmlConnectionTab_sectionTitle);
        section.setDescription(EclipseLinkUiMessages.PersistenceXmlConnectionTab_sectionDescription);
        Composite client = this.getWidgetFactory().createComposite((Composite)section);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginRight = 0;
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        section.setClient((Control)client);
        this.addLabel(client, EclipseLinkUiMessages.PersistenceXmlConnectionTab_transactionTypeLabel);
        this.addTransactionTypeCombo(client);
        this.addLabel(client, EclipseLinkUiMessages.PersistenceXmlConnectionTab_batchWritingLabel);
        this.addBatchWritingCombo(client);
        ModifiablePropertyValueModel<Boolean> cacheStatementsHolder = this.buildCacheStatementsHolder();
        this.addTriStateCheckBox(client, EclipseLinkUiMessages.PersistenceXmlConnectionTab_cacheStatementsLabel, cacheStatementsHolder, JpaHelpContextIds.PERSISTENCE_XML_CONNECTION);
        IntegerCombo<NoSqlConnection> combo = this.addCacheStatementsSizeCombo(client);
        this.controlEnabledState((PropertyValueModel)cacheStatementsHolder, new Control[]{combo.getControl()});
        TriStateCheckBox nativeSqlCheckBox = this.addTriStateCheckBoxWithDefault(client, EclipseLinkUiMessages.PersistenceXmlConnectionTab_nativeSqlLabel, this.buildNativeSqlHolder(), this.buildNativeSqlStringHolder(), JpaHelpContextIds.PERSISTENCE_XML_CONNECTION);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        nativeSqlCheckBox.getCheckBox().setLayoutData((Object)gridData);
        ConnectionPropertiesComposite<NoSqlConnection> connectionPropertiesComposite = new ConnectionPropertiesComposite<NoSqlConnection>(this, client);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        connectionPropertiesComposite.getControl().setLayoutData((Object)gridData);
    }

    private EnumFormComboViewer<PersistenceUnit, PersistenceUnitTransactionType> addTransactionTypeCombo(Composite container) {
        return new EnumFormComboViewer<PersistenceUnit, PersistenceUnitTransactionType>((Pane)this, this.buildPersistenceUnitHolder(), container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("specifiedTransactionType");
                propertyNames.add("defaultTransactionType");
            }

            protected PersistenceUnitTransactionType[] getChoices() {
                return PersistenceUnitTransactionType.values();
            }

            protected PersistenceUnitTransactionType getDefaultValue() {
                return ((PersistenceUnit)this.getSubject()).getDefaultTransactionType();
            }

            protected String displayString(PersistenceUnitTransactionType value) {
                switch (value) {
                    case JTA: {
                        return EclipseLinkUiMessages.TransactionTypeComposite_jta;
                    }
                    case RESOURCE_LOCAL: {
                        return EclipseLinkUiMessages.TransactionTypeComposite_resource_local;
                    }
                }
                throw new IllegalStateException();
            }

            protected PersistenceUnitTransactionType getValue() {
                return ((PersistenceUnit)this.getSubject()).getSpecifiedTransactionType();
            }

            protected void setValue(PersistenceUnitTransactionType value) {
                ((PersistenceUnit)this.getSubject()).setSpecifiedTransactionType(value);
                if (value == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
                    EclipseLinkPersistenceUnitConnectionEditorPage.this.clearJTAProperties();
                } else {
                    EclipseLinkPersistenceUnitConnectionEditorPage.this.clearResourceLocalProperties();
                }
            }

            protected String getHelpId() {
                return JpaHelpContextIds.PERSISTENCE_XML_CONNECTION;
            }
        };
    }

    private PropertyValueModel<PersistenceUnit> buildPersistenceUnitHolder() {
        return new PropertyAspectAdapter<NoSqlConnection, PersistenceUnit>(this.getSubjectHolder()){

            protected PersistenceUnit buildValue_() {
                return ((NoSqlConnection)this.subject).getPersistenceUnit();
            }
        };
    }

    private void clearJTAProperties() {
        ((NoSqlConnection)this.getSubject()).getPersistenceUnit().setJtaDataSource(null);
    }

    private void clearResourceLocalProperties() {
        NoSqlConnection connection = (NoSqlConnection)this.getSubject();
        connection.getPersistenceUnit().setNonJtaDataSource(null);
        connection.setDriver(null);
        connection.setUrl(null);
        connection.setUser(null);
        connection.setPassword(null);
        connection.setBindParameters(null);
        connection.setWriteConnectionsMax(null);
        connection.setWriteConnectionsMin(null);
        connection.setReadConnectionsMax(null);
        connection.setReadConnectionsMin(null);
        connection.setReadConnectionsShared(null);
        connection.setExclusiveConnectionMode(null);
        connection.setLazyConnection(null);
        connection.setConnectionSpec(null);
    }

    private EnumFormComboViewer<NoSqlConnection, BatchWriting> addBatchWritingCombo(Composite container) {
        return new EnumFormComboViewer<NoSqlConnection, BatchWriting>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("batchWriting");
            }

            protected BatchWriting[] getChoices() {
                return BatchWriting.values();
            }

            protected BatchWriting getDefaultValue() {
                return ((NoSqlConnection)this.getSubject()).getDefaultBatchWriting();
            }

            protected String displayString(BatchWriting value) {
                switch (value) {
                    case buffered: {
                        return EclipseLinkUiMessages.BatchWritingComposite_buffered;
                    }
                    case jdbc: {
                        return EclipseLinkUiMessages.BatchWritingComposite_jdbc;
                    }
                    case none: {
                        return EclipseLinkUiMessages.BatchWritingComposite_none;
                    }
                    case oracle_jdbc: {
                        return EclipseLinkUiMessages.BatchWritingComposite_oracle_jdbc;
                    }
                }
                throw new IllegalStateException();
            }

            protected BatchWriting getValue() {
                return ((NoSqlConnection)this.getSubject()).getBatchWriting();
            }

            protected void setValue(BatchWriting value) {
                ((NoSqlConnection)this.getSubject()).setBatchWriting(value);
            }

            protected String getHelpId() {
                return JpaHelpContextIds.PERSISTENCE_XML_CONNECTION;
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildNativeSqlHolder() {
        return new PropertyAspectAdapter<NoSqlConnection, Boolean>(this.getSubjectHolder(), new String[]{"nativeSql"}){

            protected Boolean buildValue_() {
                return ((NoSqlConnection)this.subject).getNativeSql();
            }

            protected void setValue_(Boolean value) {
                ((NoSqlConnection)this.subject).setNativeSql(value);
            }
        };
    }

    private PropertyValueModel<String> buildNativeSqlStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultNativeSqlHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlConnectionTab_nativeSqlLabelDefault, (Object)defaultStringValue);
                }
                return EclipseLinkUiMessages.PersistenceXmlConnectionTab_nativeSqlLabel;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultNativeSqlHolder() {
        return new PropertyAspectAdapter<NoSqlConnection, Boolean>(this.getSubjectHolder(), new String[]{"nativeSql"}){

            protected Boolean buildValue_() {
                if (((NoSqlConnection)this.subject).getNativeSql() != null) {
                    return null;
                }
                return ((NoSqlConnection)this.subject).getDefaultNativeSql();
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildCacheStatementsHolder() {
        return new PropertyAspectAdapter<NoSqlConnection, Boolean>(this.getSubjectHolder(), new String[]{"cacheStatements"}){

            protected Boolean buildValue_() {
                return ((NoSqlConnection)this.subject).getCacheStatements();
            }

            protected void setValue_(Boolean value) {
                ((NoSqlConnection)this.subject).setCacheStatements(value);
            }

            protected synchronized void subjectChanged() {
                Boolean oldValue = (Boolean)this.getValue();
                super.subjectChanged();
                Boolean newValue = (Boolean)this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChanged(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private IntegerCombo<NoSqlConnection> addCacheStatementsSizeCombo(Composite container) {
        return new IntegerCombo<NoSqlConnection>((Pane)this, container){

            protected String getHelpId() {
                return JpaHelpContextIds.PERSISTENCE_XML_CONNECTION;
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<NoSqlConnection, Integer>(this.getSubjectHolder()){

                    protected Integer buildValue_() {
                        return ((NoSqlConnection)this.subject).getDefaultCacheStatementsSize();
                    }
                };
            }

            protected ModifiablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<NoSqlConnection, Integer>(this.getSubjectHolder(), new String[]{"cacheStatementsSize"}){

                    protected Integer buildValue_() {
                        return ((NoSqlConnection)this.subject).getCacheStatementsSize();
                    }

                    protected void setValue_(Integer value) {
                        ((NoSqlConnection)this.subject).setCacheStatementsSize(value);
                    }
                };
            }
        };
    }
}

