/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wtp.jsf.core.internal.JSFCorePlugin;
import org.eclipse.wtp.jsf.core.internal.Messages;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryPackage;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.PluginProvidedJSFLibrary;
import org.osgi.framework.Bundle;

public class ArchiveFileImpl
extends EObjectImpl
implements ArchiveFile {
    public static final String copyright = "Copyright (c) 2005 Oracle Corporation";
    protected static final boolean RELATIVE_TO_WORKSPACE_EDEFAULT = true;
    protected boolean relativeToWorkspace = true;
    protected static final String SOURCE_LOCATION_EDEFAULT = null;
    protected String sourceLocation = SOURCE_LOCATION_EDEFAULT;
    protected static final String RELATIVE_DEST_LOCATION_EDEFAULT = null;
    protected String relativeDestLocation = RELATIVE_DEST_LOCATION_EDEFAULT;
    static /* synthetic */ Class class$0;

    protected ArchiveFileImpl() {
    }

    protected EClass eStaticClass() {
        return JSFLibraryRegistryPackage.eINSTANCE.getArchiveFile();
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(String newSourceLocation) {
        String oldSourceLocation = this.sourceLocation;
        if (this.relativeToWorkspace) {
            IWorkspaceRoot workspaceRoot = this.getWorkspaceRoot();
            if (workspaceRoot != null) {
                IPath wsRootPath = workspaceRoot.getLocation();
                Path srcPath = new Path(newSourceLocation);
                if (workspaceRoot.findMember((IPath)srcPath) != null) {
                    this.sourceLocation = newSourceLocation;
                } else if (wsRootPath.isPrefixOf((IPath)srcPath)) {
                    int segmentsMatched = wsRootPath.matchingFirstSegments((IPath)srcPath);
                    srcPath = srcPath.removeFirstSegments(segmentsMatched).setDevice(null);
                    this.sourceLocation = srcPath.toOSString();
                } else {
                    this.sourceLocation = newSourceLocation;
                    this.relativeToWorkspace = false;
                }
            }
        } else {
            this.sourceLocation = newSourceLocation;
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldSourceLocation, (Object)this.sourceLocation));
        }
    }

    public boolean isRelativeToWorkspace() {
        return this.relativeToWorkspace;
    }

    public void setRelativeToWorkspace(boolean newRelativeToWorkspace) {
        boolean oldRelativeToWorkspace = this.relativeToWorkspace;
        this.relativeToWorkspace = newRelativeToWorkspace;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldRelativeToWorkspace, this.relativeToWorkspace));
        }
    }

    public String getRelativeDestLocation() {
        return this.relativeDestLocation;
    }

    public void setRelativeDestLocation(String newRelativeDestLocation) {
        String oldRelativeDestLocation = this.relativeDestLocation;
        this.relativeDestLocation = newRelativeDestLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldRelativeDestLocation, (Object)this.relativeDestLocation));
        }
    }

    public JSFLibrary getJSFLibrary() {
        if (this.eContainerFeatureID != 3) {
            return null;
        }
        return (JSFLibrary)this.eContainer;
    }

    public void setJSFLibrary(JSFLibrary newJSFLibrary) {
        if (newJSFLibrary != this.eContainer || this.eContainerFeatureID != 3 && newJSFLibrary != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newJSFLibrary)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eContainer != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newJSFLibrary != null) {
                InternalEObject internalEObject = (InternalEObject)newJSFLibrary;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.JSFLibrary");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseAdd((InternalEObject)this, 5, (Class)clazz, msgs);
            }
            if ((msgs = this.eBasicSetContainer((InternalEObject)newJSFLibrary, 3, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newJSFLibrary, (Object)newJSFLibrary));
        }
    }

    public String getPath() {
        String path = null;
        String resolvedSourceLocation = this.getResolvedSourceLocation();
        if (resolvedSourceLocation != null) {
            int iPos = resolvedSourceLocation.lastIndexOf(47);
            if (iPos < 0) {
                iPos = resolvedSourceLocation.lastIndexOf(92);
            }
            path = iPos < 1 ? "" : resolvedSourceLocation.substring(0, iPos);
        }
        return path;
    }

    public String getName() {
        String name = null;
        String resolvedSourceLocation = this.getResolvedSourceLocation();
        if (resolvedSourceLocation != null) {
            int iPos = resolvedSourceLocation.lastIndexOf(47);
            if (iPos < 0) {
                iPos = resolvedSourceLocation.lastIndexOf(92);
            }
            name = iPos < 0 || iPos == resolvedSourceLocation.length() - 1 ? resolvedSourceLocation : resolvedSourceLocation.substring(iPos + 1);
        }
        return name;
    }

    public boolean exists() {
        boolean exists = false;
        if (this.getJSFLibrary() instanceof PluginProvidedJSFLibrary) {
            Bundle bundle = this.getBundle();
            if (bundle != null) {
                exists = bundle.getEntry(this.sourceLocation) != null;
            }
        } else {
            String resolvedSourceLocation = this.getResolvedSourceLocation();
            if (resolvedSourceLocation != null) {
                exists = new File(resolvedSourceLocation).exists();
            }
        }
        return exists;
    }

    public boolean equals(Object object) {
        boolean equal = false;
        if (object != null && object instanceof ArchiveFile) {
            String resolvedSourceLocation = this.getResolvedSourceLocation();
            String objResolvedSourceLocation = ((ArchiveFile)object).getResolvedSourceLocation();
            if (resolvedSourceLocation == null && objResolvedSourceLocation == null) {
                equal = true;
            } else if (resolvedSourceLocation != null) {
                equal = resolvedSourceLocation.equals(objResolvedSourceLocation);
            }
        }
        return equal;
    }

    public int hashCode() {
        return this.getResolvedSourceLocation() != null ? this.getResolvedSourceLocation().hashCode() : 0;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean copyTo(String baseDestLocation) {
        block22: {
            block21: {
                block20: {
                    copied = false;
                    in = null;
                    out = null;
                    outPath = new Path(baseDestLocation);
                    if (this.relativeDestLocation != null) {
                        outPath = outPath.append(this.relativeDestLocation);
                    }
                    outPath = outPath.append(this.getName());
                    try {
                        try {
                            block26: {
                                block24: {
                                    block25: {
                                        block23: {
                                            if (outPath.toFile().exists()) break block23;
                                            out = new FileOutputStream(outPath.toOSString());
                                            if (!(this.getJSFLibrary() instanceof PluginProvidedJSFLibrary)) break block24;
                                            break block25;
                                        }
                                        var10_6 = copied;
                                        var8_8 = null;
                                        break block20;
                                    }
                                    bundle = this.getBundle();
                                    inURL = bundle.getEntry(this.sourceLocation);
                                    if (inURL != null) {
                                        in = inURL.openStream();
                                        break block26;
                                    } else {
                                        JSFCorePlugin.log(4, NLS.bind((String)Messages.ArchiveFileImpl_CannotLocatePluginRelativeFile, (Object)this.sourceLocation));
                                        var10_7 = copied;
                                        break block21;
                                    }
                                }
                                in = new FileInputStream(this.getResolvedSourceLocation());
                            }
                            buf = new byte[1024];
                            len = 0;
                            while (true) {
                                if ((len = in.read(buf)) <= 0) {
                                    copied = true;
                                    break block22;
                                }
                                out.write(buf, 0, len);
                            }
                        }
                        catch (FileNotFoundException fnfe) {
                            JSFCorePlugin.log(4, Messages.ArchiveFileImpl_CannotCopyFile, fnfe);
                            break block22;
                        }
                        catch (IOException ioe) {
                            JSFCorePlugin.log(4, Messages.ArchiveFileImpl_CannotCopyFile, ioe);
                            break block22;
                        }
                    }
                    catch (Throwable var9_21) {
                        var8_10 = null;
                        try {
                            if (in != null) {
                                in.close();
                            }
                            if (out == null) throw var9_21;
                            out.close();
                            throw var9_21;
                        }
                        catch (IOException ioe) {
                            JSFCorePlugin.log(2, Messages.ArchiveFileImpl_CannotCloseFile, ioe);
                        }
                        throw var9_21;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [6 : 250->271)] { 
lbl60:
                // 1 sources

                if (in != null) {
                    in.close();
                }
                if (out == null) return var10_6;
                out.close();
                return var10_6;
lbl65:
                // 1 sources

                catch (IOException ioe) {
                    JSFCorePlugin.log(2, Messages.ArchiveFileImpl_CannotCloseFile, ioe);
                }
                return var10_6;
            }
            var8_9 = null;
            ** try [egrp 2[TRYBLOCK] [6 : 250->271)] { 
lbl71:
            // 1 sources

            if (in != null) {
                in.close();
            }
            if (out == null) return var10_7;
            out.close();
            return var10_7;
lbl76:
            // 1 sources

            catch (IOException ioe) {
                JSFCorePlugin.log(2, Messages.ArchiveFileImpl_CannotCloseFile, ioe);
            }
            return var10_7;
        }
        var8_11 = null;
        try {}
        catch (IOException ioe) {
            JSFCorePlugin.log(2, Messages.ArchiveFileImpl_CannotCloseFile, ioe);
            return copied;
        }
        if (in != null) {
            in.close();
        }
        if (out == null) return copied;
        out.close();
        return copied;
    }

    public String getResolvedSourceLocation() {
        String workspaceLocation;
        IWorkspaceRoot workspaceRoot;
        String bundleLocation;
        Bundle bundle;
        String resolvedSourceLocation = null;
        resolvedSourceLocation = this.getJSFLibrary() instanceof PluginProvidedJSFLibrary ? ((bundle = this.getBundle()) != null ? ((bundleLocation = bundle.getLocation()) != null ? String.valueOf(this.appendSeparator(bundleLocation)) + this.sourceLocation : this.sourceLocation) : this.sourceLocation) : (this.isRelativeToWorkspace() ? ((workspaceRoot = this.getWorkspaceRoot()) != null ? ((workspaceLocation = workspaceRoot.getLocation().toOSString()) != null ? String.valueOf(this.appendSeparator(workspaceLocation)) + this.sourceLocation : this.sourceLocation) : this.sourceLocation) : this.sourceLocation);
        return resolvedSourceLocation;
    }

    protected Bundle getBundle() {
        String pluginID;
        Bundle bundle = null;
        if (this.getJSFLibrary() instanceof PluginProvidedJSFLibrary && (pluginID = ((PluginProvidedJSFLibrary)this.getJSFLibrary()).getPluginID()) != null) {
            bundle = Platform.getBundle((String)pluginID);
        }
        return bundle;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        IWorkspaceRoot workspaceRoot = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspaceRoot = workspace.getRoot();
        }
        return workspaceRoot;
    }

    protected String appendSeparator(String path) {
        String newPath = null;
        newPath = !path.endsWith("\\") && !path.endsWith("/") ? String.valueOf(path) + System.getProperty("file.separator") : path;
        return newPath;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 3: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 3, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 3: {
                    return this.eBasicSetContainer(null, 3, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block6: {
            if (this.eContainerFeatureID < 0) break block6;
            switch (this.eContainerFeatureID) {
                case 3: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.JSFLibrary");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return this.eContainer.eInverseRemove((InternalEObject)this, 5, (Class)clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.isRelativeToWorkspace() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 1: {
                return this.getSourceLocation();
            }
            case 2: {
                return this.getRelativeDestLocation();
            }
            case 3: {
                return this.getJSFLibrary();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setRelativeToWorkspace((Boolean)newValue);
                return;
            }
            case 1: {
                this.setSourceLocation((String)newValue);
                return;
            }
            case 2: {
                this.setRelativeDestLocation((String)newValue);
                return;
            }
            case 3: {
                this.setJSFLibrary((JSFLibrary)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setRelativeToWorkspace(true);
                return;
            }
            case 1: {
                this.setSourceLocation(SOURCE_LOCATION_EDEFAULT);
                return;
            }
            case 2: {
                this.setRelativeDestLocation(RELATIVE_DEST_LOCATION_EDEFAULT);
                return;
            }
            case 3: {
                this.setJSFLibrary(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return !this.relativeToWorkspace;
            }
            case 1: {
                return SOURCE_LOCATION_EDEFAULT == null ? this.sourceLocation != null : !SOURCE_LOCATION_EDEFAULT.equals(this.sourceLocation);
            }
            case 2: {
                return RELATIVE_DEST_LOCATION_EDEFAULT == null ? this.relativeDestLocation != null : !RELATIVE_DEST_LOCATION_EDEFAULT.equals(this.relativeDestLocation);
            }
            case 3: {
                return this.getJSFLibrary() != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (RelativeToWorkspace: ");
        result.append(this.relativeToWorkspace);
        result.append(", SourceLocation: ");
        result.append(this.sourceLocation);
        result.append(", RelativeDestLocation: ");
        result.append(this.relativeDestLocation);
        result.append(')');
        return result.toString();
    }
}

