/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class JSPDirectiveValidator
extends JSPValidator
implements ISourceValidator {
    private HashMap fReservedPrefixes = new HashMap();
    private HashMap fDuplicatePrefixes = new HashMap();
    private IDocument fDocument;

    public JSPDirectiveValidator() {
        this.fReservedPrefixes.put("jsp", "");
        this.fReservedPrefixes.put("jspx", "");
        this.fReservedPrefixes.put("javax", "");
        this.fReservedPrefixes.put("servlet", "");
        this.fReservedPrefixes.put("sun", "");
        this.fReservedPrefixes.put("sunw", "");
    }

    /*
     * Exception decompiling
     */
    protected void validateFile(IFile f, IReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 139->143)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void connect(IDocument document) {
        this.fDocument = document;
    }

    public void disconnect(IDocument document) {
        this.fDuplicatePrefixes.clear();
    }

    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        this.validate(dirtyRegion, helper, reporter, null);
    }

    private void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter, IFile file) {
        if (this.fDocument instanceof IStructuredDocument) {
            IStructuredDocument sDoc = (IStructuredDocument)this.fDocument;
            IStructuredDocumentRegion[] regions = sDoc.getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength());
            int i = 0;
            while (i < regions.length) {
                if (regions[i].getType() == "JSP_DIRECTIVE_NAME") {
                    this.validateDirective(reporter, file, sDoc, regions[i]);
                }
                ++i;
            }
        }
    }

    private void validateDirective(IReporter reporter, IFile file, IStructuredDocument sDoc, IStructuredDocumentRegion sdRegion) {
        if (this.getDirectiveName(sdRegion).equals("taglib")) {
            String msgText;
            ITextRegion valueRegion = this.getAttributeValueRegion(sdRegion, "prefix");
            if (valueRegion == null) {
                return;
            }
            String taglibPrefix = sdRegion.getText(valueRegion);
            int start = sdRegion.getStartOffset(valueRegion);
            int length = taglibPrefix.length();
            taglibPrefix = StringUtils.stripQuotes((String)taglibPrefix);
            int sev = 1;
            JSPValidator.LocalizedMessage message = null;
            if (this.isReservedPrefix(taglibPrefix)) {
                msgText = String.valueOf(JSPCoreMessages.JSPDirectiveValidator_0) + taglibPrefix + "'";
                message = file == null ? new JSPValidator.LocalizedMessage(this, sev, msgText) : new JSPValidator.LocalizedMessage((JSPValidator)this, sev, msgText, (IResource)file);
            } else if (this.isDuplicatePrefix(sdRegion, taglibPrefix)) {
                msgText = String.valueOf(JSPCoreMessages.JSPDirectiveValidator_2) + taglibPrefix + "'";
                JSPValidator.LocalizedMessage localizedMessage = message = file == null ? new JSPValidator.LocalizedMessage(this, sev, msgText) : new JSPValidator.LocalizedMessage((JSPValidator)this, sev, msgText, (IResource)file);
            }
            if (message != null) {
                int lineNo = sDoc.getLineOfOffset(start);
                message.setLineNo(lineNo);
                message.setOffset(start);
                message.setLength(length);
                reporter.addMessage((IValidator)this, (IMessage)message);
            }
        }
    }

    private boolean isDuplicatePrefix(IStructuredDocumentRegion region, String taglibPrefix) {
        boolean dupe = false;
        Object o = this.fDuplicatePrefixes.get(taglibPrefix);
        if (o == null) {
            this.fDuplicatePrefixes.put(taglibPrefix, region);
        } else if (o instanceof IStructuredDocumentRegion) {
            if (((IStructuredDocumentRegion)o).isDeleted()) {
                this.fDuplicatePrefixes.put(taglibPrefix, region);
            } else if (region != o) {
                dupe = true;
            }
        }
        return dupe;
    }

    public void cleanup(IReporter reporter) {
        super.cleanup(reporter);
        this.fDuplicatePrefixes.clear();
    }

    private boolean isReservedPrefix(String name) {
        return this.fReservedPrefixes.get(name) != null;
    }
}

