/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Text;

public class AddXSDAttributeDeclarationCommand
extends BaseCommand {
    XSDComplexTypeDefinition xsdComplexTypeDefinition;
    XSDModelGroup xsdModelGroup;
    XSDConcreteComponent parent;
    boolean isReference;
    ArrayList names;

    public AddXSDAttributeDeclarationCommand(String label, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        super(label);
        this.xsdComplexTypeDefinition = xsdComplexTypeDefinition;
    }

    public AddXSDAttributeDeclarationCommand(String label, XSDConcreteComponent parent) {
        super(label);
        this.parent = parent;
    }

    public void execute() {
        XSDAttributeDeclaration attribute = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        if (this.parent == null) {
            if (!this.isReference) {
                attribute.setName(this.getNewName("Attribute"));
                attribute.setTypeDefinition(this.xsdComplexTypeDefinition.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("string"));
            } else {
                attribute.setResolvedAttributeDeclaration(this.setGlobalAttributeReference(this.xsdComplexTypeDefinition.getSchema()));
            }
            XSDAttributeUse attributeUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
            attributeUse.setAttributeDeclaration(attribute);
            attributeUse.setContent(attribute);
            if (this.xsdComplexTypeDefinition.getAttributeContents() != null) {
                this.xsdComplexTypeDefinition.getAttributeContents().add((Object)attributeUse);
                this.formatChild(this.xsdComplexTypeDefinition.getElement());
            }
        } else if (this.parent instanceof XSDSchema) {
            XSDSchema xsdSchema = (XSDSchema)this.parent;
            this.createGlobalXSDAttributeDeclaration(xsdSchema);
        } else if (this.parent instanceof XSDAttributeGroupDefinition) {
            if (!this.isReference) {
                attribute.setTypeDefinition(this.parent.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("string"));
                ArrayList<XSDAttributeDeclaration> list = new ArrayList<XSDAttributeDeclaration>();
                Iterator i = ((XSDAttributeGroupDefinition)this.parent).getResolvedAttributeGroupDefinition().getAttributeUses().iterator();
                while (i.hasNext()) {
                    XSDAttributeUse use = (XSDAttributeUse)i.next();
                    list.add(use.getAttributeDeclaration());
                }
                attribute.setName(XSDCommonUIUtils.createUniqueElementName("NewAttribute", list));
            } else {
                attribute.setResolvedAttributeDeclaration(this.setGlobalAttributeReference(this.parent.getSchema()));
            }
            XSDAttributeUse attributeUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
            attributeUse.setAttributeDeclaration(attribute);
            attributeUse.setContent(attribute);
            ((XSDAttributeGroupDefinition)this.parent).getResolvedAttributeGroupDefinition().getContents().add((Object)attributeUse);
            this.formatChild(this.parent.getElement());
        }
        this.addedXSDConcreteComponent = attribute;
    }

    protected String getNewName(String description) {
        String candidateName = "New" + description;
        XSDComplexTypeDefinition parent = this.xsdComplexTypeDefinition;
        this.names = new ArrayList();
        int i = 1;
        if (parent instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition ct = parent;
            this.walkUpInheritance(ct);
            boolean ready = false;
            while (!ready) {
                ready = true;
                Iterator iter = this.names.iterator();
                while (iter.hasNext()) {
                    String attrName = (String)iter.next();
                    if (!candidateName.equals(attrName)) continue;
                    ready = false;
                    candidateName = "New" + description + String.valueOf(i);
                    ++i;
                }
            }
        }
        return candidateName;
    }

    private void walkUpInheritance(XSDComplexTypeDefinition ct) {
        this.updateNames(ct);
        XSDTypeDefinition typeDef = ct.getBaseTypeDefinition();
        if (ct != ct.getRootType() && typeDef instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition ct2 = (XSDComplexTypeDefinition)typeDef;
            this.walkUpInheritance(ct2);
        }
    }

    private void updateNames(XSDComplexTypeDefinition ct) {
        Iterator iter = ct.getAttributeContents().iterator();
        while (iter.hasNext()) {
            XSDAttributeUse use;
            XSDAttributeDeclaration attr;
            String attrName;
            Object obj = iter.next();
            if (!(obj instanceof XSDAttributeUse) || (attrName = (attr = (use = (XSDAttributeUse)obj).getAttributeDeclaration()).getName()) == null) continue;
            this.names.add(attrName);
        }
    }

    public void setReference(boolean isReference) {
        this.isReference = isReference;
    }

    protected XSDAttributeDeclaration createGlobalXSDAttributeDeclaration(XSDSchema xsdSchema) {
        AddXSDAttributeDeclarationCommand.ensureSchemaElement(xsdSchema);
        XSDAttributeDeclaration attribute = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        attribute.setTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        attribute.setName(XSDCommonUIUtils.createUniqueElementName("NewAttribute", (List)xsdSchema.getAttributeDeclarations()));
        Text textNode = xsdSchema.getDocument().createTextNode("\n");
        xsdSchema.getElement().appendChild(textNode);
        xsdSchema.getContents().add((Object)attribute);
        return attribute;
    }

    protected XSDAttributeDeclaration setGlobalAttributeReference(XSDSchema xsdSchema) {
        EList list = xsdSchema.getAttributeDeclarations();
        XSDAttributeDeclaration referencedAttribute = null;
        boolean isUserDefined = false;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            XSDAttributeDeclaration attr;
            Object obj = i.next();
            if (!(obj instanceof XSDAttributeDeclaration) || "http://www.w3.org/2001/XMLSchema-instance".equals((attr = (XSDAttributeDeclaration)obj).getTargetNamespace())) continue;
            referencedAttribute = attr;
            isUserDefined = true;
            break;
        }
        if (!isUserDefined) {
            referencedAttribute = this.createGlobalXSDAttributeDeclaration(xsdSchema);
            Text textNode = xsdSchema.getDocument().createTextNode("\n");
            xsdSchema.getElement().appendChild(textNode);
            xsdSchema.getContents().add((Object)referencedAttribute);
        }
        return referencedAttribute;
    }
}

