/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.design.editparts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.ViewportLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.wst.xsd.ui.internal.adapters.CategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ITreeElement;
import org.eclipse.wst.xsd.ui.internal.adt.typeviz.design.figures.HeadingFigure;
import org.eclipse.wst.xsd.ui.internal.adt.typeviz.design.figures.RoundedLineBorder;
import org.eclipse.wst.xsd.ui.internal.design.editparts.TopLevelComponentEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editpolicies.SelectionHandlesEditPolicyImpl;
import org.eclipse.wst.xsd.ui.internal.design.layouts.ContainerLayout;
import org.eclipse.wst.xsd.ui.internal.design.layouts.FillLayout;

public class CategoryEditPart
extends BaseEditPart {
    protected SelectionHandlesEditPolicyImpl selectionHandlesEditPolicy;
    Figure outerPane;
    HeadingFigure headingFigure;
    protected ScrollPane scrollpane;

    public int getType() {
        return ((CategoryAdapter)this.getModel()).getGroupType();
    }

    protected IFigure createFigure() {
        this.outerPane = new Figure();
        this.outerPane.setBorder((Border)new RoundedLineBorder(1, 6));
        this.headingFigure = new HeadingFigure();
        this.outerPane.add((IFigure)this.headingFigure);
        this.headingFigure.getLabel().setText(((CategoryAdapter)this.getModel()).getText());
        this.headingFigure.getLabel().setIcon(((CategoryAdapter)this.getModel()).getImage());
        int minHeight = 250;
        switch (this.getType()) {
            case 6: {
                minHeight = 80;
                break;
            }
            case 1: 
            case 5: {
                minHeight = 100;
            }
        }
        final int theMinHeight = minHeight;
        FillLayout outerLayout = new FillLayout(){

            protected Dimension calculatePreferredSize(IFigure parent, int width, int height) {
                Dimension d = super.calculatePreferredSize(parent, width, height);
                d.union(new Dimension(250, theMinHeight));
                return d;
            }
        };
        this.outerPane.setLayoutManager((LayoutManager)outerLayout);
        RectangleFigure line = new RectangleFigure(){

            public Dimension getPreferredSize(int wHint, int hHint) {
                Dimension d = super.getPreferredSize(wHint, hHint);
                d.width += 20;
                d.height = 1;
                return d;
            }
        };
        ToolbarLayout lineLayout = new ToolbarLayout(false);
        lineLayout.setVertical(true);
        lineLayout.setStretchMinorAxis(true);
        line.setLayoutManager((LayoutManager)lineLayout);
        this.outerPane.add((IFigure)line);
        this.scrollpane = new ScrollPane();
        this.scrollpane.setVerticalScrollBarVisibility(1);
        this.outerPane.add((IFigure)this.scrollpane);
        Figure pane = new Figure();
        pane.setBorder((Border)new MarginBorder(5, 8, 5, 8));
        ContainerLayout layout = new ContainerLayout();
        layout.setHorizontal(false);
        layout.setSpacing(0);
        pane.setLayoutManager((LayoutManager)layout);
        Viewport viewport = new Viewport();
        viewport.setContentsTracksHeight(true);
        ViewportLayout viewportLayout = new ViewportLayout(){

            protected Dimension calculatePreferredSize(IFigure parent, int width, int height) {
                Dimension d = super.calculatePreferredSize(parent, width, height);
                d.height = Math.min(d.height, theMinHeight - 25);
                d.width = Math.min(d.width, 300);
                return d;
            }
        };
        viewport.setLayoutManager((LayoutManager)viewportLayout);
        this.scrollpane.setViewport(viewport);
        this.scrollpane.setContents((IFigure)pane);
        return this.outerPane;
    }

    public void refreshVisuals() {
        super.refreshVisuals();
        RoundedLineBorder border = (RoundedLineBorder)this.outerPane.getBorder();
        border.setWidth(this.isSelected ? 2 : 1);
        this.headingFigure.setSelected(this.isSelected);
        this.outerPane.repaint();
        this.headingFigure.getLabel().setText(((CategoryAdapter)this.getModel()).getText());
    }

    public IFigure getContentPane() {
        return this.scrollpane.getContents();
    }

    public Label getNameLabel() {
        return this.headingFigure.getLabel();
    }

    public HeadingFigure getHeadingFigure() {
        return this.headingFigure;
    }

    protected EditPart createChild(Object model) {
        TopLevelComponentEditPart editPart = new TopLevelComponentEditPart();
        editPart.setModel(model);
        editPart.setParent((EditPart)this);
        return editPart;
    }

    protected void createEditPolicies() {
        this.selectionHandlesEditPolicy = new SelectionHandlesEditPolicyImpl();
        this.installEditPolicy("Selection Feedback", (EditPolicy)this.selectionHandlesEditPolicy);
    }

    protected List getModelChildren() {
        CategoryAdapter adapter = (CategoryAdapter)this.getModel();
        ArrayList<ITreeElement> children = new ArrayList<ITreeElement>(Arrays.asList(adapter.getAllChildren()));
        return children;
    }

    public void scrollTo(AbstractGraphicalEditPart topLevel) {
        Rectangle topLevelBounds = topLevel.getFigure().getBounds();
        Rectangle categoryBounds = this.figure.getBounds();
        int scrollValue = this.scrollpane.getVerticalScrollBar().getValue();
        int location = topLevelBounds.y + scrollValue - categoryBounds.y;
        this.scrollpane.scrollVerticalTo(location - categoryBounds.height / 2);
    }
}

