/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.wizards;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.util.ViewUtility;
import org.eclipse.wst.xsd.ui.internal.wizards.RegexNode;
import org.eclipse.xsd.XSDPatternFacet;

public class RegexCompositionPage
extends WizardPage {
    private static final boolean debug = false;
    private StyledText value;
    private StyleRange currentError;
    private Combo terms;
    private Button escapeCheckbox;
    private boolean autoEscapeStatus;
    private Button add;
    private Text repeatValue;
    private Text rangeMinValue;
    private Text rangeMaxValue;
    private Label rangeToLabel;
    private Button singleRadio;
    private Button starRadio;
    private Button plusRadio;
    private Button optionalRadio;
    private Button repeatRadio;
    private Button rangeRadio;
    private XSDPatternFacet pattern;
    private RegexNode node;
    private String regexFlags = "X";
    private boolean isValidToken;
    private Label caretLabel;
    private static final int CARET_LABEL_X_OFFSET = -3;
    private static final int CARET_LABEL_Y_OFFSET = 19;
    private static final int TOKEN = 0;
    private static final int SELECTION = 1;
    private static final int PARSE = 2;
    private static final int NUM_ERROR_MESSAGE_TYPES = 3;
    private String[] currentErrorMessages;

    public RegexCompositionPage(XSDPatternFacet pattern) {
        super(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_COMPOSITION_PAGE_TITLE"));
        this.pattern = pattern;
        this.setTitle(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_COMPOSITION_PAGE_TITLE"));
        this.setDescription(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_COMPOSITION_PAGE_DESCRIPTION"));
    }

    public void createControl(Composite parent) {
        this.node = new RegexNode();
        this.isValidToken = true;
        this.currentErrorMessages = new String[3];
        Composite composite = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0010");
        composite.setLayout((Layout)new GridLayout());
        Composite tokenComposite = new Composite(composite, 0);
        GridLayout tokenCompositeLayout = new GridLayout();
        tokenCompositeLayout.numColumns = 3;
        tokenCompositeLayout.marginWidth = 0;
        tokenComposite.setLayout((Layout)tokenCompositeLayout);
        new Label(tokenComposite, 16384).setText(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_TOKEN_LABEL"));
        this.terms = new Combo(tokenComposite, 4);
        WorkbenchHelp.setHelp((Control)this.terms, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0015");
        int i = 0;
        while (i < RegexNode.getNumRegexTerms()) {
            this.terms.add(RegexNode.getRegexTermText(i));
            ++i;
        }
        this.terms.addListener(24, (Listener)new ComboListener());
        this.terms.setToolTipText(XSDEditorPlugin.getXSDString("_UI_TOOLTIP_REGEX_WIZARD_TERMS"));
        this.escapeCheckbox = new Button(tokenComposite, 32);
        this.escapeCheckbox.setText(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_AUTO_ESCAPE_CHECKBOX_LABEL"));
        this.escapeCheckbox.setToolTipText(XSDEditorPlugin.getXSDString("_UI_TOOLTIP_REGEX_WIZARD_AUTO_ESCAPE_CHECKBOX"));
        this.escapeCheckbox.addSelectionListener((SelectionListener)new CheckboxListener());
        this.autoEscapeStatus = false;
        tokenComposite.pack();
        Group occurrenceSelectionArea = new Group(composite, 0);
        occurrenceSelectionArea.setText(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_OCCURENCE_LABEL"));
        WorkbenchHelp.setHelp((Control)occurrenceSelectionArea, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0020");
        GridLayout selectionAreaLayout = new GridLayout();
        selectionAreaLayout.numColumns = 2;
        occurrenceSelectionArea.setLayout((Layout)selectionAreaLayout);
        TextListener textListener = new TextListener();
        RadioSelectListener radioSelectListener = new RadioSelectListener();
        this.singleRadio = this.addOccurenceRadioButton(0, (Composite)occurrenceSelectionArea, radioSelectListener);
        WorkbenchHelp.setHelp((Control)this.singleRadio, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0030");
        ViewUtility.createHorizontalFiller((Composite)occurrenceSelectionArea, 1);
        this.starRadio = this.addOccurenceRadioButton(1, (Composite)occurrenceSelectionArea, radioSelectListener);
        WorkbenchHelp.setHelp((Control)this.starRadio, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0040");
        ViewUtility.createHorizontalFiller((Composite)occurrenceSelectionArea, 1);
        this.plusRadio = this.addOccurenceRadioButton(2, (Composite)occurrenceSelectionArea, radioSelectListener);
        WorkbenchHelp.setHelp((Control)this.plusRadio, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0050");
        ViewUtility.createHorizontalFiller((Composite)occurrenceSelectionArea, 1);
        this.optionalRadio = this.addOccurenceRadioButton(3, (Composite)occurrenceSelectionArea, radioSelectListener);
        WorkbenchHelp.setHelp((Control)this.optionalRadio, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0060");
        ViewUtility.createHorizontalFiller((Composite)occurrenceSelectionArea, 1);
        this.repeatRadio = this.addOccurenceRadioButton(4, (Composite)occurrenceSelectionArea, radioSelectListener);
        WorkbenchHelp.setHelp((Control)this.repeatRadio, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0070");
        Composite repeatWidgets = new Composite((Composite)occurrenceSelectionArea, 0);
        RowLayout repeatWidgetsLayout = new RowLayout();
        repeatWidgetsLayout.marginTop = 0;
        repeatWidgetsLayout.marginBottom = 0;
        repeatWidgetsLayout.marginLeft = 0;
        repeatWidgetsLayout.marginRight = 0;
        repeatWidgets.setLayout((Layout)repeatWidgetsLayout);
        this.repeatValue = new Text(repeatWidgets, 2052);
        this.repeatValue.addListener(24, (Listener)textListener);
        WorkbenchHelp.setHelp((Control)this.repeatValue, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0090");
        this.repeatValue.setToolTipText(XSDEditorPlugin.getXSDString("_UI_TOOLTIP_REGEX_WIZARD_REPEAT"));
        this.setEnabledStatus(4, false);
        repeatWidgets.pack();
        this.rangeRadio = this.addOccurenceRadioButton(5, (Composite)occurrenceSelectionArea, radioSelectListener);
        WorkbenchHelp.setHelp((Control)this.rangeRadio, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0080");
        Composite rangeWidgets = new Composite((Composite)occurrenceSelectionArea, 0);
        RowLayout rangeWidgetsLayout = new RowLayout();
        rangeWidgetsLayout.marginTop = 0;
        rangeWidgetsLayout.marginBottom = 0;
        rangeWidgetsLayout.marginLeft = 0;
        rangeWidgetsLayout.marginRight = 0;
        rangeWidgets.setLayout((Layout)rangeWidgetsLayout);
        this.rangeMinValue = new Text(rangeWidgets, 2052);
        this.rangeMinValue.addListener(24, (Listener)textListener);
        WorkbenchHelp.setHelp((Control)this.rangeMinValue, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0100");
        this.rangeMinValue.setToolTipText(XSDEditorPlugin.getXSDString("_UI_TOOLTIP_REGEX_WIZARD_MIN"));
        this.rangeToLabel = new Label(rangeWidgets, 0);
        this.rangeToLabel.setText(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_TO_LABEL"));
        this.rangeMaxValue = new Text(rangeWidgets, 2052);
        this.rangeMaxValue.addListener(24, (Listener)textListener);
        this.rangeMaxValue.setToolTipText(XSDEditorPlugin.getXSDString("_UI_TOOLTIP_REGEX_WIZARD_MAX"));
        WorkbenchHelp.setHelp((Control)this.rangeMaxValue, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0110");
        this.setEnabledStatus(5, false);
        rangeWidgets.pack();
        this.singleRadio.setSelection(true);
        occurrenceSelectionArea.pack();
        this.add = new Button(composite, 8);
        this.add.addSelectionListener((SelectionListener)new ButtonSelectListener());
        this.add.setText(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_ADD_BUTTON_LABEL"));
        WorkbenchHelp.setHelp((Control)this.add, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0120");
        this.add.setToolTipText(XSDEditorPlugin.getXSDString("_UI_TOOLTIP_REGEX_WIZARD_ADD_BUTTON"));
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        Label valueLabel = new Label(composite, 16384);
        valueLabel.setText(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_CURRENT_REGEX_LABEL"));
        this.value = new StyledText(composite, 2052);
        this.value.addListener(24, (Listener)textListener);
        this.value.addListener(13, (Listener)textListener);
        WorkbenchHelp.setHelp((Control)this.value, (String)"org.eclipse.wst.xsd.ui.internal.xsdr0130");
        this.value.setToolTipText(XSDEditorPlugin.getXSDString("_UI_TOOLTIP_REGEX_WIZARD_CURRENT_REGEX"));
        this.value.setLayoutData((Object)new GridData(768));
        this.value.setFocus();
        this.currentError = new StyleRange();
        this.currentError.length = 1;
        this.currentError.foreground = parent.getDisplay().getSystemColor(3);
        this.caretLabel = new Label(composite, 16384);
        this.caretLabel.setImage(XSDEditorPlugin.getXSDImage("icons/RegexWizardArrow.gif"));
        this.caretLabel.setToolTipText(XSDEditorPlugin.getXSDString("_UI_TOOLTIP_REGEX_WIZARD_CARET_LABEL"));
        this.setShowCaretLabel(true);
        this.value.addFocusListener((FocusListener)new TextFocusListener());
        this.terms.select(0);
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.value.setText(this.pattern.getLexicalValue());
        this.value.setCaretOffset(this.value.getCharCount());
    }

    public void dispose() {
        super.dispose();
    }

    private void setShowCaretLabel(boolean status) {
        if (status) {
            int offset = this.value.getSelectionText().equals("") ? this.value.getCaretOffset() : this.value.getSelection().x;
            Point p = this.value.getLocationAtOffset(offset);
            p.x += this.value.getLocation().x;
            p.y = this.value.getLocation().y;
            p.x += -3;
            p.y += 19;
            this.caretLabel.setLocation(p);
            this.caretLabel.setVisible(true);
        } else {
            this.caretLabel.setVisible(false);
        }
    }

    private Button addOccurenceRadioButton(int quantifier, Composite c, SelectionListener l) {
        Button result = new Button(c, 16);
        result.setText(RegexNode.getQuantifierText(quantifier));
        result.addSelectionListener(l);
        return result;
    }

    private boolean validateRegex() {
        boolean isValid;
        try {
            isValid = true;
            this.displayRegexErrorMessage(null);
            this.value.setStyleRange(null);
            Pattern.compile(this.value.getText());
        }
        catch (PatternSyntaxException pe) {
            isValid = false;
            this.displayRegexErrorMessage(pe.getMessage());
            this.currentError.start = pe.getIndex() >= this.value.getText().length() ? this.value.getText().length() - 1 : pe.getIndex();
            this.value.setStyleRange(this.currentError);
        }
        catch (RuntimeException runtimeException) {
            this.displayRegexErrorMessage("");
            this.value.setStyleRange(null);
            isValid = false;
        }
        this.setPageComplete(isValid);
        return isValid;
    }

    private void displayErrorMessage(String errorMessage, int type) {
        String messageToDisplay = null;
        this.currentErrorMessages[type] = errorMessage;
        messageToDisplay = errorMessage;
        int i = 0;
        while (i < 3) {
            if (messageToDisplay != null) break;
            messageToDisplay = this.currentErrorMessages[i];
            ++i;
        }
        this.setErrorMessage(messageToDisplay);
    }

    private void displayRegexErrorMessage(String errorMessage) {
        if (errorMessage == null) {
            this.displayErrorMessage(null, 2);
        } else if (errorMessage.trim().equals("")) {
            this.displayErrorMessage(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_INVALID_REGEX_ERROR"), 2);
        } else {
            this.displayErrorMessage(errorMessage, 2);
        }
    }

    private void setTokenStatus(boolean status, String errorMessage, int type) {
        boolean otherTypeStatus = type == 0 ? this.currentErrorMessages[1] == null : this.currentErrorMessages[0] == null;
        this.isValidToken = status && otherTypeStatus;
        this.add.setEnabled(this.isValidToken);
        if (status) {
            this.displayErrorMessage(null, type);
        } else if (errorMessage != null && errorMessage.trim().equals("")) {
            this.displayErrorMessage(XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_INVALID_TOKEN_ERROR"), type);
        } else {
            this.displayErrorMessage(errorMessage, type);
        }
    }

    private void setTokenStatus(boolean status, int type) {
        this.setTokenStatus(status, null, type);
    }

    private void setEnabledStatus(int quantifier, boolean status) {
        switch (quantifier) {
            case 4: {
                this.repeatValue.setEnabled(status);
                if (!status) break;
                this.rangeMinValue.setEnabled(false);
                this.rangeMaxValue.setEnabled(false);
                this.rangeToLabel.setEnabled(false);
                break;
            }
            case 5: {
                this.rangeMinValue.setEnabled(status);
                this.rangeMaxValue.setEnabled(status);
                this.rangeToLabel.setEnabled(status);
                if (!status) break;
                this.repeatValue.setEnabled(false);
            }
        }
    }

    private void updateCurrentSelectionStatus() {
        if (this.terms.getSelectionIndex() == RegexNode.SELECTION) {
            String selection = this.value.getSelectionText();
            if (selection.equals("")) {
                this.setTokenStatus(false, XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_INVALID_SELECTION_ERROR"), 1);
            } else {
                this.setTokenStatus(true, 1);
                this.node.setContents(selection);
                this.node.setHasParens(true);
            }
        } else {
            this.setTokenStatus(true, 1);
        }
    }

    private void setEscapeCheckboxEnabledStatus(boolean status) {
        if (status) {
            this.escapeCheckbox.setEnabled(true);
            this.escapeCheckbox.setSelection(this.autoEscapeStatus);
            this.node.setAutoEscapeStatus(this.autoEscapeStatus);
        } else {
            this.escapeCheckbox.setEnabled(false);
            this.escapeCheckbox.setSelection(false);
            this.node.setAutoEscapeStatus(false);
        }
    }

    String getFlags() {
        return this.regexFlags;
    }

    XSDPatternFacet getPattern() {
        return this.pattern;
    }

    private String getAllFieldValues() {
        String result = "";
        result = String.valueOf(result) + "Min: " + this.node.getMin() + "\n";
        result = String.valueOf(result) + "Max: " + this.node.getMax() + "\n";
        result = String.valueOf(result) + "Repeat: " + this.node.getRepeat() + "\n";
        result = String.valueOf(result) + "\n";
        return result;
    }

    class ButtonSelectListener
    implements SelectionListener {
        ButtonSelectListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!RegexCompositionPage.this.isValidToken) {
                return;
            }
            boolean isActiveSelection = RegexCompositionPage.this.value.getSelectionCount() != 0;
            RegexCompositionPage.this.value.insert(RegexCompositionPage.this.node.toString());
            if (RegexCompositionPage.this.terms.getSelectionIndex() == RegexNode.SELECTION) {
                RegexCompositionPage.this.updateCurrentSelectionStatus();
            }
            if (!isActiveSelection) {
                RegexCompositionPage.this.value.setCaretOffset(RegexCompositionPage.this.value.getCaretOffset() + RegexCompositionPage.this.node.toString().length());
            }
            RegexCompositionPage.this.value.setFocus();
        }
    }

    class CheckboxListener
    implements SelectionListener {
        CheckboxListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean newStatus = !RegexCompositionPage.this.autoEscapeStatus;
            RegexCompositionPage.this.node.setAutoEscapeStatus(newStatus);
            RegexCompositionPage.this.autoEscapeStatus = newStatus;
        }
    }

    class ComboListener
    implements Listener {
        ComboListener() {
        }

        public void handleEvent(Event e) {
            RegexCompositionPage.this.updateCurrentSelectionStatus();
            if (RegexCompositionPage.this.terms.getSelectionIndex() == -1) {
                RegexCompositionPage.this.setEscapeCheckboxEnabledStatus(true);
                RegexCompositionPage.this.node.setContents(RegexCompositionPage.this.terms.getText());
                RegexCompositionPage.this.node.setHasParens(true);
            } else if (RegexCompositionPage.this.terms.getSelectionIndex() == RegexNode.SELECTION) {
                RegexCompositionPage.this.setEscapeCheckboxEnabledStatus(false);
            } else {
                RegexCompositionPage.this.node.setContents(RegexNode.getRegexTermValue(RegexCompositionPage.this.terms.getSelectionIndex()));
                RegexCompositionPage.this.node.setHasParens(false);
                RegexCompositionPage.this.setEscapeCheckboxEnabledStatus(false);
            }
        }
    }

    class RadioSelectListener
    implements SelectionListener {
        RadioSelectListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            int currentQuantifier = this.getQuantifier(e);
            RegexCompositionPage.this.node.setQuantifier(currentQuantifier);
            switch (currentQuantifier) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    RegexCompositionPage.this.setEnabledStatus(4, false);
                    RegexCompositionPage.this.setEnabledStatus(5, false);
                    RegexCompositionPage.this.setTokenStatus(true, 0);
                    break;
                }
                case 4: {
                    RegexCompositionPage.this.setEnabledStatus(4, true);
                    RegexCompositionPage.this.setTokenStatus(RegexCompositionPage.this.node.hasValidRepeat(), XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_INVALID_REPEAT_ERROR_SUFFIX"), 0);
                    RegexCompositionPage.this.repeatValue.setFocus();
                    break;
                }
                case 5: {
                    RegexCompositionPage.this.setEnabledStatus(5, true);
                    String error = RegexCompositionPage.this.node.hasValidMin() ? XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_INVALID_MAX_ERROR_SUFFIX") : XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_INVALID_MIN_ERROR_SUFFIX");
                    RegexCompositionPage.this.setTokenStatus(RegexCompositionPage.this.node.hasValidMin() && RegexCompositionPage.this.node.hasValidMax(), error, 0);
                    RegexCompositionPage.this.rangeMinValue.setFocus();
                }
            }
        }

        private int getQuantifier(SelectionEvent e) {
            if (e.widget == RegexCompositionPage.this.singleRadio) {
                return 0;
            }
            if (e.widget == RegexCompositionPage.this.starRadio) {
                return 1;
            }
            if (e.widget == RegexCompositionPage.this.plusRadio) {
                return 2;
            }
            if (e.widget == RegexCompositionPage.this.optionalRadio) {
                return 3;
            }
            if (e.widget == RegexCompositionPage.this.repeatRadio) {
                return 4;
            }
            if (e.widget == RegexCompositionPage.this.rangeRadio) {
                return 5;
            }
            return -1;
        }
    }

    class TextFocusListener
    implements FocusListener {
        TextFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            RegexCompositionPage.this.setShowCaretLabel(false);
        }

        public void focusLost(FocusEvent e) {
            RegexCompositionPage.this.setShowCaretLabel(true);
        }
    }

    class TextListener
    implements Listener {
        TextListener() {
        }

        public void handleEvent(Event e) {
            if (e.widget == RegexCompositionPage.this.value && e.type == 24) {
                RegexCompositionPage.this.pattern.setLexicalValue(RegexCompositionPage.this.value.getText());
                RegexCompositionPage.this.validateRegex();
            } else if (e.widget == RegexCompositionPage.this.value && e.type == 13) {
                if (RegexCompositionPage.this.terms.getSelectionIndex() == RegexNode.SELECTION) {
                    RegexCompositionPage.this.updateCurrentSelectionStatus();
                }
            } else if (e.widget == RegexCompositionPage.this.rangeMinValue) {
                boolean isValid = RegexCompositionPage.this.node.setMin(RegexCompositionPage.this.rangeMinValue.getText());
                if (isValid) {
                    RegexCompositionPage.this.setTokenStatus(true, null, 0);
                } else {
                    RegexCompositionPage.this.setTokenStatus(false, XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_INVALID_MIN_ERROR_SUFFIX"), 0);
                }
            } else if (e.widget == RegexCompositionPage.this.rangeMaxValue) {
                boolean isValid = RegexCompositionPage.this.node.setMax(RegexCompositionPage.this.rangeMaxValue.getText());
                if (RegexCompositionPage.this.node.getMin() == -1) {
                    RegexCompositionPage.this.setTokenStatus(false, XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_MISSING_MIN_ERROR_SUFFIX"), 0);
                } else if (isValid) {
                    RegexCompositionPage.this.setTokenStatus(true, null, 0);
                } else {
                    RegexCompositionPage.this.setTokenStatus(false, XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_INVALID_MAX_ERROR_SUFFIX"), 0);
                }
            } else {
                boolean isValid = RegexCompositionPage.this.node.setRepeat(RegexCompositionPage.this.repeatValue.getText());
                if (isValid) {
                    RegexCompositionPage.this.setTokenStatus(true, null, 0);
                } else {
                    RegexCompositionPage.this.setTokenStatus(false, XSDEditorPlugin.getXSDString("_UI_REGEX_WIZARD_INVALID_REPEAT_ERROR_SUFFIX"), 0);
                }
            }
        }
    }
}

