/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.refactor.listeners;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class J2EEElementChangedListener
implements IElementChangedListener {
    public void elementChanged(ElementChangedEvent event) {
        this.processJavaElementDelta(event.getDelta());
    }

    private void processJavaElementDelta(IJavaElementDelta delta) {
        block3: {
            IJavaProject jproject;
            IProject project;
            IJavaElement element;
            int flags;
            block4: {
                int kind = delta.getKind();
                if (kind != 4) break block3;
                flags = delta.getFlags();
                element = delta.getElement();
                if ((flags & 8) != 8) break block3;
                if (!(element instanceof IJavaModel)) break block4;
                IJavaElementDelta[] children = delta.getChangedChildren();
                int i = 0;
                while (i < children.length) {
                    this.processJavaElementDelta(children[i]);
                    ++i;
                }
                break block3;
            }
            if (!(element instanceof IJavaProject) || (flags & 0x20000) == 0 || ModuleCoreNature.getModuleCoreNature((IProject)(project = (jproject = (IJavaProject)element).getProject())) == null) break block3;
            try {
                this.alterMapping(delta.getAffectedChildren(), jproject, project);
            }
            catch (CoreException ce) {
                Logger.getLogger().logError((Throwable)ce);
            }
        }
    }

    private void alterMapping(IJavaElementDelta[] children, IJavaProject jproject, final IProject project) throws CoreException {
        int i = 0;
        while (i < children.length) {
            IJavaElementDelta delta = children[i];
            IJavaElement element = delta.getElement();
            int kind = delta.getKind();
            int flags = delta.getFlags();
            if (element instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                int cpeKind = 1;
                try {
                    cpeKind = root.getKind();
                }
                catch (JavaModelException javaModelException) {
                    cpeKind = 2;
                }
                final IPath path = root.getPath().removeFirstSegments(1);
                WorkspaceJob job = null;
                if (kind == 1 || (flags & 0x40) == 64) {
                    if (cpeKind == 1) {
                        job = new WorkspaceJob("J2EEComponentLinkAdditionJob"){

                            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                J2EEElementChangedListener.this.getDestinationFolder(project).createLink(path, 0, monitor);
                                return Status.OK_STATUS;
                            }
                        };
                    }
                } else if ((flags & 0x80) == 128) {
                    job = new WorkspaceJob("J2EEComponentMappingRemovalJob"){

                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                            J2EEElementChangedListener.this.getDestinationFolder(project).removeLink(path, 0, monitor);
                            return Status.OK_STATUS;
                        }
                    };
                }
                if (job != null) {
                    job.setRule((ISchedulingRule)project);
                    job.schedule();
                }
            }
            ++i;
        }
    }

    private IVirtualFolder getDestinationFolder(IProject project) throws CoreException {
        IVirtualComponent c = ComponentCore.createComponent((IProject)project);
        c.create(0, null);
        IVirtualFolder root = c.getRootFolder();
        if (J2EEProjectUtilities.isDynamicWebProject(project)) {
            return root.getFolder((IPath)new Path("WEB-INF/classes"));
        }
        return root;
    }
}

