/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.core.locator;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.internal.axis.consumption.core.locator.AxisServicesSaxHandler;
import org.eclipse.jst.ws.internal.axis.consumption.core.locator.AxisServletSaxHandler;
import org.eclipse.jst.ws.internal.axis.consumption.core.locator.ServerConfigWSDDVisitor;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.ws.internal.wsfinder.AbstractWebServiceLocator;
import org.eclipse.wst.ws.internal.wsrt.WebServiceClientInfo;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AxisWebServiceLocator
extends AbstractWebServiceLocator {
    private String AXIS_STUB = "org.apache.axis.client.Stub";

    public List getWebServiceClients(IProgressMonitor monitor) {
        LinkedList list = new LinkedList();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)root);
        try {
            javaModel.open(monitor);
            IJavaProject[] javaProjects = javaModel.getJavaProjects();
            int i = 0;
            while (i < javaProjects.length) {
                IType axisStub = javaProjects[i].findType(this.AXIS_STUB);
                if (axisStub != null) {
                    this.addAxisProxies(javaProjects[i], axisStub, list, monitor);
                }
                ++i;
            }
            javaModel.close();
        }
        catch (Exception exception) {}
        return list;
    }

    private void addAxisProxies(IJavaProject javaProject, IType axisStub, List list, IProgressMonitor monitor) {
        try {
            ITypeHierarchy axisStubHierarchy = axisStub.newTypeHierarchy(javaProject, monitor);
            IType[] stubs = axisStubHierarchy.getSubtypes(axisStub);
            int s = 0;
            while (s < stubs.length) {
                IType[] seis = axisStubHierarchy.getSuperInterfaces(stubs[s]);
                int i = 0;
                while (i < seis.length) {
                    try {
                        ITypeHierarchy seiHierarchy = seis[i].newTypeHierarchy(javaProject, monitor);
                        IType[] proxies = seiHierarchy.getSubtypes(seis[i]);
                        int p = 0;
                        while (p < proxies.length) {
                            WebServiceClientInfo wscInfo;
                            if (!proxies[p].getFullyQualifiedName().equals(stubs[s].getFullyQualifiedName()) && (wscInfo = this.newWebServiceClientInfo(proxies[p])) != null) {
                                list.add(wscInfo);
                            }
                            ++p;
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
                ++s;
            }
        }
        catch (Exception exception) {}
    }

    private WebServiceClientInfo newWebServiceClientInfo(IType axisProxy) {
        WebServiceClientInfo wscInfo = null;
        try {
            IPath proxyPath;
            IResource resource = axisProxy.getUnderlyingResource();
            if (resource != null && (proxyPath = resource.getLocation()) != null) {
                String proxyURL = proxyPath.toFile().toURL().toString();
                wscInfo = new WebServiceClientInfo();
                wscInfo.setImplURL(proxyURL);
            }
        }
        catch (Exception exception) {}
        return wscInfo;
    }

    public List getWebServices(IProgressMonitor monitor) {
        Vector webServices = new Vector();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (J2EEUtils.isWebComponent((IProject)project)) {
                try {
                    webServices.addAll(this.getWebServicesFromProject(project, monitor));
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return webServices;
    }

    private List getWebServicesFromProject(IProject project, IProgressMonitor monitor) throws CoreException, ParserConfigurationException, SAXException, IOException {
        IPath webDescriptorPath = J2EEUtils.getWebInfPath((IProject)project).append("/web.xml");
        IFile webXmlFile = ResourcesPlugin.getWorkspace().getRoot().getFile(webDescriptorPath);
        if (webXmlFile != null && this.isAxisServletExisted(webXmlFile, monitor)) {
            ServerConfigWSDDVisitor visitor = new ServerConfigWSDDVisitor();
            project.accept((IResourceVisitor)visitor);
            visitor.visit((IResource)project);
            Vector wsddFiles = visitor.getWsddFiles();
            Vector servicesNames = new Vector();
            int i = 0;
            while (i < wsddFiles.size()) {
                servicesNames.addAll(this.getWebServicesNamesFromAxisConfig((IFile)wsddFiles.get(i), monitor));
                ++i;
            }
            return this.getWebServices(project, servicesNames, monitor);
        }
        return new Vector();
    }

    private boolean isAxisServletExisted(IFile file, IProgressMonitor monitor) throws CoreException, ParserConfigurationException, SAXException, IOException {
        InputStream inputStream = file.getContents();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        AxisServletSaxHandler handler = new AxisServletSaxHandler();
        parser.parse(inputStream, (DefaultHandler)handler);
        inputStream.close();
        return handler.isThereAxisServlet();
    }

    private List getWebServices(IProject project, List servicesNames, IProgressMonitor monitor) {
        Vector<WebServiceInfo> webServices = new Vector<WebServiceInfo>();
        IServer[] servers = ServerUtil.getServersByModule((IModule)ServerUtil.getModule((IProject)project), (IProgressMonitor)monitor);
        int i = 0;
        while (i < servers.length) {
            String host = servers[i].getHost();
            ServerPort httpPort = this.getHttpPort(servers[i].getServerPorts(monitor));
            if (httpPort != null) {
                int j = 0;
                while (j < servicesNames.size()) {
                    WebServiceInfo wsInfo = new WebServiceInfo();
                    String endPointURL = "http://" + host + ":" + httpPort.getPort() + "/" + J2EEUtils.getFirstWebModuleName((IProject)project) + "/services/" + (String)servicesNames.get(j);
                    wsInfo.setEndPointURL(endPointURL);
                    wsInfo.setWsdlURL(String.valueOf(endPointURL) + "?wsdl");
                    webServices.add(wsInfo);
                    ++j;
                }
            }
            ++i;
        }
        return webServices;
    }

    private List getWebServicesNamesFromAxisConfig(IFile file, IProgressMonitor monitor) throws CoreException, ParserConfigurationException, SAXException, IOException {
        InputStream inputStream = file.getContents();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        AxisServicesSaxHandler handler = new AxisServicesSaxHandler();
        parser.parse(inputStream, (DefaultHandler)handler);
        inputStream.close();
        return handler.getWebServicesNames();
    }

    private ServerPort getHttpPort(ServerPort[] ports) {
        int i = 0;
        while (i < ports.length) {
            String name = ports[i].getName();
            if (name != null && name.trim().toLowerCase().equals("http")) {
                return ports[i];
            }
            ++i;
        }
        return null;
    }
}

