/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ui.project.facet;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public final class RuntimeMismatchMarkerResolutions
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        return new IMarkerResolution[]{new Resolution(marker, marker.getAttribute("runtime1", null)), new Resolution(marker, marker.getAttribute("runtime2", null))};
    }

    private static final class Resolution
    implements IMarkerResolution {
        private final IMarker marker;
        private final String runtimeName;

        public Resolution(IMarker marker, String runtimeName) {
            this.marker = marker;
            this.runtimeName = runtimeName;
        }

        public String getLabel() {
            return NLS.bind((String)Resources.useSameRuntime, (Object)this.runtimeName);
        }

        public void run(IMarker marker) {
            IRuntime runtime = RuntimeManager.getRuntime((String)this.runtimeName);
            try {
                this.setRuntime(this.marker.getResource().getProject(), runtime);
                String pjname = this.marker.getAttribute("moduleProject", null);
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                IProject pj = ws.getRoot().getProject(pjname);
                this.setRuntime(pj, runtime);
            }
            catch (CoreException e) {
                ErrorDialog.openError(null, (String)Resources.errorDialogTitle, (String)Resources.errorDialogMessage, (IStatus)e.getStatus());
            }
        }

        private void setRuntime(IProject proj, IRuntime runtime) throws CoreException {
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)proj);
            if (!fproj.getRuntime().equals(runtime)) {
                fproj.setRuntime(runtime, null);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String useSameRuntime;
        public static String errorDialogTitle;
        public static String errorDialogMessage;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.ui.project.facet.RuntimeMismatchMarkerResolutions");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jst.j2ee.ui.project.facet.RuntimeMismatchMarkerResolutions$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }
}

