/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.annotations.ui;

import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.common.internal.annotations.registry.AttributeValueProposalHelper;
import org.eclipse.jst.common.internal.annotations.ui.UIAttributeValueProposalHelper;
import org.eclipse.swt.graphics.Image;

public class AnnotationTagProposal
extends JavaCompletionProposal {
    private static final char QUOTE = '\"';
    private boolean ensureBeginQuote = false;
    private boolean ensureEndQuote = false;
    private String localString;
    private String locText;

    public AnnotationTagProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance);
        this.localString = displayString;
    }

    public AnnotationTagProposal(AttributeValueProposalHelper proposalHelper) {
        this(proposalHelper.getReplacementString(), proposalHelper.getValueOffset(), proposalHelper.getReplacementLength(), null, proposalHelper.getValueDisplayString(), 1);
        if (proposalHelper instanceof UIAttributeValueProposalHelper) {
            this.setImage(((UIAttributeValueProposalHelper)proposalHelper).getImage());
        }
        this.setEnsureBeginQuote(proposalHelper.ensureBeginQuote());
        this.setEnsureEndQuote(proposalHelper.ensureEndQuote());
    }

    public AnnotationTagProposal(UIAttributeValueProposalHelper proposalHelper) {
        this(proposalHelper.getReplacementString(), proposalHelper.getValueOffset(), proposalHelper.getReplacementLength(), proposalHelper.getImage(), proposalHelper.getValueDisplayString(), 1);
        this.setEnsureBeginQuote(proposalHelper.ensureBeginQuote());
        this.setEnsureEndQuote(proposalHelper.ensureEndQuote());
    }

    public String getAdditionalProposalInfo() {
        return this.locText;
    }

    public void setHelpText(String s) {
        this.locText = s;
    }

    public void apply(IDocument document, char trigger, int offset) {
        this.ensureQuotedIfNecessary(document, offset);
        super.apply(document, trigger, offset);
    }

    private void ensureQuotedIfNecessary(IDocument document, int offset) {
        if (this.ensureBeginQuote || this.ensureEndQuote) {
            try {
                char begin = document.getChar(this.getReplacementOffset() - 1);
                char end = document.getChar(offset);
                if (this.ensureBeginQuote && this.ensureEndQuote && begin != '\"' && end != '\"') {
                    StringBuffer b = new StringBuffer();
                    b.append('\"').append(this.localString).append('\"');
                    this.localString = b.toString();
                } else if (this.ensureBeginQuote && begin != '\"') {
                    this.localString = String.valueOf('\"') + this.localString;
                } else if (this.ensureEndQuote && end != '\"') {
                    this.localString = String.valueOf(this.localString) + '\"';
                }
                this.setReplacementString(this.localString);
                this.setCursorPosition(this.localString.length());
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void setEnsureQuoted(boolean ensureQuoted) {
        this.setEnsureBeginQuote(ensureQuoted);
        this.setEnsureEndQuote(ensureQuoted);
    }

    public void setEnsureBeginQuote(boolean ensureBeginQuote) {
        this.ensureBeginQuote = ensureBeginQuote;
    }

    public void setEnsureEndQuote(boolean ensureEndQuote) {
        this.ensureEndQuote = ensureEndQuote;
    }
}

