/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.IClasspathProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;

public class RuntimeClasspathProvider
implements IClasspathProvider {
    private static final IProjectFacet WEB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.web");
    private static final IProjectFacet EJB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
    private static final IProjectFacet EAR_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
    private static final IProjectFacet UTILITY_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.utility");
    private static final IProjectFacet CONNECTOR_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.connector");
    private static final IProjectFacet APP_CLIENT_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.appclient");
    private IRuntimeComponent rc;

    public RuntimeClasspathProvider(IRuntimeComponent rc) {
        this.rc = rc;
    }

    public List getClasspathEntries(IProjectFacetVersion fv) {
        IProjectFacet pf = fv.getProjectFacet();
        if (pf == null) {
            return null;
        }
        if (pf.equals(WEB_FACET) || pf.equals(EJB_FACET) || pf.equals(EAR_FACET) || pf.equals(UTILITY_FACET) || pf.equals(CONNECTOR_FACET) || pf.equals(APP_CLIENT_FACET)) {
            String s = this.rc.getProperty("classpath");
            if (s == null || s.length() == 0) {
                return null;
            }
            IClasspathEntry cpentry = JavaCore.newContainerEntry((IPath)new Path(s));
            return Collections.singletonList(cpentry);
        }
        return null;
    }

    public static final class Factory
    implements IAdapterFactory {
        private static final Class[] ADAPTER_TYPES;
        static /* synthetic */ Class class$0;

        static {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.common.project.facet.core.IClasspathProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            ADAPTER_TYPES = classArray;
        }

        public Object getAdapter(Object adaptable, Class adapterType) {
            IRuntimeComponent rc = (IRuntimeComponent)adaptable;
            return new RuntimeClasspathProvider(rc);
        }

        public Class[] getAdapterList() {
            return ADAPTER_TYPES;
        }
    }
}

