/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editparts;

import java.util.Iterator;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11ParameterForPart;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDMultiPageEditor;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.TypeReferenceDirectEditManager;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.IFeedbackHandler;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.INamedEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.RowLayout;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IParameter;
import org.eclipse.wst.wsdl.ui.internal.asd.util.IOpenExternalEditorHelper;

public class ParameterTypeEditPart
extends BaseEditPart
implements IFeedbackHandler,
INamedEditPart {
    protected SimpleDirectEditPolicy simpleDirectEditPolicy = new SimpleDirectEditPolicy();
    protected Label parameterType;
    protected RowLayout rowLayout = new RowLayout();
    protected MyMouseEventListener mouseEventListener;

    protected IFigure createFigure() {
        Panel figure = new Panel();
        figure.setLayoutManager((LayoutManager)this.rowLayout);
        this.parameterType = new Label();
        this.parameterType.setLabelAlignment(1);
        this.parameterType.setBorder((Border)new MarginBorder(4, 12, 4, 20));
        figure.add((IFigure)this.parameterType);
        return figure;
    }

    protected void refreshVisuals() {
        Image image;
        super.refreshVisuals();
        IParameter param = (IParameter)this.getModel();
        String name = param.getComponentName();
        this.parameterType.setText(name);
        if (this.getModel() instanceof W11ParameterForPart && (image = ((W11ParameterForPart)this.getModel()).getSecondaryImage()) != null) {
            this.parameterType.setIcon(image);
        }
        if (this.isReadOnly()) {
            this.parameterType.setForegroundColor(DesignViewGraphicsConstants.readOnlyLabelColor);
        } else {
            this.parameterType.setForegroundColor(ColorConstants.black);
        }
    }

    public void addFeedback() {
        this.figure.setBackgroundColor(DesignViewGraphicsConstants.tableCellSelectionColor);
    }

    public void removeFeedback() {
        this.figure.setBackgroundColor(this.figure.getParent().getBackgroundColor());
    }

    public Label getLabelFigure() {
        return this.parameterType;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ASDSelectionEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.simpleDirectEditPolicy);
    }

    public void performDirectEdit(Point cursorLocation) {
        if (this.hitTest(this.parameterType, cursorLocation) && !this.isReadOnly()) {
            IParameter param = (IParameter)this.getModel();
            TypeReferenceDirectEditManager manager = new TypeReferenceDirectEditManager(param, this, this.parameterType);
            this.simpleDirectEditPolicy.setDelegate(manager);
            manager.show();
        } else if (this.hitTest(this.parameterType, cursorLocation) && this.isReadOnly()) {
            this.doOpenNewEditor();
        }
    }

    public void activate() {
        super.activate();
        IFigure feedBackLayer = this.getLayer("Feedback Layer");
        if (!(feedBackLayer.getLayoutManager() instanceof XYLayout)) {
            feedBackLayer.setLayoutManager((LayoutManager)new XYLayout());
        }
        IFigure primaryLayer = this.getLayer("Primary Layer");
        this.mouseEventListener = new MyMouseEventListener(this.getModel());
        primaryLayer.addMouseMotionListener((MouseMotionListener)this.mouseEventListener);
        primaryLayer.addMouseListener((MouseListener)this.mouseEventListener);
    }

    public void deactivate() {
        if (this.mouseEventListener != null) {
            this.mouseEventListener.discardLinkFigure();
            IFigure primaryLayer = this.getLayer("Primary Layer");
            primaryLayer.removeMouseMotionListener((MouseMotionListener)this.mouseEventListener);
            primaryLayer.removeMouseListener((MouseListener)this.mouseEventListener);
        }
    }

    private class MyLinkFigure
    extends Polygon {
        private PointList points = new PointList();
        public int horizontalBuffer = 4;
        public int verticalBuffer = 6;

        public MyLinkFigure() {
            this.points.addPoint(new Point(this.horizontalBuffer + 0, 4 + this.verticalBuffer));
            this.points.addPoint(new Point(this.horizontalBuffer + 9, 4 + this.verticalBuffer));
            this.points.addPoint(new Point(this.horizontalBuffer + 9, 0 + this.verticalBuffer));
            this.points.addPoint(new Point(this.horizontalBuffer + 14, 5 + this.verticalBuffer));
            this.points.addPoint(new Point(this.horizontalBuffer + 9, 10 + this.verticalBuffer));
            this.points.addPoint(new Point(this.horizontalBuffer + 9, 6 + this.verticalBuffer));
            this.points.addPoint(new Point(this.horizontalBuffer + 0, 6 + this.verticalBuffer));
            this.points.addPoint(new Point(this.horizontalBuffer + 0, 4 + this.verticalBuffer));
            this.setFill(true);
        }

        public void setLocation(Point newLocation) {
            PointList translatedPoints = new PointList();
            int index = 0;
            while (index < this.points.size()) {
                Point origPoint = this.points.getPoint(index);
                translatedPoints.addPoint(origPoint.translate(newLocation));
                ++index;
            }
            this.setPoints(translatedPoints);
        }
    }

    private class MyMouseEventListener
    extends MouseMotionListener.Stub
    implements MouseListener {
        private MyLinkFigure linkFigure;
        private Object object;
        private IOpenExternalEditorHelper openExternalEditorHelper;

        public MyMouseEventListener(Object object) {
            this.object = object;
            this.linkFigure = new MyLinkFigure();
            this.unemphasizeLinkFigure();
        }

        public void mouseMoved(MouseEvent me) {
            Point pointer = me.getLocation();
            Rectangle figBounds = ParameterTypeEditPart.this.getFigure().getParent().getParent().getBounds();
            if (this.getExternalEditorOpener().linkApplicable()) {
                ParameterTypeEditPart.this.getLayer("Feedback Layer").add((IFigure)this.linkFigure);
                this.setLinkFigureLocation();
                if (this.pointerInRange(figBounds, pointer)) {
                    this.emphasizeLinkFigure();
                } else {
                    this.unemphasizeLinkFigure();
                }
            } else if (this.containsLinkFigure()) {
                ParameterTypeEditPart.this.getLayer("Feedback Layer").remove((IFigure)this.linkFigure);
            }
        }

        private boolean containsLinkFigure() {
            IFigure figure = ParameterTypeEditPart.this.getLayer("Feedback Layer");
            Iterator it = figure.getChildren().iterator();
            while (it.hasNext()) {
                Object item = it.next();
                if (!item.equals((Object)this.linkFigure)) continue;
                return true;
            }
            return false;
        }

        private Rectangle getLinkFigureBounds() {
            if (this.containsLinkFigure()) {
                return this.linkFigure.getBounds();
            }
            return null;
        }

        private boolean pointerInRange(Rectangle figBounds, Point pointer) {
            Rectangle linkBounds = this.getLinkFigureBounds();
            int entireX = figBounds.x;
            int entireY = figBounds.y;
            int entireWidth = figBounds.width + linkBounds.width + this.linkFigure.horizontalBuffer;
            int entireHeight = figBounds.height;
            Rectangle entireBounds = new Rectangle(entireX, entireY, entireWidth, entireHeight);
            return entireBounds.contains(pointer);
        }

        protected void setLinkFigureLocation() {
            Rectangle figureBounds = ParameterTypeEditPart.this.getFigure().getBounds();
            int xStart = figureBounds.x + figureBounds.width;
            int yStart = figureBounds.y;
            Point aPoint = new Point(xStart, yStart);
            this.linkFigure.setLocation(aPoint);
        }

        public void discardLinkFigure() {
            if (this.containsLinkFigure()) {
                ParameterTypeEditPart.this.getLayer("Feedback Layer").remove((IFigure)this.linkFigure);
            }
        }

        protected void emphasizeLinkFigure() {
            this.linkFigure.setForegroundColor(ColorConstants.blue);
            this.linkFigure.setBackgroundColor(ColorConstants.blue);
        }

        protected void unemphasizeLinkFigure() {
            this.linkFigure.setForegroundColor(ColorConstants.lightGray);
            this.linkFigure.setBackgroundColor(ColorConstants.lightGray);
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            Point pointer = me.getLocation();
            Rectangle linkFigBounds = this.getLinkFigureBounds();
            if (linkFigBounds == null) {
                return;
            }
            Rectangle testbounds = new Rectangle(linkFigBounds.x, linkFigBounds.y, 0, linkFigBounds.height);
            if (this.getExternalEditorOpener().linkApplicable() && this.pointerInRange(testbounds, pointer)) {
                this.setLinkFigureLocation();
                this.getExternalEditorOpener().openExternalEditor();
            }
        }

        private IOpenExternalEditorHelper getExternalEditorOpener() {
            if (this.openExternalEditorHelper == null) {
                this.openExternalEditorHelper = ((ASDMultiPageEditor)ASDEditorPlugin.getActiveEditor()).getOpenExternalEditorHelper();
                this.openExternalEditorHelper.setModel(this.object);
            }
            return this.openExternalEditorHelper;
        }
    }

    private class SimpleDirectEditPolicy
    extends DirectEditPolicy {
        protected TypeReferenceDirectEditManager delegate;

        private SimpleDirectEditPolicy() {
        }

        public void setDelegate(TypeReferenceDirectEditManager delegate) {
            this.delegate = delegate;
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            return new Command(this, request){
                final /* synthetic */ SimpleDirectEditPolicy this$1;
                private final /* synthetic */ DirectEditRequest val$request;
                {
                    this.this$1 = simpleDirectEditPolicy;
                    this.val$request = directEditRequest;
                }

                public void execute() {
                    if (this.this$1.delegate != null) {
                        this.this$1.delegate.performEdit(this.val$request.getCellEditor());
                    }
                }

                public void redo() {
                }

                public void undo() {
                }

                public boolean canExecute() {
                    return true;
                }
            };
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
            this.getHostFigure().getUpdateManager().performUpdate();
        }
    }
}

