/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.projection;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.TopLevelNode;
import org.eclipse.wst.dtd.core.internal.event.IDTDFileListener;
import org.eclipse.wst.dtd.core.internal.event.NodesEvent;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.projection.IStructuredTextFoldingProvider;
import org.w3c.dom.Node;

public class StructuredTextFoldingProviderDTD
implements IStructuredTextFoldingProvider,
IProjectionListener,
IDTDFileListener {
    private static final boolean debugProjectionPerf = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.dtd.ui/projectionperf"));
    private IDocument fDocument;
    private ProjectionViewer fViewer;

    private void addAllAnnotations(DTDFile file) {
        long start = System.currentTimeMillis();
        List nodes = file.getNodes();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            DTDNode node = (DTDNode)it.next();
            Position newPos = this.createProjectionPosition((Node)node);
            if (newPos == null) continue;
            TagProjectionAnnotation newAnnotation = new TagProjectionAnnotation((Node)node, false);
            this.fViewer.getProjectionAnnotationModel().addAnnotation((Annotation)newAnnotation, newPos);
        }
        long end = System.currentTimeMillis();
        if (debugProjectionPerf) {
            System.out.println("StructuredTextFoldingProviderDTD.addAllAnnotations: " + (end - start));
        }
    }

    private Position createProjectionPosition(Node node) {
        IDocument document;
        Position pos = null;
        if (this.isNodeProjectable(node) && node instanceof IndexedRegion && (document = this.fViewer.getDocument()) != null) {
            IndexedRegion inode = (IndexedRegion)node;
            int start = inode.getStartOffset();
            int end = inode.getEndOffset();
            if (start >= 0 && start < end) {
                try {
                    int startLine = this.fDocument.getLineOfOffset(start);
                    int endLine = this.fDocument.getLineOfOffset(end);
                    if (startLine < endLine && endLine + 1 < this.fDocument.getNumberOfLines()) {
                        int offset = this.fDocument.getLineOffset(startLine);
                        int endOffset = this.fDocument.getLineOffset(endLine + 1);
                        pos = new Position(offset, endOffset - offset);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return pos;
    }

    private TagProjectionAnnotation findExistingAnnotation(Node node) {
        TagProjectionAnnotation anno = null;
        if (node != null) {
            Iterator it = this.fViewer.getProjectionAnnotationModel().getAnnotationIterator();
            while (it.hasNext() && anno == null) {
                TagProjectionAnnotation a = (TagProjectionAnnotation)((Object)it.next());
                if (!node.equals(a.getNode())) continue;
                anno = a;
            }
        }
        return anno;
    }

    /*
     * Exception decompiling
     */
    private DTDFile getDTDFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 56->59)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        DTDFile file = this.getDTDFile();
        if (file != null) {
            file.removeDTDFileListener((IDTDFileListener)this);
        }
        if (this.fViewer.getProjectionAnnotationModel() != null) {
            this.fViewer.getProjectionAnnotationModel().removeAllAnnotations();
        }
        this.fDocument = this.fViewer.getDocument();
        file = this.getDTDFile();
        if (file != null) {
            file.addDTDFileListener((IDTDFileListener)this);
            this.addAllAnnotations(file);
        }
    }

    public void install(ProjectionViewer viewer) {
        if (this.isInstalled()) {
            this.uninstall();
        }
        this.fViewer = viewer;
        this.fViewer.addProjectionListener((IProjectionListener)this);
    }

    private boolean isInstalled() {
        return this.fViewer != null;
    }

    private boolean isNodeProjectable(Node node) {
        return node != null && node instanceof TopLevelNode;
    }

    public void nodeChanged(DTDNode node) {
        long start = System.currentTimeMillis();
        if (this.isNodeProjectable((Node)node)) {
            TagProjectionAnnotation anno = this.findExistingAnnotation((Node)node);
            Position newPos = this.createProjectionPosition((Node)node);
            if (newPos != null && anno == null) {
                TagProjectionAnnotation newAnnotation = new TagProjectionAnnotation((Node)node, false);
                this.fViewer.getProjectionAnnotationModel().addAnnotation((Annotation)newAnnotation, newPos);
            }
            if (newPos == null && anno != null) {
                this.fViewer.getProjectionAnnotationModel().removeAnnotation((Annotation)anno);
            }
        }
        long end = System.currentTimeMillis();
        if (debugProjectionPerf) {
            String nodeName = node != null ? node.getNodeName() : "null";
            System.out.println("StructuredTextFoldingProviderDTD.nodeChanged (" + nodeName + "):" + (end - start));
        }
    }

    public void nodesAdded(NodesEvent event) {
        long start = System.currentTimeMillis();
        List nodes = event.getNodes();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            Position newPos;
            DTDNode node = (DTDNode)it.next();
            if (!this.isNodeProjectable((Node)node) || (newPos = this.createProjectionPosition((Node)node)) == null) continue;
            TagProjectionAnnotation newAnnotation = new TagProjectionAnnotation((Node)node, false);
            this.fViewer.getProjectionAnnotationModel().addAnnotation((Annotation)newAnnotation, newPos);
        }
        long end = System.currentTimeMillis();
        if (debugProjectionPerf) {
            System.out.println("StructuredTextFoldingProviderDTD.nodesAdded: " + (end - start));
        }
    }

    public void nodesRemoved(NodesEvent event) {
        long start = System.currentTimeMillis();
        List nodes = event.getNodes();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            TagProjectionAnnotation anno;
            DTDNode node = (DTDNode)it.next();
            if (!this.isNodeProjectable((Node)node) || (anno = this.findExistingAnnotation((Node)node)) == null) continue;
            this.fViewer.getProjectionAnnotationModel().removeAnnotation((Annotation)anno);
        }
        long end = System.currentTimeMillis();
        if (debugProjectionPerf) {
            System.out.println("StructuredTextFoldingProviderDTD.nodesRemoved: " + (end - start));
        }
    }

    public void projectionDisabled() {
        DTDFile file = this.getDTDFile();
        if (file != null) {
            file.removeDTDFileListener((IDTDFileListener)this);
        }
        this.fDocument = null;
    }

    public void projectionEnabled() {
        this.initialize();
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer = null;
        }
    }

    private class TagProjectionAnnotation
    extends ProjectionAnnotation {
        private Node fNode;

        public TagProjectionAnnotation(Node node, boolean isCollapsed) {
            super(isCollapsed);
            this.fNode = node;
        }

        public Node getNode() {
            return this.fNode;
        }

        public void setNode(Node node) {
            this.fNode = node;
        }
    }
}

