/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.conformance;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.internal.WSPluginMessages;
import org.eclipse.jst.ws.internal.conformance.IJavaBeanProperty;
import org.eclipse.jst.ws.internal.conformance.IJavaWebServiceRuleEngine;
import org.eclipse.jst.ws.internal.conformance.JDTResolver;
import org.eclipse.jst.ws.internal.conformance.JavaWebServiceRuleSet;
import org.eclipse.osgi.util.NLS;

public class JAXRPCWebServiceRuleEngine
implements IJavaWebServiceRuleEngine {
    private JDTResolver resolver_;
    private IProgressMonitor progressMonitor_;
    private Set visited_;
    private Stack peanutTrail_;

    public JAXRPCWebServiceRuleEngine(IProgressMonitor progressMonitor) {
        this.progressMonitor_ = progressMonitor;
    }

    public IStatus analyze(IProject project, IType rootClass, JavaWebServiceRuleSet rules) {
        this.visited_ = new HashSet();
        this.peanutTrail_ = new Stack();
        this.resolver_ = new JDTResolver(project, this.progressMonitor_);
        Status status = null;
        rules.init(this);
        try {
            this.analyzeServiceClass(rootClass, rules);
            String inCaseOfFailureMessage = NLS.bind((String)WSPluginMessages.MSG_JAXRPC11_NOT_COMPLIANT, (Object)rootClass.getFullyQualifiedName());
            status = rules.getResults(inCaseOfFailureMessage);
        }
        catch (JavaModelException e) {
            status = new Status(4, "org.eclipse.jst.ws", 0, "Internal Error", (Throwable)e);
        }
        return status;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void analyzeServiceClass(IType type, JavaWebServiceRuleSet rules) throws JavaModelException {
        rules.visitClass(type, this.peanutTrail_);
        this.visited_.add(type.getFullyQualifiedName());
        this.push(type);
        try {
            IType[] superClasses = this.resolver_.getSuperClasses(type);
            IMethod[] methods = this.resolver_.getPublicMethods(type, superClasses);
            int m = 0;
            while (m < methods.length) {
                this.analyzeMethod(methods[m], rules);
                ++m;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.pop();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.pop();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void analyzeMethod(IMethod method, JavaWebServiceRuleSet rules) throws JavaModelException {
        rules.visitMethod(method, this.peanutTrail_);
        this.push(method);
        try {
            int e;
            IType[] exceptionTypes;
            IType returnType = this.resolver_.getReturnType(method);
            this.analyzeDataType(returnType, rules);
            IType[] parameterTypes = this.resolver_.getParameterTypes(method);
            int p = 0;
            while (true) {
                if (p >= parameterTypes.length) {
                    exceptionTypes = this.resolver_.getExceptionTypes(method);
                    e = 0;
                    break;
                }
                this.analyzeDataType(parameterTypes[p], rules);
                ++p;
            }
            while (e < exceptionTypes.length) {
                this.analyzeExceptionType(exceptionTypes[e], rules);
                ++e;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.pop();
            throw throwable;
        }
        {
            Object var7_10 = null;
            this.pop();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void analyzeDataType(IType type, JavaWebServiceRuleSet rules) throws JavaModelException {
        if (type == null) return;
        if (this.resolver_.isStandardType(type.getFullyQualifiedName())) return;
        if (this.visited_.contains(type.getFullyQualifiedName())) return;
        rules.visitClass(type, this.peanutTrail_);
        this.visited_.add(type.getFullyQualifiedName());
        this.push(type);
        try {
            int p;
            IJavaBeanProperty[] properties;
            IType[] superClasses = this.resolver_.getSuperClasses(type);
            IField[] fields = this.resolver_.getPublicFields(type, superClasses);
            int f = 0;
            while (true) {
                if (f >= fields.length) {
                    properties = this.resolver_.getPublicProperties(type, superClasses);
                    p = 0;
                    break;
                }
                this.analyzeField(fields[f], rules);
                ++f;
            }
            while (p < properties.length) {
                this.analyzeProperty(properties[p], rules);
                ++p;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.pop();
            throw throwable;
        }
        {
            Object var7_10 = null;
            this.pop();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void analyzeField(IField field, JavaWebServiceRuleSet rules) throws JavaModelException {
        if (field == null) return;
        rules.visitField(field, this.peanutTrail_);
        this.push(field);
        try {
            IType type = this.resolver_.getFieldType(field);
            this.analyzeDataType(type, rules);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.pop();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.pop();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void analyzeProperty(IJavaBeanProperty property, JavaWebServiceRuleSet rules) throws JavaModelException {
        if (property == null) return;
        rules.visitProperty(property, this.peanutTrail_);
        this.push(property);
        try {
            IType type = this.resolver_.getPropertyType(property);
            this.analyzeDataType(type, rules);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.pop();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.pop();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void analyzeExceptionType(IType type, JavaWebServiceRuleSet rules) throws JavaModelException {
        if (type == null) return;
        if (this.resolver_.isStandardType(type.getFullyQualifiedName())) return;
        if (this.visited_.contains(type.getFullyQualifiedName())) return;
        rules.visitException(type, this.peanutTrail_);
        this.visited_.add(type.getFullyQualifiedName());
        this.push(type);
        try {
            IType[] superClasses = this.resolver_.getSuperClasses(type);
            IJavaBeanProperty[] properties = this.resolver_.getPublicProperties(type, superClasses);
            int p = 0;
            while (p < properties.length) {
                this.analyzeProperty(properties[p], rules);
                ++p;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.pop();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.pop();
            return;
        }
    }

    public JDTResolver getJDTResolver() {
        return this.resolver_;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor_;
    }

    private void push(Object peanut) {
        this.peanutTrail_.push(peanut);
    }

    private void pop() {
        this.peanutTrail_.pop();
    }
}

