/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.views.structure;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.jface.DelegatingTreeContentAndLabelProvider;
import org.eclipse.jpt.ui.internal.selection.DefaultJpaSelection;
import org.eclipse.jpt.ui.internal.selection.JpaSelection;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.views.structure.JpaStructureView;
import org.eclipse.jpt.ui.jface.DelegatingContentAndLabelProvider;
import org.eclipse.jpt.ui.structure.JpaStructureProvider;
import org.eclipse.jpt.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class JpaStructurePage
extends Page
implements ISelectionProvider {
    private final JpaStructureView jpaStructureView;
    JpaFile jpaFile;
    private final IFile file;
    private JpaProject jpaProject;
    private final JpaStructureProvider structureProvider;
    private Composite control;
    private DelegatingContentAndLabelProvider contentAndLabelProvider;
    TreeViewer viewer;
    private final ListenerList selectionChangedListenerList;
    private final ISelectionChangedListener treeSelectionListener;
    private final ISelectionChangedListener treePostSelectionListener;
    private final CollectionChangeListener projectsListener;
    private final CollectionChangeListener jpaFilesListener;

    public JpaStructurePage(JpaStructureView jpaStructureView, JpaFile jpaFile, JpaStructureProvider structureProvider) {
        this.jpaStructureView = jpaStructureView;
        this.jpaFile = jpaFile;
        this.jpaProject = jpaFile.getJpaProject();
        this.file = jpaFile.getFile();
        this.structureProvider = structureProvider;
        this.selectionChangedListenerList = new ListenerList();
        this.treeSelectionListener = new TreeSelectionChangedListener();
        this.treePostSelectionListener = new TreePostSelectionChangedListener();
        this.projectsListener = this.buildProjectsListener();
        this.jpaFilesListener = this.buildJpaFilesListener();
    }

    private CollectionChangeListener buildProjectsListener() {
        return new CollectionChangeListener(){

            public void itemsRemoved(CollectionRemoveEvent event) {
                JpaStructurePage.this.projectsRemoved(event);
            }

            public void itemsAdded(CollectionAddEvent event) {
                JpaStructurePage.this.projectsAdded(event);
            }

            public void collectionCleared(CollectionClearEvent event) {
                JpaStructurePage.this.projectsCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                JpaStructurePage.this.projectsChanged(event);
            }
        };
    }

    void projectsRemoved(CollectionRemoveEvent event) {
        for (JpaProject item : event.getItems()) {
            if (item.getProject() != this.file.getProject()) continue;
            this.setJpaProject(null);
            break;
        }
    }

    void projectsAdded(CollectionAddEvent event) {
        for (JpaProject item : event.getItems()) {
            if (item.getProject() != this.file.getProject()) continue;
            this.setJpaProject(item);
            break;
        }
    }

    void projectsCleared(CollectionClearEvent event) {
        this.setJpaProject(null);
    }

    void projectsChanged(CollectionChangeEvent event) {
        this.setJpaProject(JptCorePlugin.getJpaProject((IProject)this.file.getProject()));
    }

    private CollectionChangeListener buildJpaFilesListener() {
        return new CollectionChangeListener(){

            public void itemsRemoved(CollectionRemoveEvent event) {
                JpaStructurePage.this.jpaFilesRemoved(event);
            }

            public void itemsAdded(CollectionAddEvent event) {
                JpaStructurePage.this.jpaFilesAdded(event);
            }

            public void collectionCleared(CollectionClearEvent event) {
                JpaStructurePage.this.jpaFilesCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                JpaStructurePage.this.jpaFilesChanged(event);
            }
        };
    }

    void jpaFilesRemoved(CollectionRemoveEvent event) {
        for (JpaFile item : event.getItems()) {
            if (item != this.jpaFile) continue;
            this.setJpaFile(null);
            break;
        }
    }

    void jpaFilesAdded(CollectionAddEvent event) {
        for (JpaFile item : event.getItems()) {
            if (item.getFile() == null || !item.getFile().equals((Object)this.file)) continue;
            this.setJpaFile(item);
            break;
        }
    }

    void jpaFilesCleared(CollectionClearEvent event) {
        this.setJpaFile(null);
    }

    void jpaFilesChanged(CollectionChangeEvent event) {
        this.setJpaFile(this.jpaProject.getJpaFile(this.file));
    }

    private void setJpaProject(JpaProject jpaProject) {
        if (this.jpaProject == jpaProject) {
            return;
        }
        if (this.jpaProject != null) {
            this.jpaProject.removeCollectionChangeListener("jpaFiles", this.jpaFilesListener);
        }
        this.jpaProject = jpaProject;
        if (this.jpaProject != null) {
            this.jpaProject.addCollectionChangeListener("jpaFiles", this.jpaFilesListener);
            this.setJpaFile(this.jpaProject.getJpaFile(this.file));
        } else {
            this.setJpaFile(null);
        }
    }

    private void setJpaFile(JpaFile jpaFile) {
        if (this.jpaFile == jpaFile) {
            return;
        }
        this.jpaFile = jpaFile;
        SWTUtil.asyncExec(new Runnable(){

            public void run() {
                JpaStructurePage.this.viewer.setInput((Object)JpaStructurePage.this.jpaFile);
            }
        });
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(this.control, 770);
        this.viewer.setAutoExpandLevel(2);
        DelegatingTreeContentAndLabelProvider provider = new DelegatingTreeContentAndLabelProvider(this.structureProvider.getTreeItemContentProviderFactory(), this.structureProvider.getItemLabelProviderFactory());
        this.contentAndLabelProvider = provider;
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.viewer.setInput((Object)this.jpaFile);
        this.engageListeners();
        this.initContextMenu();
    }

    protected void engageListeners() {
        this.viewer.addSelectionChangedListener(this.treeSelectionListener);
        this.viewer.addPostSelectionChangedListener(this.treePostSelectionListener);
        this.jpaProject.addCollectionChangeListener("jpaFiles", this.jpaFilesListener);
        JptCorePlugin.getJpaProjectManager().addCollectionChangeListener("jpaProjects", this.projectsListener);
    }

    public void dispose() {
        this.disengageListeners();
        super.dispose();
    }

    protected void disengageListeners() {
        JptCorePlugin.getJpaProjectManager().removeCollectionChangeListener("jpaProjects", this.projectsListener);
        if (this.jpaProject != null) {
            this.jpaProject.removeCollectionChangeListener("jpaFiles", this.jpaFilesListener);
        }
        this.viewer.removePostSelectionChangedListener(this.treePostSelectionListener);
        this.viewer.removeSelectionChangedListener(this.treeSelectionListener);
    }

    protected void initContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                JpaStructurePage.this.fillContextMenu(menuManager);
            }
        });
        Menu menu = mgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.jpaStructureView.getSite().registerContextMenu(mgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        this.control.setFocus();
    }

    void select(JpaSelection selection) {
        if (selection.isEmpty()) {
            this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        } else {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)selection.getSelectedNode()), true);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListenerList.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListenerList.remove((Object)listener);
    }

    public ITreeSelection getSelection() {
        return (ITreeSelection)this.viewer.getSelection();
    }

    public JpaSelection getJpaSelection() {
        ITreeSelection viewerSelection = this.getSelection();
        if (viewerSelection.isEmpty() || viewerSelection.size() > 1) {
            return JpaSelection.NULL_SELECTION;
        }
        return new DefaultJpaSelection((JpaStructureNode)viewerSelection.getFirstElement());
    }

    public void setSelection(ISelection selection) {
        if (this.viewer != null) {
            this.viewer.setSelection(selection);
        }
    }

    protected void fireSelectionChanged(ISelection selection) {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.selectionChangedListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    protected void updateStatusBar(ISelection selection) {
        IStatusLineManager statusLineManager = this.getSite().getActionBars().getStatusLineManager();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            statusLineManager.setMessage("");
            return;
        }
        IStructuredSelection sselection = (IStructuredSelection)selection;
        if (sselection.size() > 1) {
            statusLineManager.setMessage(NLS.bind((String)JptUiMessages.JpaStructureView_numItemsSelected, (Object)sselection.size()));
        } else {
            Object selObj = sselection.getFirstElement();
            statusLineManager.setMessage(this.contentAndLabelProvider.getImage(selObj), this.contentAndLabelProvider.getDescription(selObj));
        }
    }

    class TreePostSelectionChangedListener
    implements ISelectionChangedListener {
        TreePostSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            JpaStructurePage.this.updateStatusBar(event.getSelection());
        }
    }

    class TreeSelectionChangedListener
    implements ISelectionChangedListener {
        TreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            JpaStructurePage.this.fireSelectionChanged(event.getSelection());
        }
    }
}

