/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.breakpoints;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.jsdt.debug.internal.ui.adapters.JavaScriptAdapterFactory;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IBreakpointProvider;

public class JavaScriptHtmlBreakpointProvider
implements IBreakpointProvider {
    static final String SCRIPT_REGION = "org.eclipse.wst.html.SCRIPT";
    static /* synthetic */ Class class$0;

    public IStatus addBreakpoint(final IDocument document, IEditorInput input, final int lineNumber, int offset) throws CoreException {
        final IResource resource = this.getResource(input);
        if (resource != null && offset > -1) {
            try {
                ITypedRegion region = document.getPartition(document.getLineOffset(lineNumber));
                if (region != null && SCRIPT_REGION.equals(region.getType())) {
                    Job j = new Job("Toggle JavaScript Line Breakpoint"){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                JavaScriptAdapterFactory.getToggleBreakpointAdapter().addBreakpoint(resource, document, lineNumber);
                                return Status.OK_STATUS;
                            }
                            catch (CoreException coreException) {
                                return Status.CANCEL_STATUS;
                            }
                        }
                    };
                    j.setPriority(10);
                    j.schedule();
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return Status.CANCEL_STATUS;
    }

    public IResource getResource(IEditorInput input) {
        IResource resource;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)input.getAdapter((Class)clazz)) == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    public void setSourceEditingTextTools(ISourceEditingTextTools tool) {
    }
}

