/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.platform.generic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.context.MappingFile;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JarFile;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.JarFileRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.ui.internal.jface.AbstractTreeItemContentProvider;
import org.eclipse.jpt.ui.internal.jface.DelegatingTreeContentAndLabelProvider;
import org.eclipse.jpt.ui.internal.platform.generic.JavaPersistentTypeItemContentProvider;
import org.eclipse.jpt.ui.internal.platform.generic.OrmPersistentTypeItemContentProvider;
import org.eclipse.jpt.ui.internal.platform.generic.OrmXmlItemContentProvider;
import org.eclipse.jpt.ui.internal.platform.generic.PersistenceXmlItemContentProvider;
import org.eclipse.jpt.ui.internal.platform.generic.PersistentAttributeItemContentProvider;
import org.eclipse.jpt.ui.internal.platform.generic.RootContextItemContentProvider;
import org.eclipse.jpt.ui.jface.DelegatingContentAndLabelProvider;
import org.eclipse.jpt.ui.jface.TreeItemContentProvider;
import org.eclipse.jpt.ui.jface.TreeItemContentProviderFactory;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.model.value.CollectionAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.CompositeCollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.FilteringCollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListCollectionValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyCollectionValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationListValueModelAdapter;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

public class GenericNavigatorItemContentProviderFactory
implements TreeItemContentProviderFactory {
    public TreeItemContentProvider buildItemContentProvider(Object item, DelegatingContentAndLabelProvider contentAndLabelProvider) {
        DelegatingTreeContentAndLabelProvider treeContentAndLabelProvider = (DelegatingTreeContentAndLabelProvider)contentAndLabelProvider;
        if (item instanceof JpaRootContextNode) {
            return new RootContextItemContentProvider((JpaRootContextNode)item, treeContentAndLabelProvider);
        }
        if (item instanceof PersistenceXml) {
            return new PersistenceXmlItemContentProvider((PersistenceXml)item, treeContentAndLabelProvider);
        }
        if (item instanceof PersistenceUnit) {
            return new PersistenceUnitItemContentProvider((PersistenceUnit)item, treeContentAndLabelProvider);
        }
        if (item instanceof OrmXml) {
            return new OrmXmlItemContentProvider((OrmXml)item, treeContentAndLabelProvider);
        }
        if (item instanceof OrmPersistentType) {
            return new OrmPersistentTypeItemContentProvider((OrmPersistentType)item, treeContentAndLabelProvider);
        }
        if (item instanceof JavaPersistentType) {
            return new JavaPersistentTypeItemContentProvider((JavaPersistentType)item, treeContentAndLabelProvider);
        }
        if (item instanceof PersistentAttribute) {
            return new PersistentAttributeItemContentProvider((PersistentAttribute)item, treeContentAndLabelProvider);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersistenceUnitItemContentProvider
    extends AbstractTreeItemContentProvider<JpaContextNode> {
        public PersistenceUnitItemContentProvider(PersistenceUnit persistenceUnit, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)persistenceUnit, contentProvider);
        }

        public PersistenceUnit getModel() {
            return (PersistenceUnit)super.getModel();
        }

        public PersistenceXml getParent() {
            return this.getModel().getParent().getParent();
        }

        @Override
        protected CollectionValueModel<JpaContextNode> buildChildrenModel() {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.buildSpecifiedOrmXmlCvm());
            list.add(this.buildImpliedMappingFileCvm());
            list.add(this.buildPersistentTypeCvm());
            list.add(this.buildJarFileCvm());
            return new CompositeCollectionValueModel(list);
        }

        protected CollectionValueModel<JpaContextNode> buildSpecifiedOrmXmlCvm() {
            return new FilteringCollectionValueModel<JpaContextNode>((CollectionValueModel)new ListCollectionValueModelAdapter((ListValueModel)new TransformationListValueModelAdapter<MappingFileRef, MappingFile>((ListValueModel)new ItemPropertyListValueModelAdapter((ListValueModel)new ListAspectAdapter<PersistenceUnit, MappingFileRef>("specifiedMappingFileRefs", this.getModel()){

                protected ListIterator<MappingFileRef> listIterator_() {
                    return ((PersistenceUnit)this.subject).specifiedMappingFileRefs();
                }

                protected int size_() {
                    return ((PersistenceUnit)this.subject).specifiedMappingFileRefsSize();
                }
            }, new String[]{"mappingFile"})){

                protected MappingFile transformItem(MappingFileRef item) {
                    return item.getMappingFile();
                }
            })){

                protected Iterable<JpaContextNode> filter(Iterable<? extends JpaContextNode> items) {
                    return new FilteringIterable<JpaContextNode>(items){

                        protected boolean accept(JpaContextNode o) {
                            return o != null;
                        }
                    };
                }
            };
        }

        protected CollectionValueModel<MappingFile> buildImpliedMappingFileCvm() {
            return new PropertyCollectionValueModelAdapter((PropertyValueModel)new PropertyAspectAdapter<MappingFileRef, MappingFile>((PropertyValueModel)new PropertyAspectAdapter<PersistenceUnit, MappingFileRef>("impliedMappingFileRef", this.getModel()){

                protected MappingFileRef buildValue_() {
                    return ((PersistenceUnit)this.subject).getImpliedMappingFileRef();
                }
            }, new String[]{"mappingFile"}){

                protected MappingFile buildValue_() {
                    return ((MappingFileRef)this.subject).getMappingFile();
                }
            });
        }

        protected CollectionValueModel<JpaContextNode> buildPersistentTypeCvm() {
            return new FilteringCollectionValueModel<JpaContextNode>((CollectionValueModel)new ListCollectionValueModelAdapter((ListValueModel)new TransformationListValueModelAdapter<ClassRef, PersistentType>((ListValueModel)new ItemPropertyListValueModelAdapter(this.buildClassRefCvm(), new String[]{"javaPersistentType"})){

                protected PersistentType transformItem(ClassRef item) {
                    return item.getJavaPersistentType();
                }
            })){

                protected Iterable<JpaContextNode> filter(Iterable<? extends JpaContextNode> items) {
                    return new FilteringIterable<JpaContextNode>(items){

                        protected boolean accept(JpaContextNode o) {
                            return o != null;
                        }
                    };
                }
            };
        }

        protected CollectionValueModel<ClassRef> buildClassRefCvm() {
            ArrayList<CollectionValueModel<ClassRef>> holders = new ArrayList<CollectionValueModel<ClassRef>>(2);
            holders.add(this.buildSpecifiedClassRefCvm());
            holders.add(this.buildImpliedClassRefCvm());
            return new CompositeCollectionValueModel(holders);
        }

        protected CollectionValueModel<ClassRef> buildSpecifiedClassRefCvm() {
            return new ListCollectionValueModelAdapter((ListValueModel)new ListAspectAdapter<PersistenceUnit, ClassRef>("specifiedClassRefs", this.getModel()){

                protected ListIterator<ClassRef> listIterator_() {
                    return ((PersistenceUnit)this.subject).specifiedClassRefs();
                }

                protected int size_() {
                    return ((PersistenceUnit)this.subject).specifiedClassRefsSize();
                }
            });
        }

        protected CollectionValueModel<ClassRef> buildImpliedClassRefCvm() {
            return new CollectionAspectAdapter<PersistenceUnit, ClassRef>("impliedClassRefs", this.getModel()){

                protected Iterator<ClassRef> iterator_() {
                    return ((PersistenceUnit)this.subject).impliedClassRefs();
                }

                protected int size_() {
                    return ((PersistenceUnit)this.subject).impliedClassRefsSize();
                }
            };
        }

        protected CollectionValueModel<JpaContextNode> buildJarFileCvm() {
            return new FilteringCollectionValueModel<JpaContextNode>((CollectionValueModel)new ListCollectionValueModelAdapter((ListValueModel)new TransformationListValueModelAdapter<JarFileRef, JarFile>((ListValueModel)new ItemPropertyListValueModelAdapter(this.buildJarFileRefCvm(), new String[]{"jarFile"})){

                protected JarFile transformItem(JarFileRef item) {
                    return item.getJarFile();
                }
            })){

                protected Iterable<JpaContextNode> filter(Iterable<? extends JpaContextNode> items) {
                    return new FilteringIterable<JpaContextNode>(items){

                        protected boolean accept(JpaContextNode o) {
                            return o != null;
                        }
                    };
                }
            };
        }

        protected CollectionValueModel<JarFileRef> buildJarFileRefCvm() {
            return new ListCollectionValueModelAdapter((ListValueModel)new ListAspectAdapter<PersistenceUnit, JarFileRef>("jarFileRefs", this.getModel()){

                protected ListIterator<JarFileRef> listIterator_() {
                    return ((PersistenceUnit)this.subject).jarFileRefs();
                }

                protected int size_() {
                    return ((PersistenceUnit)this.subject).jarFileRefsSize();
                }
            });
        }
    }
}

