/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.classpath;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.common.project.facet.core.internal.ClasspathUtil;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WtpUserLibraryProviderInstallOperationConfig
extends UserLibraryProviderInstallOperationConfig {
    private static final String CLASS_NAME = WtpUserLibraryProviderInstallOperationConfig.class.getName();
    public static final String PROP_INCLUDE_WITH_APPLICATION_ENABLED = String.valueOf(CLASS_NAME) + ".INCLUDE_WITH_APPLICATION_ENABLED";
    private boolean includeWithApplication = true;

    public boolean isIncludeWithApplicationEnabled() {
        return this.includeWithApplication;
    }

    public void setIncludeWithApplicationEnabled(boolean includeWithApplication) {
        boolean oldValue = this.includeWithApplication;
        this.includeWithApplication = includeWithApplication;
        this.notifyListeners(PROP_INCLUDE_WITH_APPLICATION_ENABLED, oldValue, this.includeWithApplication);
    }

    public synchronized void init(IFacetedProjectBase fproj, IProjectFacetVersion fv, ILibraryProvider provider) {
        IProjectFacet f;
        ILibraryProvider currentProvider;
        super.init(fproj, fv, provider);
        this.includeWithApplication = true;
        IProject project = fproj.getProject();
        if (project != null && (currentProvider = LibraryProviderFramework.getCurrentProvider((IProject)project, (IProjectFacet)(f = fv.getProjectFacet()))) == provider) {
            List entries;
            try {
                entries = ClasspathUtil.getClasspathEntries((IProject)project, (IProjectFacet)f);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            this.includeWithApplication = WtpUserLibraryProviderInstallOperationConfig.getIncludeWithApplicationSetting(entries);
        }
    }

    private static boolean getIncludeWithApplicationSetting(List<IClasspathEntry> entries) {
        for (IClasspathEntry cpe : entries) {
            IPath path;
            if (cpe.getEntryKind() != 5 || (path = cpe.getPath()).segmentCount() < 2 || !path.segment(0).equals("org.eclipse.jdt.USER_LIBRARY")) continue;
            IClasspathAttribute[] iClasspathAttributeArray = cpe.getExtraAttributes();
            int n = iClasspathAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathAttribute attr = iClasspathAttributeArray[n2];
                if (attr.getName().equals("org.eclipse.jst.component.nondependency")) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }
}

