/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.entity;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.wizards.entity.EntityClassWizardPage;
import org.eclipse.jpt.ui.internal.wizards.entity.EntityFieldsWizardPage;
import org.eclipse.jpt.ui.internal.wizards.entity.EntityWizardMsg;
import org.eclipse.jpt.ui.internal.wizards.entity.data.model.EntityDataModelProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEEditorUtility;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;

public class EntityWizard
extends DataModelWizard
implements INewWizard {
    private static final String PAGE_ONE = "pageOne";
    private static final String PAGE_TWO = "pageTwo";

    public EntityWizard(IDataModel model) {
        super(model);
        this.setWindowTitle(EntityWizardMsg.ENTITY_WIZARD_TITLE);
        this.setDefaultPageImageDescriptor(JptUiPlugin.getImageDescriptor("full/wizban/new_entity_wizban"));
    }

    public EntityWizard() {
        this(null);
    }

    protected void doAddPages() {
        EntityClassWizardPage page1 = new EntityClassWizardPage(this.getDataModel(), PAGE_ONE, EntityWizardMsg.ENTITY_WIZARD_PAGE_DESCRIPTION, EntityWizardMsg.ENTITY_WIZARD_PAGE_TITLE, "jst.ejb");
        this.addPage((IWizardPage)page1);
        EntityFieldsWizardPage page2 = new EntityFieldsWizardPage(this.getDataModel(), PAGE_TWO);
        this.addPage((IWizardPage)page2);
    }

    protected IDataModelProvider getDefaultProvider() {
        return new EntityDataModelProvider();
    }

    public boolean canFinish() {
        return this.getDataModel().isValid();
    }

    protected void postPerformFinish() throws InvocationTargetException {
        try {
            String className = this.getDataModel().getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            IProject p = (IProject)this.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
            IJavaProject javaProject = J2EEEditorUtility.getJavaProject((IProject)p);
            IFile file = (IFile)javaProject.findType(className).getResource();
            this.openEditor(file);
        }
        catch (Exception cantOpen) {
            JptUiPlugin.log(cantOpen);
        }
    }

    private void openEditor(final IFile file) {
        if (this.getDataModel().getBooleanProperty("NewJavaClassDataModel.OPEN_IN_EDITOR") && file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        JptUiPlugin.log(e);
                    }
                }
            });
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.getDataModel();
    }
}

