/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context;

import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.ColumnMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinTable;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextNode;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyAttributeOverride;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.ReadOnlyRelationship;
import org.eclipse.jpt.jpa.core.context.ReferenceTable;
import org.eclipse.jpt.jpa.core.context.Relationship;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.jpa2.context.AttributeMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.CollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.jpa.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MappingTools {
    public static String buildJoinTableDefaultName(ReadOnlyRelationship relationship) {
        if (relationship.getJpaProject().getDataSource().connectionProfileIsActive()) {
            return MappingTools.buildDbJoinTableDefaultName(relationship);
        }
        String owningTableName = relationship.getTypeMapping().getPrimaryTableName();
        if (owningTableName == null) {
            return null;
        }
        RelationshipMapping relationshipMapping = relationship.getMapping();
        if (relationshipMapping == null) {
            return null;
        }
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        String targetTableName = targetEntity.getPrimaryTableName();
        if (targetTableName == null) {
            return null;
        }
        return String.valueOf(owningTableName) + '_' + targetTableName;
    }

    private static String buildDbJoinTableDefaultName(ReadOnlyRelationship relationship) {
        Table owningTable = relationship.getTypeMapping().getPrimaryDbTable();
        if (owningTable == null) {
            return null;
        }
        RelationshipMapping relationshipMapping = relationship.getMapping();
        if (relationshipMapping == null) {
            return null;
        }
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        Table targetTable = targetEntity.getPrimaryDbTable();
        if (targetTable == null) {
            return null;
        }
        String name = String.valueOf(owningTable.getName()) + '_' + targetTable.getName();
        return owningTable.getDatabase().convertNameToIdentifier(name);
    }

    public static String buildCollectionTableDefaultName(ElementCollectionMapping2_0 mapping) {
        Entity entity = mapping.getEntity();
        if (entity == null) {
            return null;
        }
        String owningEntityName = entity.getName();
        String attributeName = mapping.getName();
        return String.valueOf(owningEntityName) + '_' + attributeName;
    }

    public static String buildJoinColumnDefaultName(ReadOnlyJoinColumn joinColumn, ReadOnlyJoinColumn.Owner owner) {
        String targetColumnName;
        if (owner.joinColumnsSize() != 1) {
            return null;
        }
        String prefix = owner.getAttributeName();
        if (prefix == null) {
            Entity targetEntity = owner.getRelationshipTarget();
            if (targetEntity == null) {
                return null;
            }
            prefix = targetEntity.getName();
        }
        if ((targetColumnName = joinColumn.getReferencedColumnName()) == null) {
            return null;
        }
        String name = String.valueOf(prefix) + '_' + targetColumnName;
        return name;
    }

    public static String getTargetAttributeName(RelationshipMapping relationshipMapping) {
        if (relationshipMapping == null) {
            return null;
        }
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        for (ReadOnlyPersistentAttribute attribute : CollectionTools.iterable(targetEntity.getPersistentType().allAttributes())) {
            if (!attribute.getMapping().isOwnedBy(relationshipMapping)) continue;
            return attribute.getName();
        }
        return null;
    }

    public static String buildJoinColumnDefaultReferencedColumnName(ReadOnlyJoinColumn.Owner joinColumnOwner) {
        if (joinColumnOwner.joinColumnsSize() != 1) {
            return null;
        }
        Entity targetEntity = joinColumnOwner.getRelationshipTarget();
        if (targetEntity == null) {
            return null;
        }
        return targetEntity.getPrimaryKeyColumnName();
    }

    public static ColumnMapping getColumnMapping(String attributeName, PersistentType persistentType) {
        if (attributeName == null || persistentType == null) {
            return null;
        }
        Iterator<ReadOnlyPersistentAttribute> stream = persistentType.allAttributes();
        while (stream.hasNext()) {
            ReadOnlyPersistentAttribute persAttribute = stream.next();
            if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof ColumnMapping)) continue;
            return (ColumnMapping)persAttribute.getMapping();
        }
        return null;
    }

    public static RelationshipMapping getRelationshipMapping(String attributeName, TypeMapping typeMapping) {
        if (attributeName == null || typeMapping == null) {
            return null;
        }
        Iterator<AttributeMapping> stream = typeMapping.allAttributeMappings();
        while (stream.hasNext()) {
            AttributeMapping attributeMapping = stream.next();
            if (!attributeName.equals(attributeMapping.getName()) || !(attributeMapping instanceof RelationshipMapping)) continue;
            return (RelationshipMapping)attributeMapping;
        }
        return null;
    }

    public static void convertReferenceTableDefaultToSpecifiedJoinColumn(ReferenceTable referenceTable) {
        JoinColumn defaultJoinColumn = referenceTable.getDefaultJoinColumn();
        if (defaultJoinColumn != null) {
            String columnName = defaultJoinColumn.getDefaultName();
            String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
            JoinColumn joinColumn = referenceTable.addSpecifiedJoinColumn();
            joinColumn.setSpecifiedName(columnName);
            joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
        }
    }

    public static void convertJoinTableDefaultToSpecifiedInverseJoinColumn(JoinTable joinTable) {
        JoinColumn defaultInverseJoinColumn = joinTable.getDefaultInverseJoinColumn();
        if (defaultInverseJoinColumn != null) {
            String columnName = defaultInverseJoinColumn.getDefaultName();
            String referencedColumnName = defaultInverseJoinColumn.getDefaultReferencedColumnName();
            JoinColumn joinColumn = joinTable.addSpecifiedInverseJoinColumn(0);
            joinColumn.setSpecifiedName(columnName);
            joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
        }
    }

    public static String getMetamodelFieldMapKeyTypeName(CollectionMapping2_0 mapping) {
        PersistentType targetType = mapping.getResolvedTargetType();
        String mapKey = mapping.getMapKey();
        if (mapKey == null || targetType == null) {
            String mapKeyClass = mapping.getMapKeyClass();
            return mapKeyClass != null ? mapKeyClass : MetamodelField.DEFAULT_TYPE_NAME;
        }
        ReadOnlyPersistentAttribute mapKeyAttribute = targetType.resolveAttribute(mapKey);
        if (mapKeyAttribute == null) {
            return MetamodelField.DEFAULT_TYPE_NAME;
        }
        AttributeMapping2_0 mapKeyMapping = (AttributeMapping2_0)mapKeyAttribute.getMapping();
        if (mapKeyMapping == null) {
            return MetamodelField.DEFAULT_TYPE_NAME;
        }
        return mapKeyMapping.getMetamodelTypeName();
    }

    public static Column resolveOverriddenColumn(TypeMapping overridableTypeMapping, String attributeName) {
        if (overridableTypeMapping == null) {
            return null;
        }
        for (TypeMapping typeMapping : CollectionTools.iterable(overridableTypeMapping.inheritanceHierarchy())) {
            Column column = typeMapping.resolveOverriddenColumn(attributeName);
            if (column == null) continue;
            return column;
        }
        return null;
    }

    public static Relationship resolveOverriddenRelationship(TypeMapping overridableTypeMapping, String attributeName) {
        if (overridableTypeMapping == null) {
            return null;
        }
        for (TypeMapping typeMapping : CollectionTools.iterable(overridableTypeMapping.inheritanceHierarchy())) {
            Relationship relationship = typeMapping.resolveOverriddenRelationship(attributeName);
            if (relationship == null) continue;
            return relationship;
        }
        return null;
    }

    public static <T extends JpaNamedContextNode<? super T>> boolean nodesAreDuplicates(T node1, T node2) {
        return MappingTools.nodesArePotentalDuplicates_(node1, node2) && !node1.overrides(node2) && !node2.overrides(node1);
    }

    private static <T extends JpaNamedContextNode<? super T>> boolean nodesArePotentalDuplicates_(T node1, T node2) {
        return node1 != node2 && StringTools.stringIsNotEmpty((String)node1.getName()) && node1.getName().equals(node2.getName()) && node1.getPersistenceUnit() == node2.getPersistenceUnit();
    }

    public static <T extends JpaNamedContextNode<? super T>> boolean nodeOverrides(T node1, T node2, Iterable<Class<? extends T>> precedenceTypeList) {
        return MappingTools.nodesArePotentalDuplicates_(node1, node2) && MappingTools.calculatePrecedence(node1, precedenceTypeList) < MappingTools.calculatePrecedence(node2, precedenceTypeList);
    }

    private static <T extends JpaNamedContextNode<? super T>> int calculatePrecedence(T node, Iterable<Class<? extends T>> precedenceTypeList) {
        int precedence = 0;
        for (Class<T> nodeClass : precedenceTypeList) {
            if (nodeClass.isInstance(node)) {
                return precedence;
            }
            ++precedence;
        }
        throw new IllegalArgumentException("unknown named node: " + node);
    }

    public static String getPrimaryKeyColumnName(Entity entity) {
        String pkColumnName = null;
        Iterator<ReadOnlyPersistentAttribute> stream = entity.getPersistentType().allAttributes();
        while (stream.hasNext()) {
            ReadOnlyAttributeOverride attributeOverride;
            ReadOnlyPersistentAttribute attribute = stream.next();
            String current = attribute.getPrimaryKeyColumnName();
            if (current != null && (attributeOverride = entity.getAttributeOverrideContainer().getOverrideNamed(attribute.getName())) != null) {
                current = attributeOverride.getColumn().getName();
            }
            if (pkColumnName == null) {
                pkColumnName = current;
                continue;
            }
            if (current == null) continue;
            return null;
        }
        return pkColumnName;
    }

    public static String unqualify(String mappingName, String attributeName) {
        if (mappingName == null) {
            return null;
        }
        if (!attributeName.startsWith(mappingName)) {
            return null;
        }
        int mappingNameLength = mappingName.length();
        if (attributeName.length() <= mappingNameLength) {
            return null;
        }
        return attributeName.charAt(mappingNameLength) == '.' ? attributeName.substring(mappingNameLength + 1) : null;
    }

    private MappingTools() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QualifierTransformer
    implements Transformer<String, String> {
        private final String prefix;

        public QualifierTransformer(String qualifier) {
            this.prefix = qualifier == null ? "." : String.valueOf(qualifier) + '.';
        }

        public String transform(String s) {
            return String.valueOf(this.prefix) + s;
        }
    }
}

