/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.BaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.BaseJoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AbstractNamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJoinColumnValidator<C extends BaseJoinColumn, R extends BaseJoinColumnTextRangeResolver>
extends AbstractNamedColumnValidator<C, R> {
    private final BaseJoinColumn.Owner joinColumnOwner;

    protected BaseJoinColumnValidator(C column, BaseJoinColumn.Owner joinColumnOwner, R textRangeResolver, AbstractNamedColumnValidator.TableDescriptionProvider provider) {
        super(column, textRangeResolver, provider);
        this.joinColumnOwner = joinColumnOwner;
    }

    protected BaseJoinColumnValidator(PersistentAttribute persistentAttribute, C column, BaseJoinColumn.Owner joinColumnOwner, R textRangeResolver, AbstractNamedColumnValidator.TableDescriptionProvider provider) {
        super(persistentAttribute, column, textRangeResolver, provider);
        this.joinColumnOwner = joinColumnOwner;
    }

    @Override
    protected void validateName(List<IMessage> messages) {
        this.validateJoinColumnName(messages);
        this.validateReferencedColumnName(messages);
    }

    protected void validateJoinColumnName(List<IMessage> messages) {
        if (((BaseJoinColumn)this.column).getSpecifiedName() == null && this.joinColumnOwner.joinColumnsSize() > 1) {
            messages.add(this.buildUnspecifiedNameMultipleJoinColumnsMessage());
        } else if (((BaseJoinColumn)this.column).getName() != null) {
            super.validateName(messages);
        }
    }

    protected void validateReferencedColumnName(List<IMessage> messages) {
        if (((BaseJoinColumn)this.column).getSpecifiedReferencedColumnName() == null && this.joinColumnOwner.joinColumnsSize() > 1) {
            messages.add(this.buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage());
        } else if (((BaseJoinColumn)this.column).getSpecifiedReferencedColumnName() != null && ((BaseJoinColumn)this.column).getReferencedColumnDbTable() != null && !((BaseJoinColumn)this.column).referencedColumnIsResolved()) {
            messages.add(this.buildUnresolvedReferencedColumnNameMessage());
        }
    }

    protected IMessage buildUnresolvedReferencedColumnNameMessage() {
        return this.columnParentIsVirtualAttribute() ? this.buildVirtualAttributeUnresolvedReferencedColumnNameMessage() : this.buildUnresolvedReferencedColumnNameMessage(this.getUnresolvedReferencedColumnNameMessage());
    }

    protected abstract String getUnresolvedReferencedColumnNameMessage();

    protected IMessage buildUnresolvedReferencedColumnNameMessage(String message) {
        return DefaultJpaValidationMessages.buildMessage(1, message, new String[]{((BaseJoinColumn)this.column).getReferencedColumnName(), ((BaseJoinColumn)this.column).getReferencedColumnDbTable().getName()}, this.column, ((BaseJoinColumnTextRangeResolver)this.textRangeResolver).getReferencedColumnNameTextRange());
    }

    protected IMessage buildVirtualAttributeUnresolvedReferencedColumnNameMessage() {
        return DefaultJpaValidationMessages.buildMessage(1, this.getVirtualAttributeUnresolvedReferencedColumnNameMessage(), new String[]{this.persistentAttribute.getName(), ((BaseJoinColumn)this.column).getReferencedColumnName(), ((BaseJoinColumn)this.column).getReferencedColumnDbTable().getName()}, this.column, ((BaseJoinColumnTextRangeResolver)this.textRangeResolver).getReferencedColumnNameTextRange());
    }

    protected abstract String getVirtualAttributeUnresolvedReferencedColumnNameMessage();

    protected IMessage buildUnspecifiedNameMultipleJoinColumnsMessage() {
        return this.columnParentIsVirtualAttribute() ? this.buildVirtualAttributeUnspecifiedNameMultipleJoinColumnsMessage() : this.buildUnspecifiedNameMultipleJoinColumnsMessage(this.getUnspecifiedNameMultipleJoinColumnsMessage());
    }

    protected abstract String getUnspecifiedNameMultipleJoinColumnsMessage();

    protected IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(String message) {
        return DefaultJpaValidationMessages.buildMessage(1, message, StringTools.EMPTY_STRING_ARRAY, this.column, ((BaseJoinColumnTextRangeResolver)this.textRangeResolver).getNameTextRange());
    }

    protected IMessage buildVirtualAttributeUnspecifiedNameMultipleJoinColumnsMessage() {
        return DefaultJpaValidationMessages.buildMessage(1, this.getVirtualAttributeUnspecifiedNameMultipleJoinColumnsMessage(), new String[]{this.persistentAttribute.getName()}, this.column, ((BaseJoinColumnTextRangeResolver)this.textRangeResolver).getNameTextRange());
    }

    protected abstract String getVirtualAttributeUnspecifiedNameMultipleJoinColumnsMessage();

    protected IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage() {
        return this.columnParentIsVirtualAttribute() ? this.buildVirtualAttributeUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage() : this.buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(this.getUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage());
    }

    protected abstract String getUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage();

    protected IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(String message) {
        return DefaultJpaValidationMessages.buildMessage(1, message, StringTools.EMPTY_STRING_ARRAY, this.column, ((BaseJoinColumnTextRangeResolver)this.textRangeResolver).getReferencedColumnNameTextRange());
    }

    protected IMessage buildVirtualAttributeUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage() {
        return DefaultJpaValidationMessages.buildMessage(1, this.getVirtualAttributeUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(), new String[]{this.persistentAttribute.getName()}, this.column, ((BaseJoinColumnTextRangeResolver)this.textRangeResolver).getReferencedColumnNameTextRange());
    }

    protected abstract String getVirtualAttributeUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage();
}

