/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.object;

import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.IObjectSelectionLaunchable;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.IObjectSelectionWidget;
import org.eclipse.wst.command.internal.env.core.data.Transformer;

public class ObjectSelectionRegistry {
    private static ObjectSelectionRegistry instance;
    private IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "objectSelectionWidget");
    private Hashtable cachedSelectionWidgets = new Hashtable();

    private ObjectSelectionRegistry() {
    }

    public static ObjectSelectionRegistry getInstance() {
        if (instance == null) {
            instance = new ObjectSelectionRegistry();
        }
        return instance;
    }

    public Transformer getTransformer(String id) {
        TableEntry entry = this.getTableEntry(id);
        Transformer result = null;
        if (entry != null) {
            try {
                Object object = entry.element.createExecutableExtension("transformer");
                if (object instanceof Transformer) {
                    result = (Transformer)object;
                }
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    public boolean getExternalModify(String id) {
        TableEntry entry = this.getTableEntry(id);
        boolean result = false;
        if (entry != null) {
            String modifyString = entry.element.getAttribute("external_modify");
            result = new Boolean(modifyString);
        }
        return result;
    }

    public Object getSelectionWidget(String selectionId) {
        TableEntry entry = this.getTableEntry(selectionId);
        return entry == null ? null : entry.objectSelection;
    }

    public void cleanup() {
        instance = null;
        this.elements = null;
        this.cachedSelectionWidgets = null;
    }

    private TableEntry getTableEntry(String id) {
        if (id == null) {
            return null;
        }
        TableEntry entry = (TableEntry)this.cachedSelectionWidgets.get(id);
        if (entry == null) {
            int index = 0;
            while (index < this.elements.length) {
                IConfigurationElement element = this.elements[index];
                String elemId = element.getAttribute("id");
                if (id.equals(elemId)) {
                    try {
                        Object object = element.createExecutableExtension("class");
                        if (object instanceof IObjectSelectionWidget || object instanceof IObjectSelectionLaunchable) {
                            entry = new TableEntry();
                            entry.element = element;
                            entry.objectSelection = object;
                            this.cachedSelectionWidgets.put(id, entry);
                            break;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++index;
            }
        }
        return entry;
    }

    private class TableEntry {
        public IConfigurationElement element;
        public Object objectSelection;

        private TableEntry() {
        }
    }
}

