/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.cnf;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.actions.NewServerWizardAction;
import org.eclipse.wst.server.ui.internal.view.servers.CopyAction;
import org.eclipse.wst.server.ui.internal.view.servers.GlobalDeleteAction;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleSloshAction;
import org.eclipse.wst.server.ui.internal.view.servers.MonitorServerPortAction;
import org.eclipse.wst.server.ui.internal.view.servers.OpenAction;
import org.eclipse.wst.server.ui.internal.view.servers.PasteAction;
import org.eclipse.wst.server.ui.internal.view.servers.PropertiesAction;
import org.eclipse.wst.server.ui.internal.view.servers.PublishAction;
import org.eclipse.wst.server.ui.internal.view.servers.PublishCleanAction;
import org.eclipse.wst.server.ui.internal.view.servers.RemoveModuleAction;
import org.eclipse.wst.server.ui.internal.view.servers.RenameAction;
import org.eclipse.wst.server.ui.internal.view.servers.RestartModuleAction;
import org.eclipse.wst.server.ui.internal.view.servers.ShowInConsoleAction;
import org.eclipse.wst.server.ui.internal.view.servers.ShowInDebugAction;
import org.eclipse.wst.server.ui.internal.view.servers.StartAction;
import org.eclipse.wst.server.ui.internal.view.servers.StartModuleAction;
import org.eclipse.wst.server.ui.internal.view.servers.StopAction;
import org.eclipse.wst.server.ui.internal.view.servers.StopModuleAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerActionProvider
extends CommonActionProvider {
    public static final String NEW_MENU_ID = "org.eclipse.wst.server.ui.internal.cnf.newMenuId";
    public static final String SHOW_IN_MENU_ID = "org.eclipse.ui.navigate.showInQuickMenu";
    public static final String TOP_SECTION_START_SEPARATOR = "org.eclipse.wst.server.ui.internal.cnf.topSectionStart";
    public static final String TOP_SECTION_END_SEPARATOR = "org.eclipse.wst.server.ui.internal.cnf.topSectionEnd";
    public static final String EDIT_SECTION_START_SEPARATOR = "org.eclipse.wst.server.ui.internal.cnfeditSectionStart";
    public static final String EDIT_SECTION_END_SEPARATOR = "org.eclipse.wst.server.ui.internal.cnf.editSectionEnd";
    public static final String CONTROL_SERVER_SECTION_START_SEPARATOR = "org.eclipse.wst.server.ui.internal.cnf.controlServerSectionStart";
    public static final String CONTROL_SERVER_SECTION_END_SEPARATOR = "org.eclipse.wst.server.ui.internal.cnf.controlServerSectionEnd";
    public static final String SERVER_ETC_SECTION_START_SEPARATOR = "org.eclipse.wst.server.ui.internal.cnf.serverEtcSectionStart";
    public static final String SERVER_ETC_SECTION_END_SEPARATOR = "org.eclipse.wst.server.ui.internal.cnf.serverEtcSectionEnd";
    public static final String CONTROL_MODULE_SECTION_START_SEPARATOR = "org.eclipse.wst.server.ui.internal.cnf.controlModuleSectionStart";
    public static final String CONTROL_MODULE_SECTION_END_SEPARATOR = "org.eclipse.wst.server.ui.internal.cnf.controlModuleSectionEnd";
    private ICommonActionExtensionSite actionSite;
    private Clipboard clipboard;
    protected Action[] actions;
    protected Action actionModifyModules;
    protected Action openAction;
    protected Action showInConsoleAction;
    protected Action showInDebugAction;
    protected Action propertiesAction;
    protected Action monitorPropertiesAction;
    protected Action copyAction;
    protected Action pasteAction;
    protected Action globalDeleteAction;
    protected Action renameAction;
    protected Action noneAction = new Action(Messages.dialogMonitorNone){};

    public void init(ICommonActionExtensionSite aSite) {
        StructuredViewer v;
        super.init(aSite);
        this.actionSite = aSite;
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
            CommonViewer cv = (CommonViewer)v;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            this.addListeners(cv);
            this.makeServerActions(cv, wsSite.getSelectionProvider());
        }
    }

    private void addListeners(CommonViewer tableViewer) {
        tableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                block3: {
                    try {
                        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                        Object data = sel.getFirstElement();
                        if (!(data instanceof IServer)) {
                            return;
                        }
                        IServer server = (IServer)data;
                        ServerUIPlugin.editServer(server);
                    }
                    catch (Exception e) {
                        if (!Trace.SEVERE) break block3;
                        Trace.trace("/severe", "Could not open server", e);
                    }
                }
            }
        });
    }

    private void makeServerActions(CommonViewer tableViewer, ISelectionProvider provider) {
        this.clipboard = new Clipboard(tableViewer.getTree().getDisplay());
        Shell shell = tableViewer.getTree().getShell();
        this.actions = new Action[6];
        this.actions[0] = new StartAction(shell, provider, "debug");
        this.actions[1] = new StartAction(shell, provider, "run");
        this.actions[2] = new StartAction(shell, provider, "profile");
        this.actions[3] = new StopAction(shell, provider);
        this.actions[4] = new PublishAction(shell, provider);
        this.actions[5] = new PublishCleanAction(shell, provider);
        this.openAction = new OpenAction(provider);
        this.pasteAction = new PasteAction(shell, provider, this.clipboard);
        this.copyAction = new CopyAction(provider, this.clipboard, this.pasteAction);
        this.globalDeleteAction = new GlobalDeleteAction(shell, provider);
        this.renameAction = new RenameAction(shell, (TreeViewer)tableViewer, provider);
        this.actionModifyModules = new ModuleSloshAction(shell, provider);
        this.showInConsoleAction = new ShowInConsoleAction(provider);
        this.showInDebugAction = new ShowInDebugAction(provider);
        this.propertiesAction = new PropertiesAction(shell, provider);
        this.monitorPropertiesAction = new PropertiesAction(shell, "org.eclipse.wst.server.ui.properties.monitor", provider);
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("org.eclipse.wst.server.debug", (IAction)this.actions[0]);
        actionBars.setGlobalActionHandler("org.eclipse.wst.server.run", (IAction)this.actions[1]);
        actionBars.setGlobalActionHandler("org.eclipse.wst.server.stop", (IAction)this.actions[3]);
        actionBars.setGlobalActionHandler("org.eclipse.wst.server.publish", (IAction)this.actions[4]);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        actionBars.updateActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.globalDeleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
        IToolBarManager cm = actionBars.getToolBarManager();
        IContributionItem[] cis = cm.getItems();
        ArrayList<IAction> existingActions = new ArrayList<IAction>();
        IContributionItem[] iContributionItemArray = cis;
        int n = cis.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem ci = iContributionItemArray[n2];
            if (ci instanceof ActionContributionItem) {
                ActionContributionItem aci = (ActionContributionItem)ci;
                existingActions.add(aci.getAction());
            }
            ++n2;
        }
        int i = 0;
        while (i < this.actions.length - 1) {
            if (!existingActions.contains(this.actions[i])) {
                cm.add((IAction)this.actions[i]);
            }
            ++i;
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.removeAll();
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        Shell shell = this.actionSite.getViewSite().getShell();
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
        }
        IServer server = null;
        IModule[] module = null;
        ArrayList<IModule> multipleModulesOnOneServer = null;
        if (selection != null && !selection.isEmpty()) {
            multipleModulesOnOneServer = this.getMultipleModulesOnOneServer(selection);
            Iterator iterator = selection.iterator();
            Object obj = iterator.next();
            if (obj instanceof IServer) {
                server = (IServer)obj;
            }
            if (obj instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)obj;
                server = ms.server;
                module = ms.module;
            }
            if (iterator.hasNext()) {
                server = null;
                module = null;
            }
        }
        menu.add((IContributionItem)this.invisibleSeparator(TOP_SECTION_START_SEPARATOR));
        this.addTopSection(menu, server, module);
        menu.add((IContributionItem)this.invisibleSeparator(TOP_SECTION_END_SEPARATOR));
        menu.add((IContributionItem)new Separator());
        if (server != null && module == null) {
            menu.add((IContributionItem)this.invisibleSeparator(EDIT_SECTION_START_SEPARATOR));
            menu.add((IAction)this.copyAction);
            menu.add((IAction)this.pasteAction);
            menu.add((IAction)this.globalDeleteAction);
            menu.add((IAction)this.renameAction);
            menu.add((IContributionItem)this.invisibleSeparator(EDIT_SECTION_END_SEPARATOR));
            menu.add((IContributionItem)new Separator());
            menu.add((IContributionItem)this.invisibleSeparator(CONTROL_SERVER_SECTION_START_SEPARATOR));
            int i = 0;
            while (i < this.actions.length) {
                menu.add((IAction)this.actions[i]);
                ++i;
            }
            menu.add((IContributionItem)this.invisibleSeparator(CONTROL_SERVER_SECTION_END_SEPARATOR));
            menu.add((IContributionItem)new Separator());
            menu.add((IContributionItem)this.invisibleSeparator(SERVER_ETC_SECTION_START_SEPARATOR));
            menu.add((IAction)this.actionModifyModules);
            this.addMonitor(server, menu, shell);
            menu.add((IContributionItem)this.invisibleSeparator(SERVER_ETC_SECTION_END_SEPARATOR));
            menu.add((IContributionItem)new Separator());
        } else if (server != null && module != null) {
            menu.add((IContributionItem)this.invisibleSeparator(CONTROL_MODULE_SECTION_START_SEPARATOR));
            menu.add((IAction)new StartModuleAction(server, module));
            menu.add((IAction)new StopModuleAction(server, module));
            menu.add((IAction)new RestartModuleAction(server, module));
            if (module.length == 1) {
                menu.add((IAction)new RemoveModuleAction(shell, server, module[0]));
            }
            menu.add((IContributionItem)this.invisibleSeparator(CONTROL_MODULE_SECTION_END_SEPARATOR));
        } else if (server == null && module == null && multipleModulesOnOneServer != null) {
            server = selection.getFirstElement() == null ? null : ((ModuleServer)selection.getFirstElement()).getServer();
            menu.add((IContributionItem)this.invisibleSeparator(CONTROL_MODULE_SECTION_START_SEPARATOR));
            menu.add((IAction)new RemoveModuleAction(shell, server, multipleModulesOnOneServer.toArray(new IModule[multipleModulesOnOneServer.size()])));
            menu.add((IContributionItem)this.invisibleSeparator(CONTROL_MODULE_SECTION_END_SEPARATOR));
        }
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
        menu.add((IAction)this.propertiesAction);
    }

    protected ArrayList<IModule> getMultipleModulesOnOneServer(IStructuredSelection selection) {
        return GlobalDeleteAction.getRemovableModuleList(selection);
    }

    protected void addTopSection(IMenuManager menu, IServer server, IModule[] module) {
        MenuManager newMenu = new MenuManager(Messages.actionNew, NEW_MENU_ID);
        NewServerWizardAction newServerAction = new NewServerWizardAction();
        newServerAction.setText(Messages.actionNewServer);
        newMenu.add((IAction)newServerAction);
        menu.add((IContributionItem)newMenu);
        if (server != null && module == null) {
            menu.add((IAction)this.openAction);
            String text = Messages.actionShowIn;
            IWorkbench workbench = PlatformUI.getWorkbench();
            IBindingService bindingService = (IBindingService)workbench.getAdapter(IBindingService.class);
            TriggerSequence[] activeBindings = bindingService.getActiveBindingsFor(SHOW_IN_MENU_ID);
            if (activeBindings.length > 0) {
                text = String.valueOf(text) + "\t" + activeBindings[0].format();
            }
            MenuManager showInMenu = new MenuManager(text, SHOW_IN_MENU_ID);
            showInMenu.add((IAction)this.showInConsoleAction);
            showInMenu.add((IAction)this.showInDebugAction);
            menu.add((IContributionItem)showInMenu);
        }
    }

    protected void addMonitor(IServer server, IMenuManager menu, Shell shell) {
        if (server.getServerType() != null) {
            final MenuManager menuManager = new MenuManager(Messages.actionMonitor);
            final IServer server2 = server;
            final Shell shell2 = shell;
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    ServerPort[] ports;
                    menuManager.removeAll();
                    if (server2.getAdapter(ServerDelegate.class) != null && (ports = server2.getServerPorts(null)) != null) {
                        int size = ports.length;
                        int i = 0;
                        while (i < size) {
                            if (!ports[i].isAdvanced()) {
                                menuManager.add((IAction)new MonitorServerPortAction(shell2, server2, ports[i]));
                            }
                            ++i;
                        }
                    }
                    if (menuManager.isEmpty()) {
                        menuManager.add((IAction)ServerActionProvider.this.noneAction);
                    }
                    menuManager.add((IContributionItem)new Separator());
                    menuManager.add((IAction)ServerActionProvider.this.monitorPropertiesAction);
                }
            });
            this.noneAction.setEnabled(false);
            menuManager.add((IAction)this.noneAction);
            menu.add((IContributionItem)menuManager);
        }
    }

    private Separator invisibleSeparator(String s) {
        Separator sep = new Separator(s);
        sep.setVisible(false);
        return sep;
    }
}

