/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.sse.ui.internal.Logger;

public class CompletionProposalInvocationContext {
    private final ITextViewer fViewer;
    private final int fInvocationOffset;
    private String fPartitionType;

    public CompletionProposalInvocationContext(ITextViewer viewer, int invocationOffset) {
        this.fViewer = viewer;
        this.fInvocationOffset = invocationOffset;
        this.fPartitionType = null;
    }

    public IDocument getDocument() {
        return this.fViewer.getDocument();
    }

    public ITextViewer getViewer() {
        return this.fViewer;
    }

    public int getInvocationOffset() {
        return this.fInvocationOffset;
    }

    public String getInvocationPartitionType() {
        if (this.fPartitionType == null) {
            this.fPartitionType = "";
            try {
                this.fPartitionType = this.getDocument().getPartition(this.fInvocationOffset).getType();
            }
            catch (BadLocationException e) {
                Logger.logException("Could not get the partition type at content assist invocation offset", e);
            }
        }
        return this.fPartitionType;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof CompletionProposalInvocationContext) {
            CompletionProposalInvocationContext other = (CompletionProposalInvocationContext)obj;
            equal = (this.fViewer == null && other.fViewer == null || this.fViewer != null && this.fViewer.equals(other.fViewer)) && this.fInvocationOffset == other.fInvocationOffset;
        }
        return equal;
    }

    public int hashCode() {
        return 0x2CBEB1A0 | (this.fViewer == null ? 0 : this.fViewer.hashCode() << 3) | this.fInvocationOffset;
    }
}

