/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jpt.core.context.java.JavaMappedSuperclass;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaTypeMapping;
import org.eclipse.jpt.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaMappedSuperclass
extends AbstractJavaTypeMapping
implements JavaMappedSuperclass {
    protected String idClass;

    protected AbstractJavaMappedSuperclass(JavaPersistentType parent) {
        super(parent);
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public String getKey() {
        return "mappedSuperclass";
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.MappedSuperclass";
    }

    @Override
    public Iterator<String> correspondingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.IdClass", "javax.persistence.ExcludeDefaultListeners", "javax.persistence.ExcludeSuperclassListeners", "javax.persistence.EntityListeners", "javax.persistence.PrePersist", "javax.persistence.PostPersist", "javax.persistence.PreRemove", "javax.persistence.PostRemove", "javax.persistence.PreUpdate", "javax.persistence.PostUpdate", "javax.persistence.PostLoad"});
    }

    @Override
    public char getIdClassEnclosingTypeSeparator() {
        return '.';
    }

    @Override
    public String getIdClass() {
        return this.idClass;
    }

    @Override
    public void setIdClass(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        if (newIdClass != oldIdClass) {
            if (newIdClass != null) {
                if (this.getResourceIdClass() == null) {
                    this.addResourceIdClass();
                }
                this.getResourceIdClass().setValue(newIdClass);
            } else {
                this.removeResourceIdClass();
            }
        }
        this.firePropertyChanged("idClass", oldIdClass, newIdClass);
    }

    protected void setIdClass_(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        this.firePropertyChanged("idClass", oldIdClass, newIdClass);
    }

    protected IdClassAnnotation getResourceIdClass() {
        return (IdClassAnnotation)this.javaResourcePersistentType.getSupportingAnnotation("javax.persistence.IdClass");
    }

    protected void addResourceIdClass() {
        this.javaResourcePersistentType.addSupportingAnnotation("javax.persistence.IdClass");
    }

    protected void removeResourceIdClass() {
        this.javaResourcePersistentType.removeSupportingAnnotation("javax.persistence.IdClass");
    }

    @Override
    public Iterator<JavaPersistentAttribute> overridableAttributes() {
        return new FilteringIterator<JavaPersistentAttribute, JavaPersistentAttribute>(this.getPersistentType().attributes()){

            protected boolean accept(JavaPersistentAttribute o) {
                return o.isOverridableAttribute();
            }
        };
    }

    @Override
    public Iterator<JavaPersistentAttribute> overridableAssociations() {
        return new FilteringIterator<JavaPersistentAttribute, JavaPersistentAttribute>(this.getPersistentType().attributes()){

            protected boolean accept(JavaPersistentAttribute o) {
                return o.isOverridableAssociation();
            }
        };
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return false;
    }

    @Override
    public boolean shouldValidateAgainstDatabase() {
        return false;
    }

    @Override
    public void initialize(JavaResourcePersistentType persistentTypeResource) {
        super.initialize(persistentTypeResource);
        this.idClass = this.getResourceIdClassName(this.getResourceIdClass());
    }

    @Override
    public void update(JavaResourcePersistentType persistentTypeResource) {
        super.update(persistentTypeResource);
        this.setIdClass_(this.getResourceIdClassName(this.getResourceIdClass()));
    }

    protected String getResourceIdClassName(IdClassAnnotation resourceIdClass) {
        return resourceIdClass == null ? null : resourceIdClass.getValue();
    }
}

