/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaRelationshipMapping;
import org.eclipse.jpt.core.context.java.JavaRelationshipReference;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.context.java.JavaCascade;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.RelationshipMappingAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaRelationshipMapping<T extends RelationshipMappingAnnotation>
extends AbstractJavaAttributeMapping<T>
implements JavaRelationshipMapping {
    protected String specifiedTargetEntity;
    protected String defaultTargetEntity;
    protected Entity resolvedTargetEntity;
    protected final JavaRelationshipReference relationshipReference = this.buildRelationshipReference();
    protected final JavaCascade cascade = new JavaCascade(this);
    protected FetchType specifiedFetch;

    protected AbstractJavaRelationshipMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    protected abstract JavaRelationshipReference buildRelationshipReference();

    @Override
    public JavaPersistentAttribute getParent() {
        return super.getParent();
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.relationshipReference.isRelationshipOwner();
    }

    @Override
    public boolean isOwnedBy(RelationshipMapping mapping) {
        return this.relationshipReference.isOwnedBy(mapping);
    }

    @Override
    public Iterator<String> allTargetEntityAttributeNames() {
        Entity targetEntity = this.getResolvedTargetEntity();
        return targetEntity == null ? EmptyIterator.instance() : targetEntity.getPersistentType().allAttributeNames();
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return this.relationshipReference.javaCompletionProposals(pos, filter, astRoot);
    }

    @Override
    public char getTargetEntityEnclosingTypeSeparator() {
        return '.';
    }

    @Override
    public String getTargetEntity() {
        return this.specifiedTargetEntity != null ? this.specifiedTargetEntity : this.defaultTargetEntity;
    }

    @Override
    public String getSpecifiedTargetEntity() {
        return this.specifiedTargetEntity;
    }

    @Override
    public void setSpecifiedTargetEntity(String targetEntity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = targetEntity;
        ((RelationshipMappingAnnotation)this.mappingAnnotation).setTargetEntity(targetEntity);
        this.firePropertyChanged("specifiedTargetEntity", old, targetEntity);
    }

    protected void setSpecifiedTargetEntity_(String targetEntity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = targetEntity;
        this.firePropertyChanged("specifiedTargetEntity", old, targetEntity);
    }

    @Override
    public String getDefaultTargetEntity() {
        return this.defaultTargetEntity;
    }

    protected void setDefaultTargetEntity(String targetEntity) {
        String old = this.defaultTargetEntity;
        this.defaultTargetEntity = targetEntity;
        this.firePropertyChanged("defaultTargetEntity", old, targetEntity);
    }

    @Override
    public Entity getResolvedTargetEntity() {
        return this.resolvedTargetEntity;
    }

    protected void setResolvedTargetEntity(Entity entity) {
        Entity old = this.resolvedTargetEntity;
        this.resolvedTargetEntity = entity;
        this.firePropertyChanged("resolvedTargetEntity", old, entity);
    }

    @Override
    public JavaRelationshipReference getRelationshipReference() {
        return this.relationshipReference;
    }

    @Override
    public JavaCascade getCascade() {
        return this.cascade;
    }

    @Override
    public FetchType getFetch() {
        return this.specifiedFetch != null ? this.specifiedFetch : this.getDefaultFetch();
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        ((RelationshipMappingAnnotation)this.mappingAnnotation).setFetch(FetchType.toJavaResourceModel(fetch));
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    protected void setSpecifiedFetch_(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.defaultTargetEntity = this.buildDefaultTargetEntity();
        this.relationshipReference.initialize();
        this.specifiedFetch = this.getResourceFetch();
        this.cascade.initialize((RelationshipMappingAnnotation)this.mappingAnnotation);
        this.specifiedTargetEntity = this.getResourceTargetEntity();
        this.resolvedTargetEntity = this.buildResolvedTargetEntity();
    }

    @Override
    protected void update() {
        super.update();
        this.setDefaultTargetEntity(this.buildDefaultTargetEntity());
        this.relationshipReference.update();
        this.setSpecifiedFetch_(this.getResourceFetch());
        this.cascade.update((RelationshipMappingAnnotation)this.mappingAnnotation);
        this.setSpecifiedTargetEntity_(this.getResourceTargetEntity());
        this.setResolvedTargetEntity(this.buildResolvedTargetEntity());
    }

    protected FetchType getResourceFetch() {
        return FetchType.fromJavaResourceModel(((RelationshipMappingAnnotation)this.mappingAnnotation).getFetch());
    }

    protected String getResourceTargetEntity() {
        return ((RelationshipMappingAnnotation)this.mappingAnnotation).getTargetEntity();
    }

    protected abstract String buildDefaultTargetEntity();

    protected Entity buildResolvedTargetEntity() {
        String targetEntityClassName = this.specifiedTargetEntity == null ? this.defaultTargetEntity : ((RelationshipMappingAnnotation)this.mappingAnnotation).getFullyQualifiedTargetEntityClassName();
        return targetEntityClassName == null ? null : this.getPersistenceUnit().getEntity(targetEntityClassName);
    }

    @Override
    public Entity getEntity() {
        TypeMapping typeMapping = this.getTypeMapping();
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    @Override
    public String getJoinTableDefaultName() {
        return MappingTools.buildJoinTableDefaultName(this);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateTargetEntity(messages, astRoot);
        this.relationshipReference.validate(messages, reporter, astRoot);
    }

    protected void validateTargetEntity(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getTargetEntity() == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_ENTITY_NOT_DEFINED", new String[]{this.getName()}, this, this.getValidationTextRange(astRoot)));
        } else if (this.getResolvedTargetEntity() == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_ENTITY_IS_NOT_AN_ENTITY", new String[]{this.getTargetEntity(), this.getName()}, this, this.getTargetEntityTextRange(astRoot)));
        }
    }

    protected TextRange getTextRange(TextRange textRange, CompilationUnit astRoot) {
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    protected TextRange getTargetEntityTextRange(CompilationUnit astRoot) {
        return this.getTextRange(((RelationshipMappingAnnotation)this.mappingAnnotation).getTargetEntityTextRange(astRoot), astRoot);
    }
}

