/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.binary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryPersistentMember;
import org.eclipse.jpt.core.internal.utility.jdt.JPTTools;
import org.eclipse.jpt.core.resource.java.AccessAnnotation;
import org.eclipse.jpt.core.resource.java.AccessType;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.utility.MethodSignature;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.NameTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BinaryPersistentAttribute
extends BinaryPersistentMember
implements JavaResourcePersistentAttribute {
    private int modifiers;
    private String typeName;
    private boolean typeIsInterface;
    private boolean typeIsEnum;
    private final Vector<String> typeSuperclassNames = new Vector();
    private final Vector<String> typeInterfaceNames = new Vector();
    private final Vector<String> typeTypeArgumentNames = new Vector();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    BinaryPersistentAttribute(JavaResourcePersistentType parent, IField field) {
        this(parent, new FieldAdapter(field));
    }

    BinaryPersistentAttribute(JavaResourcePersistentType parent, IMethod method) {
        this(parent, new MethodAdapter(method));
    }

    private BinaryPersistentAttribute(JavaResourcePersistentType parent, Adapter adapter) {
        super(parent, adapter);
        this.modifiers = this.buildModifiers();
        this.typeName = this.buildTypeName();
        IType type = this.getType();
        this.typeIsInterface = this.buildTypeIsInterface(type);
        this.typeIsEnum = this.buildTypeIsEnum(type);
        this.typeSuperclassNames.addAll(this.buildTypeSuperclassNames(type));
        this.typeInterfaceNames.addAll(this.buildTypeInterfaceNames(type));
        this.typeTypeArgumentNames.addAll(this.buildTypeTypeArgumentNames());
    }

    @Override
    public void update() {
        super.update();
        this.setModifiers(this.buildModifiers());
        this.setTypeName(this.buildTypeName());
        IType type = this.getType();
        this.setTypeIsInterface(this.buildTypeIsInterface(type));
        this.setTypeIsEnum(this.buildTypeIsEnum(type));
        this.setTypeSuperclassNames(this.buildTypeSuperclassNames(type));
        this.setTypeInterfaceNames(this.buildTypeInterfaceNames(type));
        this.setTypeTypeArgumentNames(this.buildTypeTypeArgumentNames());
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    private Adapter getAdapter() {
        return (Adapter)this.adapter;
    }

    @Override
    Annotation buildMappingAnnotation(IAnnotation jdtAnnotation) {
        return this.getAnnotationProvider().buildAttributeMappingAnnotation(this, jdtAnnotation);
    }

    @Override
    Annotation buildSupportingAnnotation(IAnnotation jdtAnnotation) {
        return this.getAnnotationProvider().buildAttributeSupportingAnnotation(this, jdtAnnotation);
    }

    @Override
    Annotation buildNullSupportingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullAttributeSupportingAnnotation(this, annotationName);
    }

    @Override
    public Annotation getNullMappingAnnotation(String annotationName) {
        return annotationName == null ? null : this.buildNullMappingAnnotation(annotationName);
    }

    private Annotation buildNullMappingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullAttributeMappingAnnotation(this, annotationName);
    }

    @Override
    ListIterator<String> validMappingAnnotationNames() {
        return this.getAnnotationProvider().attributeMappingAnnotationNames();
    }

    @Override
    ListIterator<String> validSupportingAnnotationNames() {
        return this.getAnnotationProvider().attributeSupportingAnnotationNames();
    }

    @Override
    public String getName() {
        return this.getAdapter().getAttributeName();
    }

    @Override
    public boolean isField() {
        return this.getAdapter().isField();
    }

    @Override
    public boolean isProperty() {
        return !this.isField();
    }

    @Override
    public boolean isFor(MethodSignature methodSignature, int occurrence) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasAnyPersistenceAnnotations() {
        return this.mappingAnnotationsSize() > 0 || this.supportingAnnotationsSize() > 0;
    }

    @Override
    public AccessType getSpecifiedAccess() {
        AccessAnnotation accessAnnotation = (AccessAnnotation)this.getSupportingAnnotation("javax.persistence.Access");
        return accessAnnotation == null ? null : accessAnnotation.getValue();
    }

    @Override
    public boolean typeIsSubTypeOf(String tn) {
        return this.typeName != null && this.typeName.equals(tn) || this.typeInterfaceNames.contains(tn) || this.typeSuperclassNames.contains(tn);
    }

    @Override
    public boolean typeIsVariablePrimitive() {
        return this.typeName != null && ClassTools.classNamedIsVariablePrimitive((String)this.typeName);
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    private void setModifiers(int modifiers) {
        int old = this.modifiers;
        this.modifiers = modifiers;
        this.firePropertyChanged("modifiers", old, modifiers);
    }

    private int buildModifiers() {
        try {
            return this.getMember().getFlags();
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return 0;
        }
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    private void setTypeName(String typeName) {
        String old = this.typeName;
        this.typeName = typeName;
        this.firePropertyChanged("typeName", old, typeName);
    }

    private String buildTypeName() {
        return BinaryPersistentAttribute.convertTypeSignatureToTypeName(this.getTypeSignature());
    }

    @Override
    public boolean typeIsInterface() {
        return this.typeIsInterface;
    }

    private void setTypeIsInterface(boolean typeIsInterface) {
        boolean old = this.typeIsInterface;
        this.typeIsInterface = typeIsInterface;
        this.firePropertyChanged("typeIsInterface", old, typeIsInterface);
    }

    private boolean buildTypeIsInterface(IType type) {
        try {
            return type != null && type.isInterface();
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean typeIsEnum() {
        return this.typeIsEnum;
    }

    private void setTypeIsEnum(boolean typeIsEnum) {
        boolean old = this.typeIsEnum;
        this.typeIsEnum = typeIsEnum;
        this.firePropertyChanged("typeIsEnum", old, typeIsEnum);
    }

    private boolean buildTypeIsEnum(IType type) {
        try {
            return type != null && type.isEnum();
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public ListIterator<String> typeSuperclassNames() {
        return new CloneListIterator(this.typeSuperclassNames);
    }

    public boolean typeSuperclassNamesContains(String superclassName) {
        return this.typeSuperclassNames.contains(superclassName);
    }

    private void setTypeSuperclassNames(List<String> typeSuperclassNames) {
        this.synchronizeList(typeSuperclassNames, this.typeSuperclassNames, "typeSuperclassNames");
    }

    private List<String> buildTypeSuperclassNames(IType type) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        type = this.findSuperclass(type);
        while (type != null) {
            names.add(type.getFullyQualifiedName());
            type = this.findSuperclass(type);
        }
        return names;
    }

    @Override
    public Iterator<String> typeInterfaceNames() {
        return new CloneIterator(this.typeInterfaceNames);
    }

    public boolean typeInterfaceNamesContains(String interfaceName) {
        return this.typeInterfaceNames.contains(interfaceName);
    }

    private void setTypeInterfaceNames(Collection<String> typeInterfaceNames) {
        this.synchronizeCollection(typeInterfaceNames, this.typeInterfaceNames, "typeInterfaceNames");
    }

    private Collection<String> buildTypeInterfaceNames(IType type) {
        if (type == null) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        while (type != null) {
            this.addInterfaceNamesTo(type, names);
            type = this.findSuperclass(type);
        }
        return names;
    }

    private void addInterfaceNamesTo(IType type, HashSet<String> names) {
        String[] stringArray = this.getSuperInterfaceTypeSignatures(type);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceSignature = stringArray[n2];
            String interfaceName = BinaryPersistentAttribute.convertTypeSignatureToTypeName(interfaceSignature);
            names.add(interfaceName);
            IType interfaceType = this.findType(interfaceName);
            if (interfaceType != null) {
                this.addInterfaceNamesTo(interfaceType, names);
            }
            ++n2;
        }
    }

    @Override
    public ListIterator<String> typeTypeArgumentNames() {
        return new CloneListIterator(this.typeTypeArgumentNames);
    }

    @Override
    public int typeTypeArgumentNamesSize() {
        return this.typeTypeArgumentNames.size();
    }

    @Override
    public String getTypeTypeArgumentName(int index) {
        return this.typeTypeArgumentNames.get(index);
    }

    private void setTypeTypeArgumentNames(List<String> typeTypeArgumentNames) {
        this.synchronizeList(typeTypeArgumentNames, this.typeTypeArgumentNames, "typeTypeArgumentNames");
    }

    private List<String> buildTypeTypeArgumentNames() {
        String typeSignature = this.getTypeSignature();
        if (typeSignature == null) {
            return Collections.emptyList();
        }
        String[] typeArgumentSignatures = Signature.getTypeArguments((String)typeSignature);
        if (typeArgumentSignatures.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(typeArgumentSignatures.length);
        String[] stringArray = typeArgumentSignatures;
        int n = typeArgumentSignatures.length;
        int n2 = 0;
        while (n2 < n) {
            String typeArgumentSignature = stringArray[n2];
            names.add(BinaryPersistentAttribute.convertTypeSignatureToTypeName(typeArgumentSignature));
            ++n2;
        }
        return names;
    }

    private String getTypeSignature() {
        try {
            return this.getAdapter().getTypeSignature();
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return null;
        }
    }

    private IType findSuperclass(IType type) {
        return this.findTypeBySignature(this.getSuperclassSignature(type));
    }

    private String getSuperclassSignature(IType type) {
        try {
            return type.getSuperclassTypeSignature();
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return null;
        }
    }

    private String[] getSuperInterfaceTypeSignatures(IType type) {
        try {
            return type.getSuperInterfaceTypeSignatures();
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return EMPTY_STRING_ARRAY;
        }
    }

    private IType findTypeBySignature(String typeSignature) {
        return typeSignature == null ? null : this.findType(BinaryPersistentAttribute.convertTypeSignatureToTypeName_(typeSignature));
    }

    private IType getType() {
        return this.typeName == null ? null : this.findType(this.typeName);
    }

    private IType findType(String fullyQualifiedName) {
        try {
            return this.getJavaProject().findType(fullyQualifiedName);
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return null;
        }
    }

    private IJavaProject getJavaProject() {
        return this.getMember().getJavaProject();
    }

    static interface Adapter
    extends BinaryPersistentMember.Adapter {
        public String getAttributeName();

        public boolean isField();

        public String getTypeSignature() throws JavaModelException;
    }

    static class FieldAdapter
    implements Adapter {
        final IField field;

        FieldAdapter(IField field) {
            this.field = field;
        }

        public IField getMember() {
            return this.field;
        }

        public boolean isPersistable() {
            return this.field.exists() && JPTTools.fieldIsPersistable(new JPTToolsAdapter());
        }

        public IAnnotation[] getAnnotations() throws JavaModelException {
            return this.field.getAnnotations();
        }

        public String getAttributeName() {
            return this.field.getElementName();
        }

        public boolean isField() {
            return true;
        }

        public String getTypeSignature() throws JavaModelException {
            return this.field.getTypeSignature();
        }

        class JPTToolsAdapter
        implements JPTTools.FieldAdapter {
            JPTToolsAdapter() {
            }

            public int getModifiers() {
                try {
                    return FieldAdapter.this.field.getFlags();
                }
                catch (JavaModelException ex) {
                    JptCorePlugin.log(ex);
                    return 0;
                }
            }
        }
    }

    static class MethodAdapter
    implements Adapter {
        final IMethod method;
        static final IMethod[] EMPTY_METHOD_ARRAY = new IMethod[0];

        MethodAdapter(IMethod method) {
            this.method = method;
        }

        public IMethod getMember() {
            return this.method;
        }

        public boolean isPersistable() {
            return JPTTools.methodIsPersistablePropertyGetter(new JPTToolsAdapter());
        }

        public IAnnotation[] getAnnotations() throws JavaModelException {
            return this.method.getAnnotations();
        }

        public String getAttributeName() {
            return NameTools.convertGetterMethodNameToPropertyName((String)this.method.getElementName());
        }

        public boolean isField() {
            return false;
        }

        public String getTypeSignature() throws JavaModelException {
            return this.method.getReturnType();
        }

        static abstract class AbstractJPTToolsAdapter
        implements JPTTools.SimpleMethodAdapter {
            AbstractJPTToolsAdapter() {
            }

            abstract IMethod getMethod();

            public int getModifiers() {
                try {
                    return this.getMethod().getFlags();
                }
                catch (JavaModelException ex) {
                    JptCorePlugin.log(ex);
                    return 0;
                }
            }

            public String getReturnTypeErasureName() {
                return BinaryPersistentAttribute.convertTypeSignatureToTypeName(this.getReturnTypeSignature());
            }

            private String getReturnTypeSignature() {
                try {
                    return this.getMethod().getReturnType();
                }
                catch (JavaModelException ex) {
                    JptCorePlugin.log(ex);
                    return null;
                }
            }

            public boolean isConstructor() {
                try {
                    return this.getMethod().isConstructor();
                }
                catch (JavaModelException ex) {
                    JptCorePlugin.log(ex);
                    return false;
                }
            }
        }

        class JPTToolsAdapter
        extends AbstractJPTToolsAdapter
        implements JPTTools.MethodAdapter {
            JPTToolsAdapter() {
            }

            IMethod getMethod() {
                return MethodAdapter.this.method;
            }

            public String getName() {
                return this.getMethod().getElementName();
            }

            public int getParametersLength() {
                return this.getMethod().getParameterTypes().length;
            }

            public JPTTools.SimpleMethodAdapter getSibling(String name) {
                IMethod[] iMethodArray = this.getSiblings();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod sibling = iMethodArray[n2];
                    if (sibling.getParameterTypes().length == 0 && sibling.getElementName().equals(name)) {
                        return new SimpleJPTToolsAdapter(sibling);
                    }
                    ++n2;
                }
                return null;
            }

            public JPTTools.SimpleMethodAdapter getSibling(String name, String parameterTypeErasureName) {
                IMethod[] iMethodArray = this.getSiblings();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod sibling = iMethodArray[n2];
                    String[] parmTypes = sibling.getParameterTypes();
                    if (parmTypes.length == 1 && sibling.getElementName().equals(name) && BinaryPersistentAttribute.convertTypeSignatureToTypeName(parmTypes[0]).equals(parameterTypeErasureName)) {
                        return new SimpleJPTToolsAdapter(sibling);
                    }
                    ++n2;
                }
                return null;
            }

            private IMethod[] getSiblings() {
                try {
                    return this.getMethod().getDeclaringType().getMethods();
                }
                catch (JavaModelException ex) {
                    JptCorePlugin.log(ex);
                    return EMPTY_METHOD_ARRAY;
                }
            }
        }

        static class SimpleJPTToolsAdapter
        extends AbstractJPTToolsAdapter {
            private final IMethod method;

            SimpleJPTToolsAdapter(IMethod method) {
                this.method = method;
            }

            IMethod getMethod() {
                return this.method;
            }
        }
    }
}

