/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal.vendor;

import java.util.ArrayList;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.jpt.db.internal.vendor.AbstractVendor;
import org.eclipse.jpt.db.internal.vendor.CatalogStrategy;
import org.eclipse.jpt.db.internal.vendor.FoldingStrategy;
import org.eclipse.jpt.db.internal.vendor.LowerCaseFoldingStrategy;
import org.eclipse.jpt.db.internal.vendor.SimpleCatalogStrategy;
import org.eclipse.jpt.db.internal.vendor.Vendor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PostgreSQL
extends AbstractVendor {
    private static final Vendor INSTANCE = new PostgreSQL();
    private static final String PUBLIC_SCHEMA_NAME = "public";
    private static final char[] EXTENDED_NORMAL_NAME_START_CHARACTERS = new char[]{'_'};
    private static final char[] EXTENDED_NORMAL_NAME_PART_CHARACTERS = new char[]{'$'};

    static Vendor instance() {
        return INSTANCE;
    }

    private PostgreSQL() {
    }

    @Override
    public String getDTPVendorName() {
        return "postgres";
    }

    @Override
    CatalogStrategy getCatalogStrategy() {
        return SimpleCatalogStrategy.instance();
    }

    @Override
    FoldingStrategy getFoldingStrategy() {
        return LowerCaseFoldingStrategy.instance();
    }

    @Override
    void addDefaultCatalogIdentifiersTo(Database database, String userName, ArrayList<String> identifiers) {
        identifiers.add(((Catalog)database.getCatalogs().get(0)).getName());
    }

    @Override
    void addDefaultSchemaIdentifiersTo(Database database, String userName, ArrayList<String> identifiers) {
        super.addDefaultSchemaIdentifiersTo(database, userName, identifiers);
        identifiers.add(PUBLIC_SCHEMA_NAME);
    }

    @Override
    char[] getExtendedNormalNameStartCharacters() {
        return EXTENDED_NORMAL_NAME_START_CHARACTERS;
    }

    @Override
    char[] getExtendedNormalNamePartCharacters() {
        return EXTENDED_NORMAL_NAME_PART_CHARACTERS;
    }
}

