/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.OneToManyAnnotation;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkOneToManyMapping;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.eclipselink.core.context.JoinFetch;
import org.eclipse.jpt.eclipselink.core.context.PrivateOwned;
import org.eclipse.jpt.eclipselink.core.resource.java.JoinFetchAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.JoinFetchType;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaOneToManyMappingTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithPrivateOwnedOneToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "org.eclipse.persistence.annotations.PrivateOwned"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
                sb.append("@PrivateOwned").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithJoinFetchOneToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "org.eclipse.persistence.annotations.JoinFetch"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
                sb.append("@JoinFetch").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithDefaultOneToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("implements java.io.Serializable");
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("private java.util.Collection<AnnotationTestType> myTypes;").append(CR);
                sb.append(CR);
            }
        });
    }

    public EclipseLinkJavaOneToManyMappingTests(String name) {
        super(name);
    }

    public void testGetPrivateOwned() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getSpecifiedMapping();
        PrivateOwned privateOwnable = oneToManyMapping.getPrivateOwned();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testSetPrivateOwned() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getSpecifiedMapping();
        PrivateOwned privateOwnable = oneToManyMapping.getPrivateOwned();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
        privateOwnable.setPrivateOwned(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.PrivateOwned"));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)privateOwnable.isPrivateOwned());
        privateOwnable.setPrivateOwned(true);
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.PrivateOwned"));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testPrivateOwnedUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getSpecifiedMapping();
        PrivateOwned privateOwnable = oneToManyMapping.getPrivateOwned();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.PrivateOwned");
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)false, (boolean)privateOwnable.isPrivateOwned());
        attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.PrivateOwned");
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testGetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getSpecifiedMapping();
        JoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinFetchAnnotation joinFetchAnnotation = (JoinFetchAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(JoinFetchType.INNER);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(JoinFetchType.OUTER);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(null);
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)contextJoinFetch.getValue());
    }

    public void testSetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getSpecifiedMapping();
        JoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinFetchAnnotation joinFetchAnnotation = (JoinFetchAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER);
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(org.eclipse.jpt.eclipselink.core.context.JoinFetchType.OUTER);
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(null);
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch"));
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER);
        joinFetchAnnotation = (JoinFetchAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
    }

    public void testDefaultOneToMany() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"basic", (String)((JavaPersistentAttribute)attributes.next()).getDefaultMappingKey());
    }

    public void testDefaultOneToManySetFetch() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.LAZY);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)specifiedOneToManyMapping.getFetch());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToManyAnnotation));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)((OneToManyAnnotation)attributeResource.getMappingAnnotation()).getFetch());
    }

    public void testDefaultOneToManySetTargetEntity() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.setSpecifiedTargetEntity("Foo");
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)specifiedOneToManyMapping.getSpecifiedTargetEntity());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToManyAnnotation));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)((OneToManyAnnotation)attributeResource.getMappingAnnotation()).getTargetEntity());
    }

    public void testDefaultOneToManySetMappedBy() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("Foo");
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)specifiedOneToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToManyAnnotation));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"Foo", (String)((OneToManyAnnotation)attributeResource.getMappingAnnotation()).getMappedBy());
    }

    public void testDefaultOneToManySetCascadeAll() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setAll(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isAll());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToManyAnnotation));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)((OneToManyAnnotation)attributeResource.getMappingAnnotation()).isCascadeAll());
    }

    public void testDefaultOneToManySetCascadeMerge() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setMerge(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isMerge());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToManyAnnotation));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)((OneToManyAnnotation)attributeResource.getMappingAnnotation()).isCascadeMerge());
    }

    public void testDefaultOneToManySetCascadePersist() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setPersist(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isPersist());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToManyAnnotation));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)((OneToManyAnnotation)attributeResource.getMappingAnnotation()).isCascadePersist());
    }

    public void testDefaultOneToManySetCascadeRefresh() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setRefresh(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isRefresh());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToManyAnnotation));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)((OneToManyAnnotation)attributeResource.getMappingAnnotation()).isCascadeRefresh());
    }

    public void testDefaultOneToManySetCascadeRemove() throws Exception {
        this.createTestEntityWithDefaultOneToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToManyMappingTests.assertEquals((String)"oneToMany", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToManyMapping oneToManyMapping = (EclipseLinkOneToManyMapping)persistentAttribute.getMapping();
        oneToManyMapping.getCascade().setRemove(true);
        EclipseLinkOneToManyMapping specifiedOneToManyMapping = (EclipseLinkOneToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToManyMapping.getCascade().isRemove());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToManyMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToManyAnnotation));
        EclipseLinkJavaOneToManyMappingTests.assertEquals((boolean)true, (boolean)((OneToManyAnnotation)attributeResource.getMappingAnnotation()).isCascadeRemove());
    }
}

