/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmManyToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.eclipselink.core.context.JoinFetchType;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmManyToManyMapping;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmOneToManyMapping;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlJoinFetchType;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlManyToMany;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;

public class EclipseLinkOrmManyToManyMappingTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkOrmManyToManyMappingTests(String name) {
        super(name);
    }

    private void createTestDepartment() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("import java.util.Collection;");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.ManyToMany").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.JoinTable").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.JoinColumn").append(";");
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Department").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    @JoinTable(name=\"DEP_EMP\", joinColumns=@JoinColumn(name=\"DEPT_ID\"), inverseJoinColumns=@JoinColumn(name=\"EMP_ID\"))").append(CR);
                sb.append("    private Collection<Employee> employees;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Department.java", sourceWriter);
    }

    private void createTestEmployee() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Employee").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int empId;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Employee.java", sourceWriter);
    }

    public void testUpdateJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToMany");
        EclipseLinkRelationshipMapping contextManyToMany = (EclipseLinkRelationshipMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlManyToMany resourceManyToMany = (XmlManyToMany)resourceEntity.getAttributes().getManyToManys().get(0);
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)contextManyToMany.getJoinFetch().getValue());
        resourceManyToMany.setJoinFetch(XmlJoinFetchType.INNER);
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextManyToMany.getJoinFetch().getValue());
        resourceManyToMany.setJoinFetch(XmlJoinFetchType.OUTER);
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)contextManyToMany.getJoinFetch().getValue());
        resourceManyToMany.setJoinFetch(null);
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)contextManyToMany.getJoinFetch().getValue());
    }

    public void testModifyJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToMany", "manyToMany");
        EclipseLinkRelationshipMapping contextManyToMany = (EclipseLinkRelationshipMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlManyToMany resourceManyToMany = (XmlManyToMany)resourceEntity.getAttributes().getManyToManys().get(0);
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)contextManyToMany.getJoinFetch().getValue());
        contextManyToMany.getJoinFetch().setValue(JoinFetchType.INNER);
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextManyToMany.getJoinFetch().getValue());
        contextManyToMany.getJoinFetch().setValue(JoinFetchType.OUTER);
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)contextManyToMany.getJoinFetch().getValue());
        contextManyToMany.getJoinFetch().setValue(null);
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)resourceManyToMany.getJoinFetch());
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)contextManyToMany.getJoinFetch().getValue());
    }

    public void testJoinFetchDefault() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.getEntityMappings().addPersistentType("entity", "test.Department");
        this.getEntityMappings().addPersistentType("entity", "test.Employee");
        OrmPersistentType departmentPersistentType = (OrmPersistentType)this.getEntityMappings().persistentTypes().next();
        EclipseLinkOrmManyToManyMapping manyToMany = (EclipseLinkOrmManyToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)manyToMany.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        EclipseLinkOrmOneToManyMapping oneToMany = (EclipseLinkOrmOneToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)oneToMany.getJoinFetch().getValue());
        EclipseLinkRelationshipMapping javaRelationshipMapping = (EclipseLinkRelationshipMapping)departmentPersistentType.getJavaPersistentType().getAttributeNamed("employees").getMapping();
        javaRelationshipMapping.getJoinFetch().setValue(JoinFetchType.OUTER);
        EclipseLinkOrmManyToManyMappingTests.assertNull((Object)oneToMany.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        manyToMany = (EclipseLinkOrmManyToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)manyToMany.getJoinFetch().getValue());
    }

    public void testDefaultJoinTable() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.getEntityMappings().addPersistentType("entity", "test.Department");
        this.getEntityMappings().addPersistentType("entity", "test.Employee");
        OrmPersistentType departmentPersistentType = (OrmPersistentType)this.getEntityMappings().persistentTypes().next();
        OrmManyToManyMapping manyToMany = (OrmManyToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)manyToMany.getPersistentAttribute().isVirtual());
        OrmJoinTable ormJoinTable = manyToMany.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"DEP_EMP", (String)ormJoinTable.getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"DEPT_ID", (String)((OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next()).getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"id", (String)((OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next()).getReferencedColumnName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"EMP_ID", (String)((OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"empId", (String)((OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getReferencedColumnName());
        departmentPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        departmentPersistentType.addSpecifiedPersistentAttribute("id", "id");
        OrmOneToManyMapping oneToMany = (OrmOneToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)oneToMany.getPersistentAttribute().isVirtual());
        ormJoinTable = oneToMany.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"Department_Employee", (String)ormJoinTable.getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"Department_id", (String)((OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next()).getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"id", (String)((OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next()).getReferencedColumnName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"employees_empId", (String)((OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"empId", (String)((OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getReferencedColumnName());
        departmentPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.FALSE);
        manyToMany = (OrmManyToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)manyToMany.getPersistentAttribute().isVirtual());
        ormJoinTable = manyToMany.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"DEP_EMP", (String)ormJoinTable.getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"DEPT_ID", (String)((OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next()).getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"id", (String)((OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next()).getReferencedColumnName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"EMP_ID", (String)((OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"empId", (String)((OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getReferencedColumnName());
        departmentPersistentType.addSpecifiedPersistentAttribute("manyToMany", "employees");
        manyToMany = (OrmManyToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)manyToMany.getPersistentAttribute().isVirtual());
        ormJoinTable = manyToMany.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"Department_Employee", (String)ormJoinTable.getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((int)0, (int)ormJoinTable.specifiedJoinColumnsSize());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"Department_id", (String)ormJoinTable.getDefaultJoinColumn().getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"id", (String)ormJoinTable.getDefaultJoinColumn().getReferencedColumnName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((int)0, (int)ormJoinTable.specifiedInverseJoinColumnsSize());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"employees_empId", (String)ormJoinTable.getDefaultInverseJoinColumn().getName());
        EclipseLinkOrmManyToManyMappingTests.assertEquals((String)"empId", (String)ormJoinTable.getDefaultInverseJoinColumn().getReferencedColumnName());
    }
}

