/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.schema.generation;

import java.util.ListIterator;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation.DdlGenerationType;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation.OutputMode;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation.SchemaGeneration;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.PersistenceUnitTestCase;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerationBasicAdapterTests
extends PersistenceUnitTestCase {
    private SchemaGeneration schemaGeneration;
    public static final String outputModeKey = "eclipselink.ddl-generation.output-mode";
    public static final String ddlGenTypeKey = "eclipselink.ddl-generation";
    public static final OutputMode OUTPUT_MODE_TEST_VALUE = OutputMode.sql_script;
    public static final OutputMode OUTPUT_MODE_TEST_VALUE_2 = OutputMode.database;
    public static final DdlGenerationType DDL_GENERATION_TYPE_TEST_VALUE = DdlGenerationType.drop_and_create_tables;
    public static final DdlGenerationType DDL_GENERATION_TYPE_TEST_VALUE_2 = DdlGenerationType.none;

    public SchemaGenerationBasicAdapterTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.schemaGeneration = this.subject.getSchemaGeneration();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.schemaGeneration.addPropertyChangeListener("outputMode", propertyChangeListener);
        this.schemaGeneration.addPropertyChangeListener("ddlGenerationType", propertyChangeListener);
        this.clearEvent();
    }

    @Override
    protected void populatePu() {
        this.propertiesTotal = 6;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal = 2;
        this.persistenceUnitSetProperty("property.0", "value.0");
        this.persistenceUnitSetProperty(outputModeKey, this.getEclipseLinkStringValueOf(OUTPUT_MODE_TEST_VALUE));
        this.persistenceUnitSetProperty("property.2", "value.2");
        this.persistenceUnitSetProperty("property.3", "value.3");
        this.persistenceUnitSetProperty("property.4", "value.4");
        this.persistenceUnitSetProperty(ddlGenTypeKey, this.getEclipseLinkStringValueOf(DDL_GENERATION_TYPE_TEST_VALUE));
    }

    public void testOutputModeUpdate() throws Exception {
        ListValueModel<PersistenceUnit.Property> propertiesAdapter = this.buildPropertiesAdapter((PropertyValueModel<EclipseLinkPersistenceUnit>)this.subjectHolder);
        new ItemPropertyListValueModelAdapter(propertiesAdapter, new String[]{"value"});
        this.verifyHasListeners((PersistenceUnitProperties)this.schemaGeneration, "outputMode");
        SchemaGenerationBasicAdapterTests.assertTrue((boolean)this.schemaGeneration.itemIsProperty(this.getPersistenceUnit().getProperty(outputModeKey)));
        SchemaGenerationBasicAdapterTests.assertEquals((Object)OUTPUT_MODE_TEST_VALUE, (Object)this.schemaGeneration.getOutputMode());
        this.persistenceUnitSetProperty(outputModeKey, OUTPUT_MODE_TEST_VALUE_2);
        this.verifyPutEvent("outputMode", OUTPUT_MODE_TEST_VALUE_2, this.schemaGeneration.getOutputMode());
        this.clearEvent();
        --this.propertiesTotal;
        --this.modelPropertiesSize;
        this.getPersistenceUnit().removeProperty(outputModeKey);
        SchemaGenerationBasicAdapterTests.assertNull((Object)this.getPersistenceUnit().getProperty(outputModeKey));
        SchemaGenerationBasicAdapterTests.assertEquals((int)this.modelPropertiesSize, (int)(this.modelPropertiesSizeOriginal - 1));
        SchemaGenerationBasicAdapterTests.assertNotNull((Object)this.propertyChangedEvent);
        SchemaGenerationBasicAdapterTests.assertNull((Object)this.propertyChangedEvent.getNewValue());
        ++this.propertiesTotal;
        ++this.modelPropertiesSize;
        this.persistenceUnitSetProperty(outputModeKey, OUTPUT_MODE_TEST_VALUE);
        this.verifyPutEvent("outputMode", OUTPUT_MODE_TEST_VALUE, this.schemaGeneration.getOutputMode());
        this.persistenceUnitSetProperty(outputModeKey, OUTPUT_MODE_TEST_VALUE_2);
        this.verifyPutEvent("outputMode", OUTPUT_MODE_TEST_VALUE_2, this.schemaGeneration.getOutputMode());
        this.clearEvent();
        this.schemaGeneration.setOutputMode(OUTPUT_MODE_TEST_VALUE);
        this.verifyPutEvent("outputMode", OUTPUT_MODE_TEST_VALUE, this.schemaGeneration.getOutputMode());
    }

    @Override
    protected PersistenceUnitProperties getModel() {
        return this.schemaGeneration;
    }

    private ListValueModel<PersistenceUnit.Property> buildPropertiesAdapter(PropertyValueModel<EclipseLinkPersistenceUnit> subjectHolder) {
        return new ListAspectAdapter<EclipseLinkPersistenceUnit, PersistenceUnit.Property>(subjectHolder, new String[]{"properties"}){

            protected ListIterator<PersistenceUnit.Property> listIterator_() {
                return ((EclipseLinkPersistenceUnit)this.subject).properties();
            }

            protected int size_() {
                return ((EclipseLinkPersistenceUnit)this.subject).propertiesSize();
            }
        };
    }

    @Override
    protected void setProperty(String propertyName, Object newValue) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        throw new UnsupportedOperationException();
    }
}

