/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.Command;
import org.eclipse.jpt.utility.CommandExecutor;
import org.eclipse.jpt.utility.internal.ThreadLocalCommandExecutor;

public class CommandExecutorTests
extends TestCase {
    public CommandExecutorTests(String name) {
        super(name);
    }

    public void testDefaultCommandExecutor() {
        TestCommand testCommand = new TestCommand();
        CommandExecutorTests.assertEquals((int)0, (int)testCommand.count);
        CommandExecutor commandExecutor = CommandExecutor.Default.instance();
        commandExecutor.execute((Command)testCommand);
        CommandExecutorTests.assertEquals((int)1, (int)testCommand.count);
    }

    public void testThreadLocalCommandExecutor() throws Exception {
        ThreadLocalCommandExecutor threadLocalCommandExecutor = new ThreadLocalCommandExecutor();
        TestRunnable testRunnable1 = new TestRunnable(threadLocalCommandExecutor, 1);
        Thread thread1 = new Thread(testRunnable1);
        thread1.run();
        TestRunnable testRunnable2 = new TestRunnable(threadLocalCommandExecutor, 2);
        Thread thread2 = new Thread(testRunnable2);
        thread2.run();
        thread1.join();
        thread2.join();
        CommandExecutorTests.assertEquals((int)1, (int)testRunnable1.testCommand.count);
        CommandExecutorTests.assertEquals((int)1, (int)testRunnable1.testCommandExecutor.count);
        CommandExecutorTests.assertEquals((int)2, (int)testRunnable2.testCommand.count);
        CommandExecutorTests.assertEquals((int)2, (int)testRunnable2.testCommandExecutor.count);
    }

    static class TestCommand
    implements Command {
        int count = 0;

        TestCommand() {
        }

        public void execute() {
            ++this.count;
        }
    }

    static class TestCommandExecutor
    implements CommandExecutor {
        int count = 0;

        TestCommandExecutor() {
        }

        public void execute(Command command) {
            ++this.count;
            command.execute();
        }
    }

    static class TestRunnable
    implements Runnable {
        final ThreadLocalCommandExecutor threadLocalCommandExecutor;
        final int executionCount;
        final TestCommand testCommand = new TestCommand();
        final TestCommandExecutor testCommandExecutor = new TestCommandExecutor();

        TestRunnable(ThreadLocalCommandExecutor threadLocalCommandExecutor, int executionCount) {
            this.threadLocalCommandExecutor = threadLocalCommandExecutor;
            this.executionCount = executionCount;
        }

        public void run() {
            this.threadLocalCommandExecutor.set((CommandExecutor)this.testCommandExecutor);
            int i = 0;
            while (i < this.executionCount) {
                this.threadLocalCommandExecutor.execute((Command)this.testCommand);
                ++i;
            }
        }
    }
}

