/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.model.value.FilteringCollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringCollectionValueModelTests
extends TestCase {
    private SimpleCollectionValueModel<String> collectionHolder;
    CollectionChangeEvent addEvent;
    CollectionChangeEvent removeEvent;
    CollectionChangeEvent collectionClearedEvent;
    CollectionChangeEvent collectionChangedEvent;
    private CollectionValueModel<String> filteredCollectionHolder;
    CollectionChangeEvent filteredAddEvent;
    CollectionChangeEvent filteredRemoveEvent;
    CollectionChangeEvent filteredCollectionClearedEvent;
    CollectionChangeEvent filteredCollectionChangedEvent;

    public FilteringCollectionValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.collectionHolder = new SimpleCollectionValueModel(this.buildCollection());
        this.filteredCollectionHolder = new FilteringCollectionValueModel(this.collectionHolder, this.buildFilter());
    }

    private Collection<String> buildCollection() {
        Vector<String> collection = new Vector<String>();
        collection.add("foo");
        return collection;
    }

    private Filter<String> buildFilter() {
        return new Filter<String>(){

            public boolean accept(String s) {
                return s.startsWith("b");
            }
        };
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator() {
        this.filteredCollectionHolder.addCollectionChangeListener("values", this.buildFilteredListener());
        FilteringCollectionValueModelTests.assertEquals((String)"foo", (String)((String)this.collectionHolder.iterator().next()));
        FilteringCollectionValueModelTests.assertFalse((boolean)this.filteredCollectionHolder.iterator().hasNext());
        this.collectionHolder.add((Object)"bar");
        Iterator collectionHolderValue = this.collectionHolder.iterator();
        FilteringCollectionValueModelTests.assertEquals((String)"foo", (String)((String)collectionHolderValue.next()));
        FilteringCollectionValueModelTests.assertEquals((String)"bar", (String)((String)collectionHolderValue.next()));
        FilteringCollectionValueModelTests.assertTrue((boolean)this.filteredCollectionHolder.iterator().hasNext());
        FilteringCollectionValueModelTests.assertEquals((String)"bar", (String)((String)this.filteredCollectionHolder.iterator().next()));
        this.collectionHolder.remove((Object)"bar");
        FilteringCollectionValueModelTests.assertEquals((String)"foo", (String)((String)this.collectionHolder.iterator().next()));
        FilteringCollectionValueModelTests.assertFalse((boolean)this.filteredCollectionHolder.iterator().hasNext());
        this.collectionHolder.remove((Object)"foo");
        FilteringCollectionValueModelTests.assertFalse((boolean)this.collectionHolder.iterator().hasNext());
        FilteringCollectionValueModelTests.assertFalse((boolean)this.filteredCollectionHolder.iterator().hasNext());
        this.collectionHolder.add((Object)"foo");
        FilteringCollectionValueModelTests.assertEquals((String)"foo", (String)((String)this.collectionHolder.iterator().next()));
        FilteringCollectionValueModelTests.assertFalse((boolean)this.filteredCollectionHolder.iterator().hasNext());
    }

    public void testSetValue() {
        this.filteredCollectionHolder.addCollectionChangeListener("values", this.buildFilteredListener());
        Vector<String> newCollection = new Vector<String>();
        newCollection.add("fox");
        newCollection.add("baz");
        this.collectionHolder.setCollection(newCollection);
        Iterator collectionValues = this.collectionHolder.iterator();
        FilteringCollectionValueModelTests.assertEquals((String)"fox", (String)((String)collectionValues.next()));
        FilteringCollectionValueModelTests.assertEquals((String)"baz", (String)((String)collectionValues.next()));
        Iterator filteredCollectionValues = this.filteredCollectionHolder.iterator();
        FilteringCollectionValueModelTests.assertEquals((String)"baz", (String)((String)filteredCollectionValues.next()));
        FilteringCollectionValueModelTests.assertFalse((boolean)filteredCollectionValues.hasNext());
    }

    public void testLazyListening() {
        FilteringCollectionValueModelTests.assertTrue((boolean)this.collectionHolder.hasNoCollectionChangeListeners("values"));
        CollectionChangeListener listener = this.buildFilteredListener();
        this.filteredCollectionHolder.addCollectionChangeListener(listener);
        FilteringCollectionValueModelTests.assertTrue((boolean)this.collectionHolder.hasAnyCollectionChangeListeners("values"));
        this.filteredCollectionHolder.removeCollectionChangeListener(listener);
        FilteringCollectionValueModelTests.assertTrue((boolean)this.collectionHolder.hasNoCollectionChangeListeners("values"));
        this.filteredCollectionHolder.addCollectionChangeListener("values", listener);
        FilteringCollectionValueModelTests.assertTrue((boolean)this.collectionHolder.hasAnyCollectionChangeListeners("values"));
        this.filteredCollectionHolder.removeCollectionChangeListener("values", listener);
        FilteringCollectionValueModelTests.assertTrue((boolean)this.collectionHolder.hasNoCollectionChangeListeners("values"));
    }

    public void testCollectionChange1() {
        this.collectionHolder.addCollectionChangeListener(this.buildListener());
        this.filteredCollectionHolder.addCollectionChangeListener(this.buildFilteredListener());
        this.verifyCollectionChanges();
    }

    public void testCollectionChange2() {
        this.collectionHolder.addCollectionChangeListener("values", this.buildListener());
        this.filteredCollectionHolder.addCollectionChangeListener("values", this.buildFilteredListener());
        this.verifyCollectionChanges();
    }

    private void clearEvents() {
        this.addEvent = null;
        this.removeEvent = null;
        this.collectionClearedEvent = null;
        this.collectionChangedEvent = null;
        this.filteredAddEvent = null;
        this.filteredRemoveEvent = null;
        this.filteredCollectionClearedEvent = null;
        this.filteredCollectionChangedEvent = null;
    }

    private void verifyCollectionChanges() {
        this.clearEvents();
        this.collectionHolder.add((Object)"bar");
        Vector<String> tempCollection = new Vector<String>();
        tempCollection.add("bar");
        this.verifyEvent(this.addEvent, this.collectionHolder, tempCollection);
        this.verifyEvent(this.filteredAddEvent, this.filteredCollectionHolder, tempCollection);
        this.clearEvents();
        this.collectionHolder.remove((Object)"foo");
        tempCollection.remove("bar");
        tempCollection.add("foo");
        this.verifyEvent(this.removeEvent, this.collectionHolder, tempCollection);
        FilteringCollectionValueModelTests.assertNull((Object)this.filteredRemoveEvent);
        this.clearEvents();
        this.collectionHolder.remove((Object)"bar");
        tempCollection.add("bar");
        tempCollection.remove("foo");
        this.verifyEvent(this.removeEvent, this.collectionHolder, tempCollection);
        this.verifyEvent(this.filteredRemoveEvent, this.filteredCollectionHolder, tempCollection);
        this.clearEvents();
        this.collectionHolder.add((Object)"foo");
        tempCollection.remove("bar");
        tempCollection.add("foo");
        this.verifyEvent(this.addEvent, this.collectionHolder, tempCollection);
        FilteringCollectionValueModelTests.assertNull((Object)this.filteredAddEvent);
        this.clearEvents();
        Vector<String> newCollection = new Vector<String>();
        newCollection.add("fox");
        newCollection.add("baz");
        this.collectionHolder.setCollection(newCollection);
        this.verifyEvent(this.collectionChangedEvent, this.collectionHolder, new Vector());
        tempCollection.remove("foo");
        tempCollection.add("baz");
        this.verifyEvent(this.filteredCollectionChangedEvent, this.filteredCollectionHolder, new Vector());
    }

    private CollectionChangeListener buildListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                FilteringCollectionValueModelTests.this.addEvent = e;
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                FilteringCollectionValueModelTests.this.removeEvent = e;
            }

            public void collectionCleared(CollectionChangeEvent e) {
                FilteringCollectionValueModelTests.this.collectionClearedEvent = e;
            }

            public void collectionChanged(CollectionChangeEvent e) {
                FilteringCollectionValueModelTests.this.collectionChangedEvent = e;
            }
        };
    }

    private CollectionChangeListener buildFilteredListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                FilteringCollectionValueModelTests.this.filteredAddEvent = e;
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                FilteringCollectionValueModelTests.this.filteredRemoveEvent = e;
            }

            public void collectionCleared(CollectionChangeEvent e) {
                FilteringCollectionValueModelTests.this.filteredCollectionClearedEvent = e;
            }

            public void collectionChanged(CollectionChangeEvent e) {
                FilteringCollectionValueModelTests.this.filteredCollectionChangedEvent = e;
            }
        };
    }

    private void verifyEvent(CollectionChangeEvent event, Object source, Object items) {
        FilteringCollectionValueModelTests.assertEquals((Object)source, (Object)event.getSource());
        FilteringCollectionValueModelTests.assertEquals((String)"values", (String)event.getCollectionName());
        FilteringCollectionValueModelTests.assertEquals((Object)items, (Object)CollectionTools.vector((Iterator)event.items()));
    }

    public void testRemoveFilteredItem() {
        SimpleCollectionValueModel tiHolder = new SimpleCollectionValueModel(this.buildCollection2());
        FilteringCollectionValueModel filteredTIHolder = new FilteringCollectionValueModel((CollectionValueModel)tiHolder, this.buildFilter2());
        filteredTIHolder.addCollectionChangeListener("values", this.buildFilteredListener());
        FilteringCollectionValueModelTests.assertEquals((int)0, (int)filteredTIHolder.size());
        tiHolder.add((Object)new TestItem("bar"));
        FilteringCollectionValueModelTests.assertEquals((int)1, (int)filteredTIHolder.size());
        TestItem baz = new TestItem("baz");
        tiHolder.add((Object)baz);
        FilteringCollectionValueModelTests.assertEquals((int)2, (int)filteredTIHolder.size());
        baz.name = "jaz";
        tiHolder.remove((Object)baz);
        FilteringCollectionValueModelTests.assertEquals((int)1, (int)filteredTIHolder.size());
    }

    private Collection<TestItem> buildCollection2() {
        Vector<TestItem> collection = new Vector<TestItem>();
        collection.add(new TestItem("foo"));
        return collection;
    }

    private Filter<TestItem> buildFilter2() {
        return new Filter<TestItem>(){

            public boolean accept(TestItem ti) {
                return ti.name.startsWith("b");
            }
        };
    }

    private class TestItem {
        String name;

        TestItem(String name) {
            this.name = name;
        }
    }
}

