/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.runtime.tests.debug;

import junit.framework.TestCase;
import org.eclipse.jst.jsf.common.runtime.internal.debug.RenderAttribute;
import org.eclipse.jst.jsf.common.runtime.internal.debug.RenderNode;

public class TestRenderNode
extends TestCase {
    private RenderNode _renderNode;

    protected void setUp() throws Exception {
        super.setUp();
        this._renderNode = new RenderNode("org.eclipse.jsf.jst.CompType", "th");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetComponentId() {
        TestRenderNode.assertEquals((String)"org.eclipse.jsf.jst.CompType", (String)this._renderNode.getComponentId());
    }

    public void testGetChildren() {
        RenderNode child1 = new RenderNode("org.eclipse.jsf.jst.CompType2", "a");
        RenderNode child2 = new RenderNode("org.eclipse.jst.jst.CompType3", "br");
        this._renderNode.getChildren().add(child1);
        this._renderNode.getChildren().add(child2);
        TestRenderNode.assertEquals((int)2, (int)this._renderNode.getChildren().size());
        TestRenderNode.verifySame(child1, (RenderNode)this._renderNode.getChildren().get(0));
        TestRenderNode.verifySame(child2, (RenderNode)this._renderNode.getChildren().get(1));
    }

    public void testGetRenderedNodeName() {
        TestRenderNode.assertEquals((String)"th", (String)this._renderNode.getRenderedNodeName());
    }

    public void testGetRenderedAttributes() {
        RenderAttribute attribute1 = new RenderAttribute("id", "blah", null);
        this._renderNode.getRenderedAttributes().add(attribute1);
        RenderAttribute attribute2 = new RenderAttribute("value", "5", "Value");
        this._renderNode.getRenderedAttributes().add(attribute2);
        TestRenderNode.verifySame(attribute1, (RenderAttribute)this._renderNode.getRenderedAttributes().get(0));
        TestRenderNode.verifySame(attribute2, (RenderAttribute)this._renderNode.getRenderedAttributes().get(1));
    }

    public static void verifySame(RenderNode truth, RenderNode check) {
        if (truth == check) {
            return;
        }
        TestRenderNode.assertEquals((String)truth.getComponentId(), (String)check.getComponentId());
        TestRenderNode.assertEquals((String)truth.getRenderedNodeName(), (String)check.getRenderedNodeName());
        TestRenderNode.assertEquals((int)truth.getChildren().size(), (int)check.getChildren().size());
        int i = 0;
        while (i < check.getChildren().size()) {
            TestRenderNode.verifySame((RenderNode)truth.getChildren().get(i), (RenderNode)check.getChildren().get(i));
            ++i;
        }
        TestRenderNode.assertEquals((int)truth.getRenderedAttributes().size(), (int)check.getChildren().size());
        i = 0;
        while (i < check.getRenderedAttributes().size()) {
            TestRenderNode.verifySame((RenderAttribute)truth.getRenderedAttributes().get(i), (RenderAttribute)check.getRenderedAttributes().get(i));
            ++i;
        }
    }

    public static void verifySame(RenderAttribute truth, RenderAttribute check) {
        TestRenderNode.assertEquals((String)truth.getName(), (String)check.getName());
        TestRenderNode.assertEquals((String)truth.getPropertyName(), (String)check.getPropertyName());
        TestRenderNode.assertEquals((String)truth.getValue(), (String)check.getValue());
    }
}

