/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.facesconfig.emf.AttributeType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadAttributeComponentTestCase
extends BaseReadTestCase {
    public ReadAttributeComponentTestCase(String name) {
        super(name);
    }

    public void testSingleAttribute() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attribute1 = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeComponentTestCase.assertNotNull((Object)attribute1);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private ComponentType getComponent1(FacesConfigType facesConfigType) {
        return (ComponentType)FacesConfigModelUtil.findEObjectElementById((List)facesConfigType.getComponent(), "component1");
    }

    private AttributeType getAttribute1(FacesConfigType facesConfigType) {
        ComponentType component1 = this.getComponent1(facesConfigType);
        ReadAttributeComponentTestCase.assertNotNull((Object)component1);
        return (AttributeType)FacesConfigModelUtil.findEObjectElementById((List)component1.getAttribute(), "componentAttribute1");
    }

    public void testDescription() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeComponentTestCase.assertNotNull((Object)attributeType);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)attributeType.getDescription(), "componentAttribute1_descripton1");
            ReadAttributeComponentTestCase.assertEquals((String)"attribute-description", (String)descType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDisplayName() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeComponentTestCase.assertNotNull((Object)attributeType);
            DisplayNameType displayNameType = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)attributeType.getDisplayName(), "componentAttribute1_displayName1");
            ReadAttributeComponentTestCase.assertEquals((String)"attribute-display-name", (String)displayNameType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testIcon() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attrType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeComponentTestCase.assertNotNull((Object)attrType);
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)attrType.getIcon(), "componentAttribute1_icon1");
            ReadAttributeComponentTestCase.assertNotNull((Object)iconType);
            ReadAttributeComponentTestCase.assertEquals((String)"attribute-small-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadAttributeComponentTestCase.assertEquals((String)"attribute-large-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAttributeNameAndClass() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attribute1 = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeComponentTestCase.assertNotNull((Object)attribute1);
            ReadAttributeComponentTestCase.assertEquals((String)"attribute-name", (String)attribute1.getAttributeName().getTextContent());
            ReadAttributeComponentTestCase.assertEquals((String)"attribute-class", (String)attribute1.getAttributeClass().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testSuggestedValue() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeComponentTestCase.assertEquals((String)"attribute-suggested-value", (String)attributeType.getSuggestedValue().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDefaultValue() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeComponentTestCase.assertEquals((String)"value5", (String)attributeType.getDefaultValue().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAttributeExtension() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            if (edit.getFacesConfig() != null) {
                EList comp = edit.getFacesConfig().getComponent();
                ReadAttributeComponentTestCase.assertTrue((!comp.isEmpty() ? 1 : 0) != 0);
                int i = 0;
                while (i < comp.size()) {
                    ComponentType compType = (ComponentType)comp.get(i);
                    ReadAttributeComponentTestCase.assertTrue((!compType.getAttribute().isEmpty() ? 1 : 0) != 0);
                    EList attr = compType.getAttribute();
                    int k = 0;
                    while (k < attr.size()) {
                        AttributeType attrType = (AttributeType)attr.get(k);
                        EList ext = attrType.getAttributeExtension();
                        ReadAttributeComponentTestCase.assertTrue((ext.size() != 0 ? 1 : 0) != 0);
                        ++k;
                    }
                    ++i;
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

